/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ProviderUsage;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectFactory {
    private DBObjectProvider m_pro;

    protected DBObjectFactory(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    private Schema getSchema(DBObject parent) {
        Schema schema;
        Schema schema2 = schema = parent instanceof Schema ? (Schema)parent : DBUtil.getSchema(parent);
        if (schema == null) {
            try {
                schema = this.getProvider().getDefaultSchema();
            }
            catch (DBException dbe) {
                this.getLogger().warning("Couldn't get default schema: " + dbe.getMessage());
            }
        }
        return schema;
    }

    public <T extends DBObject> T newObject(T template) {
        Table parent = template instanceof Index ? ((Index)template).getTable() : null;
        return this.newObject(template, (DBObject)parent);
    }

    public <T extends DBObject> T newObject(T template, DBObject parent) {
        return this.newObject(template, parent, true);
    }

    private <T extends DBObject> T newObject(T template, DBObject parent, boolean initialiseProperties) {
        DBObject obj = null;
        try {
            if (template != null) {
                obj = TemplateExpander.initialiseObject(template);
                if (template instanceof SchemaObject && Boolean.TRUE.equals(template.getProperty("public")) && parent == null) {
                    parent = ((SchemaObject)template).getSchema();
                }
                this.setup(obj, parent, initialiseProperties);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "cannot instantiate new schema object", e);
        }
        return (T)obj;
    }

    public <T extends DBObject> T newObject(Class<T> clz) {
        return this.newObject(clz, null);
    }

    public <T extends DBObject> T newObject(Class<T> clz, DBObject parent) {
        return this.newObject(clz, parent, true);
    }

    public <T extends DBObject> T newObject(Class<T> clz, DBObject parent, boolean useDefaultTemplate) {
        return this.newObject(clz, parent, useDefaultTemplate, true);
    }

    public <T extends DBObject> T newObject(Class<T> clz, DBObject parent, boolean useDefaultTemplate, boolean initialiseProperties) {
        DBObject obj = null;
        try {
            DBObject template;
            String type;
            if (useDefaultTemplate && (type = Metadata.getType(clz)) != null && (template = this.m_pro.getDefaultTemplateForType(type)) != null) {
                obj = this.newObject(template, parent);
            }
            if (obj == null) {
                obj = (DBObject)clz.newInstance();
                this.setup(obj, parent, initialiseProperties);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Cannot instantiate new schema object", e);
        }
        return (T)obj;
    }

    private void setup(DBObject obj, DBObject parent, boolean initialiseProperties) {
        if (obj instanceof SchemaObject) {
            ((SchemaObject)obj).setSchema(this.getSchema(parent));
        }
        if (!(parent instanceof Schema) && obj instanceof ChildDBObject) {
            ((ChildDBObject)obj).setParent(parent);
        }
        if (initialiseProperties) {
            this.initialiseProperties(obj);
            for (DBObject child : obj.getOwnedObjects("COLUMN", "CONSTRAINT")) {
                this.initialiseProperties(child);
            }
        }
        this.ensureDerivedPropertyBuilder(obj);
        if (obj instanceof ProviderUsage) {
            ((ProviderUsage)((Object)obj)).setProvider(this.getProvider());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DerivedPropertyBuilder ensureDerivedPropertyBuilder(DBObject obj) {
        DerivedPropertyBuilder retval = null;
        if (obj != null) {
            if (obj instanceof AbstractBuildableObject) {
                AbstractBuildableObject.BuildablePropertySupport props;
                AbstractBuildableObject abobj = (AbstractBuildableObject)obj;
                AbstractBuildableObject.BuildablePropertySupport buildablePropertySupport = props = abobj.getPropertySupport();
                synchronized (buildablePropertySupport) {
                    DerivedPropertyBuilder existing = props.getDerivedPropertyBuilder();
                    if (existing == null || !this.isValidDerivedPropertyProvider(abobj, existing.getProvider())) {
                        retval = this.m_pro.getDescriptor().getDerivedPropertyBuilder(abobj.getClass(), this.m_pro);
                        if (retval != null) {
                            props.setDerivedPropertyBuilder(retval);
                        }
                    } else {
                        retval = existing;
                    }
                }
            }
            if (obj instanceof AbstractDBObject) {
                for (DBObject kid : ((AbstractDBObject)obj).getPropertySupport().getOwnedObjects(null)) {
                    this.ensureDerivedPropertyBuilder(kid);
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractBuildableObject> boolean setDerivedPropertyBuilder(T obj, DerivedPropertyBuilder<? super T> builder) {
        boolean retval = false;
        if (obj != null && builder != null && builder.getProvider() == this.m_pro) {
            AbstractBuildableObject.BuildablePropertySupport props;
            AbstractBuildableObject.BuildablePropertySupport buildablePropertySupport = props = obj.getPropertySupport();
            synchronized (buildablePropertySupport) {
                DerivedPropertyBuilder existing = props.getDerivedPropertyBuilder();
                if (existing == builder) {
                    retval = true;
                } else if (existing == null) {
                    props.setDerivedPropertyBuilder(builder);
                    retval = true;
                }
            }
        }
        return retval;
    }

    private boolean isValidDerivedPropertyProvider(AbstractBuildableObject obj, DBObjectProvider other) {
        DBObjectProvider objPro;
        DBObjectID id;
        boolean retval;
        boolean bl = retval = this.m_pro == other;
        if (!retval && (id = obj.getID()) instanceof BaseObjectID && (objPro = ((BaseObjectID)id).getProvider()) == other) {
            retval = true;
        }
        return retval;
    }

    @Deprecated
    public Object getExternalDefaultValue(DBObject obj, String propertyName) {
        DatabaseDescriptor dd = this.getProvider().getDescriptor();
        return this.getValueImpl(obj, propertyName, dd.getExternalPropertyDefaulters(this.getProvider()));
    }

    public Object getInitialValue(DBObject obj, String propertyName) {
        DatabaseDescriptor dd = this.getProvider().getDescriptor();
        return this.getValueImpl(obj, propertyName, dd.getPropertyInitializers(this.getProvider()));
    }

    private Object getValueImpl(DBObject obj, String propertyName, List<PropertyInitializer> piList) {
        if (piList != null) {
            for (PropertyInitializer pi : piList) {
                String[] propNames = pi.getPropertyNames(obj.getClass());
                if (propNames == null) continue;
                for (String propName : propNames) {
                    if (!propertyName.equals(propName)) continue;
                    try {
                        return pi.getPropertyInitialValue(obj, propName);
                    }
                    catch (PropertyInitializer.InitializationVeto e) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private void initialiseProperties(DBObject obj) {
        DBObjectID id = obj.getID();
        if (id == null) {
            id = TemporaryObjectID.createID(obj);
            obj.setID(id);
        }
        DBObjectProvider pro = this.getProvider();
        DatabaseDescriptor dd = pro.getDescriptor();
        HashSet<String> done = new HashSet<String>();
        List<PropertyInitializer> piList = dd.getPropertyInitializers(pro);
        for (PropertyInitializer pi : piList) {
            String[] propNames = pi.getPropertyNames(obj.getClass());
            if (propNames == null) continue;
            for (String propName : propNames) {
                if (done.contains(propName)) continue;
                PropertyHelper help = new PropertyHelper(this.m_pro);
                try {
                    if (obj instanceof SystemObject && !pro.getPropertyManager().canCreateProperty((SystemObject)obj, propName)) continue;
                    Object value = pi.getPropertyInitialValue(obj, propName);
                    help.setPropertyValue(obj, propName, value);
                    done.add(propName);
                }
                catch (PropertyInitializer.InitializationVeto e) {
                    // empty catch block
                }
            }
        }
    }

    public void ensureSchema(SchemaObject obj) {
        Schema objSchema = obj.getSchema();
        if (objSchema != null) {
            try {
                Schema proSchema = this.getProvider().getSchema(objSchema.getName());
                if (proSchema != null && proSchema != objSchema) {
                    obj.setSchema(proSchema);
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger(this).log(Level.WARNING, dbe.getMessage());
            }
        }
    }

    public void ensureIDs(Collection<? extends DBObject> objs, Difference diff) {
        Map<DBObjectID, DBObjectID> globalIDMap = this.newIDMap();
        if (diff != null) {
            this.populateIDMap(diff, globalIDMap);
        }
        this.ensureIDsImpl(objs, globalIDMap, false);
    }

    public DBObjectID ensureID(DBObject obj, boolean recurse, boolean forceNames) {
        DBObjectID retval;
        if (recurse) {
            this.ensureIDsImpl(Collections.singletonList(obj), this.newIDMap(), forceNames);
            retval = obj.getID();
        } else {
            retval = this.ensureIDImpl(obj, recurse, true, forceNames, null, null);
        }
        return retval;
    }

    private void ensureIDsImpl(Collection<? extends DBObject> objs, Map<DBObjectID, DBObjectID> globalIDMap, boolean loadOnly) {
        ArrayList<DBObject> referencingObjects = new ArrayList<DBObject>();
        for (DBObject dBObject : objs) {
            if (dBObject == null) continue;
            this.ensureIDImpl(dBObject, true, false, loadOnly, referencingObjects, globalIDMap);
        }
        for (DBObject dBObject : referencingObjects) {
            this.checkReferences(dBObject, this.getReferenceIDs(dBObject), globalIDMap);
        }
    }

    private DBObjectID ensureIDImpl(DBObject obj, boolean deep, boolean top, boolean forceNames, Collection<DBObject> referencingObjects, Map<DBObjectID, DBObjectID> globalIDMap) {
        Collection<DBObjectID> refIDs;
        if (obj instanceof ProviderUsage) {
            ((ProviderUsage)((Object)obj)).setProvider(this.getProvider());
        }
        BaseObjectID retval = null;
        DBObjectID id = this.getObjectID(obj);
        DBObjectID parentID = null;
        DBObject parent = obj.getParent();
        if (top && parent != null) {
            parentID = this.ensureID(parent, false, forceNames);
        } else if (deep && !top && parent != null) {
            parentID = this.findParentID(parent.getID());
        }
        if (obj instanceof SQLFragment) {
            this.ensureProvider(obj, true);
        }
        if (id == null) {
            retval = this.createID(obj, parentID);
        } else if (id instanceof TemporaryObjectID) {
            DBObject original = TemporaryObjectID.findOriginalObject((TemporaryObjectID)id);
            if (original == null) {
                retval = this.createID(obj, parentID);
            } else {
                DBObjectID origID = original.getID();
                if (origID instanceof BaseObjectID) {
                    retval = (BaseObjectID)origID;
                    retval.setParent(parentID);
                    this.ensureProvider(retval);
                } else {
                    retval = this.createID(obj, parentID);
                }
                if (origID != null && globalIDMap != null) {
                    globalIDMap.put(origID, retval);
                }
            }
            if (globalIDMap != null) {
                globalIDMap.put(id, retval);
            }
        } else if (id instanceof BaseObjectID) {
            if (id.getType() == null) {
                ((BaseObjectID)id).setType(obj.getType());
            }
            retval = ModelUtil.areDifferent((Object)parentID, (Object)id.getParent()) ? (BaseObjectID)id.copyTo(null) : (BaseObjectID)id;
            this.ensureProvider(retval);
            retval.setParent(parentID);
            if (retval != id) {
                globalIDMap.put(id, retval);
            }
        }
        if (retval instanceof NameBasedID) {
            String sName;
            Schema s;
            String oldSchemaName;
            NameBasedID oldID = (NameBasedID)retval;
            String newSchemaName = null;
            if (obj instanceof SchemaObject && (oldSchemaName = oldID.getSchemaName()) != null && (s = ((SchemaObject)obj).getSchema()) != null && ModelUtil.areDifferent((Object)(sName = s.getName()), (Object)oldSchemaName)) {
                newSchemaName = sName;
            }
            String newObjectName = null;
            String objName = this.getName(obj, forceNames);
            if (ModelUtil.areDifferent((Object)objName, (Object)oldID.getName())) {
                newObjectName = obj.getName();
            }
            if (newSchemaName != null || newObjectName != null) {
                retval = (NameBasedID)oldID.copyTo(null);
                if (newSchemaName != null) {
                    retval.setSchemaName(newSchemaName);
                }
                if (newObjectName != null) {
                    retval.setName(newObjectName);
                }
                if (globalIDMap != null) {
                    globalIDMap.put(oldID, retval);
                }
            }
        }
        if (retval != null) {
            obj.setID(retval);
        }
        if (obj instanceof AbstractDBObject && !(refIDs = this.getReferenceIDs(obj)).isEmpty()) {
            if (referencingObjects != null) {
                referencingObjects.add(obj);
            } else {
                this.checkReferences(obj, refIDs, globalIDMap);
            }
        }
        if (deep) {
            Schema s;
            DBObject[] kids = obj.getOwnedObjects();
            for (int i = 0; i < kids.length; ++i) {
                this.ensureIDImpl(kids[i], true, false, forceNames, referencingObjects, globalIDMap);
            }
            if (obj instanceof SchemaObject && (s = ((SchemaObject)obj).getSchema()) != null) {
                try {
                    Schema realS = this.getProvider().getSchema(s.getName());
                    if (realS != null && realS != s) {
                        ((SchemaObject)obj).setSchema(realS);
                    }
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
        }
        if (retval != null && retval.getParent() instanceof TemporaryObjectID) {
            DBLog.getLogger().warning("Parent of " + retval.toString() + " is a TemporaryObjectID");
        }
        if (retval instanceof BaseObjectID) {
            this.ensureBaseInfo(retval, obj, forceNames);
        }
        this.ensureDerivedPropertyBuilder(obj);
        return retval;
    }

    private DBObjectID findParentID(DBObjectID parentID) {
        DBObjectID retval = null;
        if (parentID instanceof BaseObjectID) {
            retval = parentID;
        }
        return retval;
    }

    private BaseObjectID ensureProviderCanCopy(BaseObjectID refID, DBObjectProvider pro) {
        DBObjectProvider existing = refID.getProvider();
        if (existing != null && existing != pro) {
            BaseObjectID id = BaseObjectID.copyWithNewProvider(refID, (AbstractDBObjectProvider)pro);
            return id;
        }
        refID.setProvider(pro);
        return null;
    }

    private void checkReferences(DBObject obj, Collection<DBObjectID> refIDs, Map<DBObjectID, DBObjectID> globalIDMap) {
        Map<DBObjectID, DBObjectID> idMap = this.newIDMap();
        for (DBObjectID ref : refIDs) {
            DBObjectID other;
            this.ensureProvider(ref);
            if (ref instanceof BaseObjectID) {
                BaseObjectID copyID;
                BaseObjectID refID = (BaseObjectID)ref;
                DBObjectID refParID = refID.getParent();
                if (refParID instanceof TemporaryObjectID) {
                    DBObjectID newRef = this.getRefIDForTempID((TemporaryObjectID)refParID, idMap, globalIDMap);
                    refID.setParent(newRef);
                }
                if ((copyID = this.ensureProviderCanCopy(refID, this.getProvider())) != null) {
                    idMap.put(refID, copyID);
                }
            } else if (ref instanceof TemporaryObjectID) {
                this.getRefIDForTempID((TemporaryObjectID)ref, idMap, globalIDMap);
            }
            if (globalIDMap == null || idMap.containsKey(ref) || (other = this.find(ref, globalIDMap)) == null) continue;
            idMap.put(ref, other);
        }
        if (idMap.size() > 0) {
            obj.replaceReferenceIDs(idMap);
        }
    }

    private DBObjectID find(DBObjectID findMe, Map<DBObjectID, DBObjectID> globalIDMap) {
        DBObjectID retval = null;
        if (globalIDMap != null) {
            DBObjectID found;
            DBObjectIDSet foundAlready = new DBObjectIDSet(true);
            DBObjectID mapped = findMe;
            while (mapped != null && (found = globalIDMap.get(mapped)) != null) {
                foundAlready.add(mapped);
                mapped = found;
                if (!foundAlready.contains(mapped)) continue;
                break;
            }
            if (mapped != findMe && mapped != null) {
                retval = mapped;
            }
        }
        return retval;
    }

    private DBObjectID getRefIDForTempID(TemporaryObjectID tempID, Map<DBObjectID, DBObjectID> idMap, Map<DBObjectID, DBObjectID> globalIDMap) {
        DBObjectID mapped;
        DBObjectID topMostTempID;
        DBObjectID newRef = this.find(tempID, globalIDMap);
        if (newRef == null && (topMostTempID = this.findTopMostTempID(tempID)) != null && topMostTempID != tempID && globalIDMap != null && (mapped = globalIDMap.get(topMostTempID)) != null) {
            newRef = mapped;
        }
        if (newRef == null) {
            DBObject ref = null;
            try {
                ref = tempID.resolveOriginalID();
            }
            catch (DBException e) {
                DBLog.getLogger().log(Level.WARNING, "error resolving id", e);
            }
            if (ref == null) {
                try {
                    ref = tempID.resolveID();
                }
                catch (DBException ex) {
                    DBLog.getLogger().log(Level.WARNING, "error resolving id", ex);
                }
            }
            if (ref != null && !((newRef = ref.getID()) instanceof BaseObjectID)) {
                try {
                    DBObject lastChance = DBUtil.getProviderDefinition(ref, this.getProvider());
                    if (lastChance != null) {
                        newRef = lastChance.getID();
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger().log(Level.WARNING, "error finding object", dbe);
                }
            }
            if (!(newRef instanceof BaseObjectID)) {
                DBLog.getLogger().warning("DBObjectFactory: found a TemporaryID that isn't fixed up: " + (newRef == null ? "null" : newRef.toString()));
            }
        }
        if (newRef != null) {
            idMap.put(tempID, newRef);
            if (globalIDMap != null) {
                globalIDMap.put(tempID, newRef);
            }
        } else {
            DBLog.getLogger().warning("Found a TemporaryObjectID that doesn't resolve.");
        }
        return newRef;
    }

    private DBObjectID findTopMostTempID(TemporaryObjectID tempID) {
        try {
            DBObject orig = tempID.resolveOriginalID();
            if (orig != null) {
                DBObjectID id = orig.getID();
                if (id instanceof TemporaryObjectID) {
                    return this.findTopMostTempID((TemporaryObjectID)id);
                }
                if (id != null) {
                    return id;
                }
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return tempID;
    }

    private void ensureProvider(DBObject obj, boolean recurse) {
        this.ensureProvider(obj.getID());
        for (DBObjectID refID : obj.getReferenceIDs()) {
            this.ensureProvider(refID);
        }
        if (recurse) {
            for (DBObject kid : obj.getOwnedObjects()) {
                this.ensureProvider(kid, true);
            }
        }
    }

    protected boolean isValidID(DBObjectID id) {
        return id instanceof BaseObjectID;
    }

    protected boolean useIdentifierBasedIDs(DBObject obj) {
        return false;
    }

    protected BaseObjectID createID(DBObject obj) {
        BaseObjectID retval = this.useIdentifierBasedIDs(obj) ? new IdentifierBasedID(obj, (Object)DBUtil.createUUID(), (AbstractDBObjectProvider)this.getProvider()) : new NameBasedID(obj, (AbstractDBObjectProvider)this.getProvider());
        obj.setID(retval);
        return retval;
    }

    protected BaseObjectID createID(DBObject obj, DBObjectID parent) {
        BaseObjectID retval = null;
        if (parent != null && !this.isValidID(parent)) {
            throw new IllegalStateException("Invalid object and/or parent sent to ID creation");
        }
        retval = this.createID(obj);
        retval.setParent(parent);
        return retval;
    }

    private void populateIDMap(Difference diff, Map<DBObjectID, DBObjectID> globalIDMap) {
        Object orig = diff.getOriginalObject();
        Object update = diff.getUpdatedObject();
        if (orig instanceof DBObject && update instanceof DBObject) {
            DBObjectID origID = ((DBObject)orig).getID();
            DBObjectID dBObjectID = ((DBObject)update).getID();
            if (origID != null && dBObjectID != null && !origID.equals(dBObjectID, true)) {
                globalIDMap.put(dBObjectID, origID);
            }
        }
        for (Difference difference : diff.getChildren()) {
            this.populateIDMap(difference, globalIDMap);
        }
    }

    private Map<DBObjectID, DBObjectID> newIDMap() {
        return new DBObjectIDMap<DBObjectID>(true);
    }

    protected void ensureBaseInfo(BaseObjectID id, DBObject obj, boolean forceName) {
        Schema s;
        DBObject parent;
        DBObjectID parentID;
        String name;
        if (id.getType() == null) {
            id.setType(obj.getType());
        }
        if ((name = this.getName(obj, forceName)) != null) {
            id.setName(name);
        }
        DBObjectID dBObjectID = parentID = (parent = obj.getParent()) == null ? null : this.findParentID(this.getObjectID(parent));
        if (parentID != null) {
            id.setParent(parentID);
        }
        if (obj instanceof SchemaObject && (s = ((SchemaObject)obj).getSchema()) != null) {
            id.setSchemaName(s.getName());
        }
    }

    private boolean isNameTransient(DBObject obj) {
        PropertyInfo info = this.getProvider().getPropertyManager().findPropertyInfo(obj.getClass(), "name");
        return info == null || info.isTransient();
    }

    protected final String getName(DBObject obj, boolean forceNames) {
        String retval = (String)obj.getProperty("name");
        if (retval == null && (forceNames || !this.isNameTransient(obj))) {
            retval = obj.getName();
        }
        return retval;
    }

    public final void ensureProvider(DBObjectID id) {
        if (id instanceof BaseObjectID && id != null && ((BaseObjectID)id).getProvider() == null) {
            ((BaseObjectID)id).setProvider(this.getProvider());
        }
        if (id instanceof DataTypeID) {
            ((DataTypeID)id).ensureProvider(this.getProvider());
        }
    }

    protected final DBObjectID getObjectID(DBObject obj) {
        return ((AbstractDBObject)obj).obtainActualID();
    }

    protected final Collection<DBObjectID> getReferenceIDs(DBObject obj) {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
        ((AbstractDBObject)obj).getPropertySupport().addAllReferenceIDs(retval);
        return retval;
    }
}

