/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObjectIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectIterator
implements Iterator<DBObject> {
    private boolean m_started;
    private String[] m_types;
    private final Iterator<? extends DBObject> m_parentIter;
    private DBObject m_currentParent;
    private Iterator<DBObject> m_childObjIter;
    private DBObject m_currObj;

    public DBObjectIterator(DBObject parent) {
        this.m_parentIter = Collections.singleton(parent).iterator();
    }

    public DBObjectIterator(Iterator<? extends DBObject> parentIter) {
        this.m_parentIter = parentIter;
    }

    public void setTypes(String ... types) {
        if (this.m_started) {
            throw new IllegalStateException("Cannot modify iterator parameters after it has been started");
        }
        this.m_types = types;
    }

    private void start() {
        if (!this.m_started) {
            this.m_started = true;
            this.nextParent();
        }
    }

    private void nextParent() {
        this.m_currentParent = null;
        this.m_childObjIter = null;
        this.m_currObj = null;
        if (this.m_parentIter.hasNext()) {
            this.m_currentParent = this.m_parentIter.next();
            if (this.m_currentParent != null) {
                DBObject[] objs = this.m_currentParent.getOwnedObjects(this.m_types);
                if (objs.length == 0) {
                    this.nextParent();
                } else {
                    this.m_childObjIter = Arrays.asList(objs).iterator();
                    this.nextDBO();
                }
            }
        }
    }

    private void nextDBO() {
        this.m_currObj = this.m_childObjIter != null && this.m_childObjIter.hasNext() ? this.m_childObjIter.next() : null;
        if (this.m_currObj == null) {
            this.nextParent();
        }
    }

    @Override
    public boolean hasNext() {
        this.start();
        return this.m_currObj != null;
    }

    @Override
    public DBObject next() {
        this.start();
        DBObject retval = this.m_currObj;
        this.nextDBO();
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by DBObjectIterator");
    }

    public static final Iterator<? extends DBObject> createIterator(DBObjectProvider[] pros, String[] schemaObjectTypes, String[] ... childTypeHeirachy) {
        SchemaObjectIterator soIter = new SchemaObjectIterator(pros);
        soIter.setTypes(schemaObjectTypes);
        return DBObjectIterator.createIterator(soIter, childTypeHeirachy);
    }

    public static final Iterator<? extends DBObject> createIterator(DBObject parent, String[] ... childTypeHeirachy) {
        return DBObjectIterator.createIterator(Collections.singleton(parent).iterator(), childTypeHeirachy);
    }

    private static final Iterator<? extends DBObject> createIterator(Iterator<? extends DBObject> parent, String[] ... childTypeHeirachy) {
        DBObjectIterator iter = parent;
        if (childTypeHeirachy != null) {
            for (String[] childTypes : childTypeHeirachy) {
                iter = new DBObjectIterator(iter);
                iter.setTypes(childTypes);
            }
        }
        return iter;
    }
}

