/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.deferred.Thunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBObjectProviderFactory {
    private final Map<String, Creator> m_factories = new HashMap<String, Creator>();
    private final Collection<Listener> m_listeners = new CopyOnWriteArraySet<Listener>();
    private final MultiMap<String, DBObjectProviderListener> m_proListeners = new MultiMap(ConcurrentHashMap.class, CopyOnWriteArraySet.class);

    private DBObjectProviderFactory() {
    }

    private static DBObjectProviderFactory getInstance() {
        DBCore core = DBCore.getInstance();
        DBObjectProviderFactory f = core.get(DBObjectProviderFactory.class);
        if (f == null) {
            f = new DBObjectProviderFactory();
            core.put(f);
        }
        return f;
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DBObjectProviderFactory.class);
    }

    public static void registerListener(Listener l) {
        Collection<Listener> list = DBObjectProviderFactory.getInstance().m_listeners;
        if (!list.contains(l)) {
            list.add(l);
        }
    }

    public static void unregisterListener(Listener l) {
        Collection<Listener> list = DBObjectProviderFactory.getInstance().m_listeners;
        if (l != null) {
            list.remove(l);
        }
    }

    public static void registerProviderListener(String providerType, DBObjectProviderListener l) {
        if (providerType != null && l != null) {
            MultiMap<String, DBObjectProviderListener> map = DBObjectProviderFactory.getInstance().m_proListeners;
            map.add((Object)providerType, (Object)l);
        }
    }

    public static void unregisterProviderListener(String providerType, DBObjectProviderListener l) {
        if (providerType != null && l != null) {
            MultiMap<String, DBObjectProviderListener> map = DBObjectProviderFactory.getInstance().m_proListeners;
            map.remove((Object)providerType, (Object)l);
        }
    }

    public static void registerFactory(Creator factory) {
        Map<String, Creator> factories = DBObjectProviderFactory.getInstance().m_factories;
        String type = factory.getProviderType();
        if (ModelUtil.hasLength((String)type)) {
            if (factories.containsKey(type)) {
                DBObjectProviderFactory.getLogger().warning("Ignoring attempt to replace Creator for: " + type);
            } else {
                factories.put(type, factory);
            }
        }
    }

    public static void unregisterFactory(Creator factory) {
        Map<String, Creator> factories = DBObjectProviderFactory.getInstance().m_factories;
        String type = factory.getProviderType();
        if (ModelUtil.hasLength((String)type) && factories.get(type) == factory) {
            factories.remove(type);
        }
    }

    @Deprecated
    public static <T extends Creator> T findFactory(Class<T> clz) {
        return null;
    }

    @Deprecated
    public static DBObjectProvider findProvider(Object identifier) {
        DBObjectProvider pro;
        block1: {
            String proType;
            pro = null;
            if (identifier == null) break block1;
            Iterator<String> i$ = DBObjectProviderFactory.getProviderTypes().iterator();
            while (i$.hasNext() && (pro = DBObjectProviderFactory.findProvider(proType = i$.next(), identifier)) == null) {
            }
        }
        return pro;
    }

    public static DBObjectProvider findProvider(DBObjectProviderID id) {
        DBObjectProvider retval = null;
        if (id != null) {
            retval = DBObjectProviderFactory.findProvider(id.getType(), id.getIdentifier());
        }
        return retval;
    }

    public static DBObjectProvider findProvider(String providerType, Object identifier) {
        Creator c;
        DBObjectProvider pro = null;
        if (identifier != null && providerType != null && (c = DBObjectProviderFactory.getCreator(providerType)) != null) {
            pro = c.findProvider(identifier);
        }
        return pro;
    }

    @Deprecated
    public static DBObjectProvider findOrCreateProvider(Object identifier) throws DBException {
        DBObjectProvider pro;
        block1: {
            String proType;
            pro = null;
            if (identifier == null) break block1;
            Iterator<String> i$ = DBObjectProviderFactory.getProviderTypes().iterator();
            while (i$.hasNext() && (pro = DBObjectProviderFactory.findOrCreateProvider(proType = i$.next(), identifier)) == null) {
            }
        }
        return pro;
    }

    public static DBObjectProvider findOrCreateProvider(DBObjectProviderID id) throws DBException {
        DBObjectProvider retval = null;
        if (id != null) {
            retval = DBObjectProviderFactory.findOrCreateProvider(id.getType(), id.getIdentifier());
        }
        return retval;
    }

    public static DBObjectProvider findOrCreateProvider(String providerType, Object identifier) throws DBException {
        DBObjectProvider pro = null;
        if (identifier != null && providerType != null) {
            Creator c = DBObjectProviderFactory.getCreator(providerType);
            if (c == null) {
                throw new DBException(null, "Unknown provider type: " + providerType);
            }
            pro = DBObjectProviderFactory.findOrCreateProviderFromFactory(c, identifier);
        }
        return pro;
    }

    private static final Collection<String> getProviderTypes() {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        retval.add("db");
        retval.addAll(DBObjectProviderFactory.getInstance().m_factories.keySet());
        Map<String, Thunk> extras = DBCore.getInstance().getFactoryMap(Creator.class);
        if (extras != null) {
            retval.addAll(extras.keySet());
        }
        return retval;
    }

    public static final Creator getCreator(String providerType) {
        Creator retval = null;
        if (providerType != null && (retval = DBObjectProviderFactory.getInstance().m_factories.get(providerType)) == null && (retval = DBCore.getInstance().getRegisteredFactory(Creator.class, providerType)) == null && providerType.equals("db")) {
            retval = DatabaseFactory.getInstance();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DBObjectProvider findOrCreateProviderFromFactory(Creator factory, Object identifier) throws DBException {
        DBObjectProvider pro = factory.findProvider(identifier);
        if (pro == null) {
            Creator creator = factory;
            synchronized (creator) {
                pro = factory.findProvider(identifier);
                if (pro == null) {
                    pro = DBObjectProviderFactory.createProviderFromFactory(factory, identifier);
                }
            }
        }
        return pro;
    }

    private static final DBObjectProvider createProviderFromFactory(Creator factory, Object identifier) throws DBException {
        DBObjectProvider retval = null;
        try {
            retval = factory.createProviderImpl(identifier);
            if (retval != null) {
                DBObjectProviderFactory.notifyOfCreation(factory.getIdentifier(retval), retval);
            }
        }
        catch (Exception e) {
            if (e instanceof DBException) {
                throw (DBException)e;
            }
            DBLog.logStackTrace(e);
            throw new DBException(e);
        }
        return retval;
    }

    @Deprecated
    public static final DBObjectProvider uncacheProvider(Object identifier) {
        return null;
    }

    public static final DBObjectProvider uncacheProvider(String providerType, Object identifier) {
        Creator c;
        DBObjectProvider gone = null;
        if (identifier != null && providerType != null && (gone = (c = DBObjectProviderFactory.getCreator(providerType)).uncacheProvider(identifier)) != null) {
            DBObjectProviderFactory.notifyOfRemoval(c.getIdentifier(gone), gone);
        }
        return gone;
    }

    public static String getDescription(String type, Object identifier) {
        Creator c = DBObjectProviderFactory.getCreator(type);
        String retval = c == null ? String.valueOf(identifier) : c.getDescription(identifier);
        return retval;
    }

    public static final Class<? extends DBObjectProvider> loadProviderClass(String clzName) throws ClassNotFoundException {
        Class<Database> retval = null;
        DatabaseRegistry dbreg = DatabaseRegistry.getInstance();
        if (dbreg.isRegisteredDatabase(clzName)) {
            retval = dbreg.loadDatabaseClass(clzName);
        } else {
            ClassLoader ldr = DBCore.getImplClassLoader();
            retval = ldr.loadClass(clzName);
        }
        return retval;
    }

    private static Collection<Listener> listeners() {
        ArrayList<Listener> retval = new ArrayList<Listener>(DBObjectProviderFactory.getInstance().m_listeners);
        DBCore.getInstance().populateFactoryList(Listener.class, retval);
        return retval;
    }

    static void notifyOfCreation(Object identifier, DBObjectProvider pro) {
        DBObjectProviderFactory.getLogger().log(DBLog.getEventLogLevel(), "Provider created using key {0}: {1}", new Object[]{identifier, pro.getClass().getName()});
        for (Listener l : DBObjectProviderFactory.listeners()) {
            try {
                l.providerCreated(identifier, pro);
            }
            catch (Exception e) {
                DBObjectProviderFactory.getLogger().log(Level.SEVERE, l.getClass().getName(), e);
            }
        }
        Collection proLists = DBObjectProviderFactory.getInstance().m_proListeners.get((Object)pro.getProviderType());
        if (proLists != null) {
            for (DBObjectProviderListener l : proLists) {
                pro.addProviderListener(l);
            }
        }
        if (pro instanceof AbstractDBObjectProvider) {
            ((AbstractDBObjectProvider)pro).fireProviderOpened();
        }
    }

    static void notifyOfRemoval(Object identifier, DBObjectProvider pro) {
        DBObjectProviderFactory.getLogger().log(DBLog.getEventLogLevel(), "Provider uncached using key {0}", identifier);
        for (Listener l : DBObjectProviderFactory.listeners()) {
            try {
                l.providerRemoved(identifier, pro);
            }
            catch (Exception e) {
                DBObjectProviderFactory.getLogger().log(Level.SEVERE, l.getClass().getName(), e);
            }
        }
        Collection proLists = DBObjectProviderFactory.getInstance().m_proListeners.get((Object)pro.getProviderType());
        if (proLists != null) {
            for (DBObjectProviderListener l : proLists) {
                pro.removeProviderListener(l);
            }
        }
    }

    private static void notifyOfDelete(Object identifier, DBObjectProvider pro) {
        DBObjectProviderFactory.getLogger().log(DBLog.getEventLogLevel(), "Provider deleted using key {0}: {1}", new Object[]{identifier, pro.getClass().getName()});
        for (Listener l : DBObjectProviderFactory.listeners()) {
            try {
                l.providerDeleted(identifier, pro);
            }
            catch (Exception e) {
                DBObjectProviderFactory.getLogger().log(Level.SEVERE, l.getClass().getName(), e);
            }
        }
    }

    public static abstract class Creator {
        public abstract String getProviderType();

        protected abstract DBObjectProvider createProviderImpl(Object var1) throws DBException;

        protected String getDescription(Object identifier) {
            return this.getProviderType() + " " + String.valueOf(identifier);
        }

        protected abstract Object getIdentifier(DBObjectProvider var1);

        protected DBObjectProvider uncacheProvider(Object identifier) {
            return null;
        }

        protected DBObjectProvider findProvider(Object identifier) {
            return null;
        }

        protected final void fireProviderDeleted(Object identifier, DBObjectProvider pro) {
            DBObjectProviderFactory.notifyOfDelete(identifier, pro);
        }
    }

    public static interface Listener {
        public void providerCreated(Object var1, DBObjectProvider var2);

        public void providerRemoved(Object var1, DBObjectProvider var2);

        public void providerDeleted(Object var1, DBObjectProvider var2);
    }
}

