/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.extension.ConnectionMatcher;
import oracle.javatools.db.internal.ClassThunk;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.deferred.Thunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseFactory
extends DBObjectProviderFactory.Creator {
    private final Map<String, ConnectionCreator> m_connCreators = new HashMap<String, ConnectionCreator>();
    private final Map<String, DatabaseCreatorInfo> m_dbCreators = new LinkedHashMap<String, DatabaseCreatorInfo>();
    private final List<DatabaseCreator> m_legacyCreators = new ArrayList<DatabaseCreator>();
    private final Map<String, String> m_dbCreatorsByClass = new HashMap<String, String>();
    private ClassThunk<DatabaseCreator> m_jdbcDatabaseCreator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatabaseFactory getInstance() {
        DBCore core = DBCore.getInstance();
        Class<DatabaseFactory> clazz = DatabaseFactory.class;
        synchronized (DatabaseFactory.class) {
            DatabaseFactory df = core.get(DatabaseFactory.class);
            if (df == null) {
                df = new DatabaseFactory();
                core.put(df);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return df;
        }
    }

    private DatabaseFactory() {
    }

    private void checkDatabaseCreatorInit() {
        DatabaseRegistry.getInstance().checkInit();
    }

    @Override
    public String getProviderType() {
        return "db";
    }

    @Override
    protected String getDescription(Object identifier) {
        StringBuilder retval = new StringBuilder(APIBundle.get("DATABASE"));
        if (identifier instanceof String) {
            ConnectionCreator cc;
            String[] decoded = DatabaseFactory.decodeIdentifier((String)identifier);
            retval.append(" ").append(decoded[1]);
            if (ModelUtil.hasLength((String)decoded[0]) && (cc = DatabaseFactory.findConnectionCreator(decoded[0])) != null) {
                retval.append(" (").append(cc.getDisplayableStoreName()).append(")");
            }
        } else {
            retval.append(" ").append(identifier);
        }
        return retval.toString();
    }

    public static String[] decodeIdentifier(String id) {
        String toDecode;
        try {
            toDecode = URLDecoder.decode(id, "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            toDecode = id;
        }
        String[] split = toDecode.split("#", 2);
        if (split.length == 1) {
            split = new String[]{null, split[0]};
        }
        return split;
    }

    public static String encodeIdentifier(String storeName, String connName) {
        String toEncode;
        String retval = toEncode = storeName == null ? connName : storeName + "#" + connName;
        if (toEncode != null) {
            try {
                retval = URLEncoder.encode(toEncode, "utf-8");
            }
            catch (UnsupportedEncodingException uee) {
                retval = toEncode;
            }
        }
        return retval;
    }

    @Override
    protected String getIdentifier(DBObjectProvider provider) {
        if (provider instanceof Database) {
            return ((Database)provider).getQualifiedName();
        }
        return null;
    }

    @Override
    protected final DBObjectProvider createProviderImpl(Object identifier) throws DBException {
        Database retval;
        block2: {
            String[] decoded;
            block3: {
                retval = null;
                if (!(identifier instanceof String)) break block2;
                decoded = DatabaseFactory.decodeIdentifier((String)identifier);
                if (!ModelUtil.hasLength((String)decoded[0])) break block3;
                ConnectionCreator cc = DatabaseFactory.findConnectionCreator(decoded[0]);
                if (cc == null) break block2;
                retval = DatabaseFactory.findOrCreateDatabase(decoded[1], cc);
                break block2;
            }
            if (ModelUtil.hasLength((String)decoded[1])) {
                for (ConnectionCreator cc : DatabaseFactory.getConnectionCreators()) {
                    if (cc.isActive() && (retval = DatabaseFactory.findOrCreateDatabase(decoded[1], cc)) != null) break;
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Database findOrCreateDatabase(String connName, ConnectionCreator factory) throws DBException {
        Database retval;
        ConnectionCreator connectionCreator = factory;
        synchronized (connectionCreator) {
            Database cached = factory.findDatabase(connName);
            retval = cached == null ? DatabaseFactory.createDatabase(connName, factory) : cached;
        }
        return retval;
    }

    public static Database createDatabase(String connName, ConnectionCreator factory) throws DBException {
        Connection conn = DatabaseFactory.createConnection(connName, factory);
        if (conn != null) {
            String storeName = factory.getStoreName();
            Database db = DatabaseFactory.getInstance().createDatabaseImpl(storeName, connName, conn);
            if (db != null) {
                factory.cacheDatabase(connName, db);
                return db;
            }
        }
        return null;
    }

    private Database createDatabaseImpl(String store, String name, Connection conn) throws DBException {
        Object retval = null;
        Object creator = null;
        if (conn != null) {
            this.checkDatabaseCreatorInit();
            for (DatabaseCreatorInfo info : this.m_dbCreators.values()) {
                Database db;
                if (!info.matches(conn) || (creator = info.getCreator()) == null || (db = ((DatabaseCreator)creator).createDatabaseImpl(store, name, conn)) == null) continue;
                retval = db;
                break;
            }
            if (retval == null && (creator = this.getJdbcCreator()) != null) {
                retval = ((DatabaseCreator)creator).createDatabaseImpl(store, name, conn);
            }
        }
        if (retval != null) {
            this.registerDatabaseImplementation(retval.getClass().getName(), creator.getClass().getName());
        }
        return retval;
    }

    void registerDatabaseImplementation(String dbClassName, String creatorClassName) {
        String oldClz = this.m_dbCreatorsByClass.get(dbClassName);
        if (ModelUtil.areDifferent((Object)oldClz, (Object)creatorClassName)) {
            if (oldClz != null) {
                DatabaseFactory.getLogger().fine("Replacing " + oldClz + " with " + creatorClassName + " for " + dbClassName);
            }
            this.m_dbCreatorsByClass.put(dbClassName, creatorClassName);
        }
    }

    void registerDatabaseCreator(String creatorClassName, ClassLoader classLoader, ConnectionMatcher matcher) {
        this.registerDatabaseCreator(creatorClassName, new ClassThunk<DatabaseCreator>(creatorClassName, classLoader, DatabaseCreator.class), matcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDatabaseCreator(String creatorClassName, ClassThunk<DatabaseCreator> dcThunk, ConnectionMatcher matcher) {
        Map<String, DatabaseCreatorInfo> map = this.m_dbCreators;
        synchronized (map) {
            if (!this.m_dbCreators.containsKey(creatorClassName)) {
                this.m_dbCreators.put(creatorClassName, new DatabaseCreatorInfo(dcThunk, matcher));
            }
        }
    }

    private DatabaseDescriptor getDescriptor(DatabaseCreator creator, Object param) {
        DatabaseDescriptor retval = param instanceof Class ? creator.getDatabaseDescriptorImpl((Class)param) : creator.getDatabaseDescriptorImpl((Database)param);
        return retval;
    }

    DatabaseCreator findDatabaseCreator(String dbImplClzName) {
        DatabaseCreatorInfo info;
        this.checkDatabaseCreatorInit();
        DatabaseCreator retval = null;
        String creatorClassName = this.m_dbCreatorsByClass.get(dbImplClzName);
        if (creatorClassName != null && (info = this.m_dbCreators.get(creatorClassName)) != null) {
            retval = info.getCreator();
        }
        return retval;
    }

    private DatabaseDescriptor getDatabaseDescriptorImpl(Object param, Class<? extends Database> dbImplClz) {
        DatabaseCreator dc;
        DatabaseDescriptor retval = null;
        DatabaseCreator creator = this.findDatabaseCreator(dbImplClz.getName());
        if (creator == null) {
            DatabaseCreator c;
            Iterator<DatabaseCreator> i$ = this.m_legacyCreators.iterator();
            while (i$.hasNext() && (retval = this.getDescriptor(creator = (c = i$.next()), param)) == null) {
            }
            if (retval != null) {
                this.registerDatabaseImplementation(dbImplClz.getName(), creator.getClass().getName());
            }
        } else {
            DatabaseDescriptor desc = this.getDescriptor(creator, param);
            if (desc != null) {
                retval = desc;
            }
        }
        if (retval == null && JdbcDatabase.class.isAssignableFrom(dbImplClz) && (dc = this.getJdbcCreator()) != null) {
            retval = this.getDescriptor(dc, param);
        }
        return retval;
    }

    void setJdbcDatabaseCreator(String className) {
        if (this.m_jdbcDatabaseCreator != null) {
            throw new IllegalStateException("The Generic JDBC DatabseCreator implementation cannot be replaced.");
        }
        this.m_jdbcDatabaseCreator = new ClassThunk<DatabaseCreator>(className, null, DatabaseCreator.class);
    }

    private DatabaseCreator getJdbcCreator() {
        return (DatabaseCreator)this.m_jdbcDatabaseCreator.get();
    }

    @Override
    protected DBObjectProvider findProvider(Object identifier) {
        Database retval;
        block2: {
            String[] decoded;
            block3: {
                retval = null;
                if (!(identifier instanceof String)) break block2;
                decoded = DatabaseFactory.decodeIdentifier((String)identifier);
                if (!ModelUtil.hasLength((String)decoded[0])) break block3;
                ConnectionCreator factory = DatabaseFactory.findConnectionCreator(decoded[0]);
                if (factory == null) break block2;
                retval = factory.findDatabase(decoded[1]);
                break block2;
            }
            if (ModelUtil.hasLength((String)decoded[1])) {
                for (ConnectionCreator cc : DatabaseFactory.getConnectionCreators()) {
                    if (cc.isActive() && (retval = cc.findDatabase(decoded[1])) != null) break;
                }
            }
        }
        return retval;
    }

    @Override
    protected DBObjectProvider uncacheProvider(Object identifier) {
        Database retval;
        block2: {
            String[] decoded;
            block3: {
                retval = null;
                if (!(identifier instanceof String)) break block2;
                decoded = DatabaseFactory.decodeIdentifier((String)identifier);
                if (!ModelUtil.hasLength((String)decoded[0])) break block3;
                ConnectionCreator factory = DatabaseFactory.findConnectionCreator(decoded[0]);
                if (factory == null) break block2;
                retval = factory.uncacheDatabase(decoded[1]);
                break block2;
            }
            if (ModelUtil.hasLength((String)decoded[1])) {
                for (ConnectionCreator cc : DatabaseFactory.getConnectionCreators()) {
                    if (cc.isActive() && (retval = cc.uncacheDatabase(decoded[1])) != null) break;
                }
            }
        }
        return retval;
    }

    public static final Database findOrCreateDatabase(String storeName, String connName) throws DBException {
        String qName = DatabaseFactory.encodeIdentifier(storeName, connName);
        return (Database)DBObjectProviderFactory.findOrCreateProvider("db", qName);
    }

    @Deprecated
    public static final Database findOrCreateDatabase(String name, Connection conn) throws DBException {
        Database db = (Database)DBObjectProviderFactory.findOrCreateProvider("db", name);
        if (db == null) {
            db = DatabaseFactory.createStandaloneDatabase(name, conn);
        }
        return db;
    }

    public static final Database createStandaloneDatabase(String name, Connection conn) throws DBException {
        return DatabaseFactory.getInstance().createDatabaseImpl(null, name, conn);
    }

    public static final DatabaseDescriptor getDatabaseDescriptor(Class<? extends Database> providerClass) {
        return DatabaseFactory.getInstance().getDatabaseDescriptorImpl(providerClass, providerClass);
    }

    @Deprecated
    public static void setJdbcDatabaseCreator(DatabaseCreator dc) {
    }

    public static final DatabaseDescriptor getDatabaseDescriptor(Database db) {
        return DatabaseFactory.getInstance().getDatabaseDescriptorImpl(db, db.getClass());
    }

    public static final void registerConnectionCreator(String storeName, ConnectionCreator cc) {
        if (cc != null) {
            DatabaseFactory.getInstance().m_connCreators.put(storeName, cc);
        }
    }

    public static final void unregisterConnectionCreator(String storeName, ConnectionCreator cc) {
        if (cc != null) {
            ConnectionCreator old = DatabaseFactory.getInstance().m_connCreators.remove(storeName);
            if (old == null) {
                DatabaseFactory.getLogger().warning("Cannot unregister ConnectionCreator for " + storeName + " as it was not registered using registerConnectionCreator");
            } else if (old != cc) {
                DatabaseFactory.getLogger().warning("ConnectionCreator unregistration for " + storeName + ": store is not the same as the original registration.");
            }
        }
    }

    @Deprecated
    public static final void registerDatabaseCreator(DatabaseCreator dc) {
        DatabaseFactory.getInstance().registerDatabaseCreator(dc.getClass().getName(), new ClassThunk<DatabaseCreator>(dc), null);
        DatabaseFactory.getInstance().m_legacyCreators.add(dc);
    }

    private static List<ConnectionCreator> getConnectionCreators() {
        ArrayList<ConnectionCreator> retval = new ArrayList<ConnectionCreator>();
        retval.addAll(DatabaseFactory.getInstance().m_connCreators.values());
        List<? extends Thunk> thunks = DBCore.getInstance().getFactoryList(ConnectionCreatorFactory.class);
        if (thunks != null) {
            for (Thunk thunk : thunks) {
                ConnectionCreatorFactory ccf = (ConnectionCreatorFactory)thunk.get();
                if (ccf == null) continue;
                retval.addAll(ccf.listCreators());
            }
        }
        return retval;
    }

    public static ConnectionCreator findConnectionCreator(String storeName) {
        List<? extends Thunk> thunks;
        ConnectionCreator retval = DatabaseFactory.getInstance().m_connCreators.get(storeName);
        if (retval == null && (thunks = DBCore.getInstance().getFactoryList(ConnectionCreatorFactory.class)) != null) {
            for (Thunk thunk : thunks) {
                try {
                    ConnectionCreatorFactory ccf = (ConnectionCreatorFactory)thunk.get();
                    if (ccf == null || (retval = ccf.getCreator(storeName)) == null) continue;
                    break;
                }
                catch (Exception e) {
                    DatabaseFactory.getLogger().log(Level.WARNING, "ConnectionCreatorFactory failure", e);
                }
            }
        }
        if (retval == null) {
            DatabaseFactory.getLogger().warning("Unknown connection store name: " + storeName);
        }
        return retval;
    }

    @Deprecated
    public static final <T extends ConnectionCreator> T findConnectionCreator(Class<T> ccc) {
        return null;
    }

    @Deprecated
    public static final ConnectionCreator findConnectionCreator(Database db) {
        return null;
    }

    public static final Connection createConnection(Database db) throws DBException {
        ConnectionCreator cc;
        String storeName;
        String connName = db.getConnectionName();
        if (connName != null && (storeName = db.getConnectionStore()) != null && (cc = DatabaseFactory.findConnectionCreator(storeName)) != null) {
            return DatabaseFactory.createConnection(connName, cc);
        }
        return db.getConnection();
    }

    private static final Connection createConnection(String connName, ConnectionCreator cc) throws DBException {
        long millis = System.currentTimeMillis();
        Connection conn = cc.createConnectionImpl(connName);
        if (conn != null) {
            DatabaseFactory.getLogger().log(DBLog.getTimingLogLevel(), "Opening connection for {0} took {1}ms", new Object[]{connName, Long.toString(System.currentTimeMillis() - millis)});
            return conn;
        }
        return null;
    }

    @Deprecated
    public static void registerProviderClass(Class<? extends Database> clz, String name) {
    }

    @Deprecated
    public static Collection<Class<? extends Database>> getClasses() {
        ArrayList<Class<? extends Database>> retval = new ArrayList<Class<? extends Database>>();
        DatabaseRegistry reg = DatabaseRegistry.getInstance();
        for (String type : reg.listDatabaseTypes()) {
            for (int ver : reg.listDatabaseVersions(type)) {
                Class<? extends Database> clz = reg.getDatabaseDescriptor(type, ver).getDatabaseClass();
                if (clz == null) continue;
                retval.add(clz);
            }
        }
        return retval;
    }

    @Deprecated
    public static String getDatabaseName(Class<? extends Database> dbClz) {
        DatabaseDescriptor desc = DatabaseFactory.getDatabaseDescriptor(dbClz);
        return desc == null ? null : desc.getDatabaseName();
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DatabaseFactory.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatabaseCreatorInfo {
        private final Thunk<DatabaseCreator> m_thunk;
        private final ConnectionMatcher m_matcher;

        DatabaseCreatorInfo(Thunk<DatabaseCreator> thunk, ConnectionMatcher matcher) {
            this.m_thunk = thunk;
            this.m_matcher = matcher;
        }

        boolean matches(Connection conn) {
            return this.m_matcher == null || this.m_matcher.matches(conn);
        }

        DatabaseCreator getCreator() {
            return (DatabaseCreator)this.m_thunk.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ConnectionCreatorFactory {
        public abstract ConnectionCreator getCreator(String var1);

        public abstract Collection<ConnectionCreator> listCreators();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ConnectionCreator {
        private Map<String, Database> m_dbs;

        protected abstract Connection createConnectionImpl(String var1) throws DBException;

        protected boolean isActive() {
            return true;
        }

        protected abstract String getStoreName();

        protected String getDisplayableStoreName() {
            return this.getStoreName();
        }

        public boolean shouldClearCaches(Connection oldConn, Connection newConn, Database db) {
            return true;
        }

        public Collection<String> listDatabases() {
            List<String> retval = this.m_dbs == null ? Collections.emptyList() : new ArrayList<String>(this.m_dbs.keySet());
            return retval;
        }

        public Database findDatabase(String connName) {
            Database retval = null;
            if (this.m_dbs != null) {
                retval = this.m_dbs.get(connName);
            }
            return retval;
        }

        public synchronized Database uncacheDatabase(String connName) {
            Database retval = null;
            if (this.m_dbs != null) {
                Database removed = this.m_dbs.remove(connName);
                if (removed != null) {
                    DBObjectProviderFactory.notifyOfRemoval(removed.getQualifiedName(), removed);
                }
                retval = removed;
            }
            return retval;
        }

        protected synchronized void cacheDatabase(String connName, Database db) {
            if (connName != null) {
                if (this.m_dbs == null) {
                    this.m_dbs = new HashMap<String, Database>();
                }
                this.m_dbs.put(connName, db);
                DBObjectProviderFactory.notifyOfCreation(db.getQualifiedName(), db);
            }
        }

        public synchronized boolean renameDatabase(String oldName, String newName) {
            Database db = this.uncacheDatabase(oldName);
            if (db != null) {
                ((AbstractDatabase)db).setConnectionName(newName);
                this.cacheDatabase(newName, db);
                return true;
            }
            return false;
        }
    }

    public static abstract class DatabaseCreator {
        protected abstract Database createDatabaseImpl(String var1, String var2, Connection var3) throws DBException;

        protected abstract DatabaseDescriptor getDatabaseDescriptorImpl(Class var1);

        protected DatabaseDescriptor getDatabaseDescriptorImpl(Database db) {
            return this.getDatabaseDescriptorImpl(db.getClass());
        }

        protected DatabaseDescriptor getDatabaseDescriptorImpl(String type, int ver) {
            return null;
        }
    }
}

