/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.util.deferred.Thunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalSettings
extends HashStructureAdapter {
    private static final String DATETIME = "validateDateTime";
    private static final String COMPILEROPTS = "plsqlCompilerOptions";
    private static final String PLSQLCASE = "plsqlLowerCase";
    private static final String STMT_TIMEOUT = "statementTimeout";
    private static Thunk<PropertyStorage> s_propsThunk;
    public static final String PREFS_KEY = "oracle.javatools.db.GlobalSettings";

    public static final synchronized GlobalSettings getInstance() {
        PropertyStorage props;
        DBCore core = DBCore.getInstance();
        GlobalSettings retval = core.get(GlobalSettings.class);
        if (retval == null && s_propsThunk != null && (props = (PropertyStorage)s_propsThunk.get()) != null) {
            retval = GlobalSettings.createGlobalSettings(props);
            core.put((Object)retval);
        }
        return retval;
    }

    @Deprecated
    public static final void initialiseInstance(PropertyStorage props) {
        GlobalSettings.initialiseInstance((Thunk<PropertyStorage>)Thunk.directReference((Object)props));
    }

    public static final void initialiseInstance(Thunk<PropertyStorage> propsThunk) {
        if (s_propsThunk != null) {
            new IllegalStateException("Database GlobalSettings already exist, shouldn't initialise twice.").printStackTrace();
        } else {
            s_propsThunk = propsThunk;
        }
    }

    public static final GlobalSettings createGlobalSettings(PropertyStorage props) {
        return new GlobalSettings(GlobalSettings.findOrCreate((PropertyStorage)props, (String)PREFS_KEY));
    }

    private GlobalSettings(HashStructure hash) {
        super(hash);
    }

    public boolean isValidateDateTime() {
        return this._hash.getBoolean(DATETIME, true);
    }

    public void setValidateDateTime(boolean boo) {
        this._hash.putBoolean(DATETIME, boo);
    }

    public boolean isNewPlSqlLowerCase() {
        return this._hash.getBoolean(PLSQLCASE, false);
    }

    public void setNewPlSqlLowerCase(boolean newPlSqlLowerCase) {
        this._hash.putBoolean(PLSQLCASE, newPlSqlLowerCase);
    }

    public PlSqlCompilerOptions getPlSqlCompilerOptions() {
        return new PlSqlCompilerOptions(this._hash.getOrCreateHashStructure(COMPILEROPTS));
    }

    public Integer getStatementTimeout() {
        Integer retval = null;
        if (this._hash.containsKey(STMT_TIMEOUT)) {
            retval = this._hash.getInt(STMT_TIMEOUT);
        }
        return retval;
    }

    public void setStatementTimeout(Integer timeout) {
        if (timeout == null) {
            this._hash.remove(STMT_TIMEOUT);
        } else {
            this._hash.putInt(STMT_TIMEOUT, timeout.intValue());
        }
    }
}

