/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.util.ModelUtil;

public class NameBasedID
extends BaseObjectID {
    public NameBasedID() {
    }

    public NameBasedID(String type, String schemaName, String objName) {
        this(type, schemaName, objName, null);
    }

    public NameBasedID(String type, String schemaName, String objName, AbstractDBObjectProvider pro) {
        super(type, pro);
        this.setSchemaName(schemaName);
        this.setName(objName);
    }

    public NameBasedID(String type, String objName, DBObjectID parent) {
        super(type, parent);
        this.setName(objName);
    }

    public NameBasedID(DBObject obj, AbstractDBObjectProvider pro) {
        super(obj, pro);
    }

    public NameBasedID(DBObject obj, DBObjectID parent) {
        super(obj, parent);
    }

    public void construct(String id) {
        String[] items = id.split(":");
        if (items.length >= 1) {
            String typeString = items[0];
            String idString = items[1];
            this.setType(typeString);
            this.setName(idString);
            if (items.length > 2) {
                if (items[2].equals("SCHEMA") && items.length == 4) {
                    this.setSchemaName(items[3]);
                } else {
                    int index = typeString.length() + ":".length() + idString.length() + ":".length();
                    this.setParent(BaseObjectID.createFromString(id.substring(index)));
                }
            }
        }
    }

    protected boolean equalsImpl(DBObjectID id, boolean strict) {
        if (strict) {
            return id instanceof NameBasedID && this.equalsImpl((NameBasedID)id);
        }
        if ((this.getType() == null || "UNSPECIFIED_TYPE".equals(this.getType())) && id instanceof BaseObjectID) {
            return ModelUtil.areEqual((Object)this.getName(), (Object)((BaseObjectID)id).getName()) && ModelUtil.areEqual((Object)this.getDatabaseName(), (Object)((BaseObjectID)id).getDatabaseName());
        }
        return id instanceof BaseObjectID && this.equalsImpl((BaseObjectID)id);
    }

    public Object copyTo(Object target) {
        if (target instanceof BaseObjectID && !(target instanceof NameBasedID)) {
            this.copyToImpl((BaseObjectID)target);
            return target;
        }
        NameBasedID other = target == null ? new NameBasedID() : (NameBasedID)target;
        this.copyToImpl(other);
        return other;
    }

    protected String toStringImpl() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getType());
        builder.append(":");
        String name = this.getName();
        if (name != null) {
            builder.append(name);
        }
        if (this.getParent() == null) {
            String schemaName = this.getSchemaName();
            if (ModelUtil.hasLength((String)schemaName)) {
                builder.append(":").append("SCHEMA");
                builder.append(":").append(schemaName);
            }
        } else if (this.getParent() instanceof BaseObjectID) {
            builder.append(":").append(this.getParent().toString());
        } else {
            DBLog.getLogger().warning("Non-BaseObjectID as a parent for NameBasedID");
        }
        return builder.toString();
    }
}

