/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.ModelUtil;

public class Table
extends Relation {
    public static final String TYPE = "TABLE";
    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    @PropertyKey(value=TableType.class, childOf={Table.class})
    public static final String TABLE_TYPE_KEY = "TableType";

    public Table() {
        this.setProperty(TABLE_TYPE_KEY, (Object)TableType.NORMAL);
    }

    public Table(String name, Schema schema) {
        super(name, schema);
        this.setProperty(TABLE_TYPE_KEY, (Object)TableType.NORMAL);
    }

    public String getType() {
        return TYPE;
    }

    public Index[] getIndexes() {
        return this.getChildSupport("indexes").getChildArray(Index.class);
    }

    public void setIndexes(Index[] indexes) {
        this.getChildSupport("indexes").setChildArray(indexes);
    }

    public void addIndex(Index index) {
        this.getChildSupport("indexes").addChild(index);
    }

    public void removeIndex(Index index) {
        this.getChildSupport("indexes").removeChild(index);
    }

    public Index getIndex(String idxName) {
        return (Index)this.getChildSupport("indexes").findChild(idxName);
    }

    public void setSchema(Schema schema) {
        Schema oldSchema = this.getSchema();
        super.setSchema(schema);
        if (schema != oldSchema && this.getPropertySupport().isBuilt("indexes")) {
            for (Index i : this.getIndexes()) {
                Schema iSchema = i.getSchema();
                if (iSchema == null) continue;
                String iSchemaName = iSchema.getName();
                if ((oldSchema == null || !ModelUtil.areEqual((Object)iSchemaName, (Object)oldSchema.getName())) && (schema == null || !ModelUtil.areEqual((Object)iSchemaName, (Object)schema.getName()))) continue;
                i.setSchema(null);
            }
        }
    }

    public void setProperty(String key, Object value) {
        if ("compression".equals(key) || "parallel".equals(key)) {
            OracleTableProperties otp;
            OracleTableProperties oracleTableProperties = otp = value == null ? (OracleTableProperties)this.getProperty("OracleTableProperties") : OracleTableProperties.findOrCreateOracleTableProperties(this);
            if (otp != null) {
                if ("compression".equals(key)) {
                    otp.setTableCompression(OracleTableProperties.OracleTableCompression.migrateFrom(value));
                } else {
                    otp.setParallelDegree((Integer)value);
                }
            }
        } else {
            super.setProperty(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableType {
        NORMAL,
        TRANSACTION_TEMP,
        SESSION_TEMP,
        INDEX_ORGANIZED,
        EXTERNAL;

    }
}

