/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractSystemObject;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyKey;

public class Tablespace
extends AbstractSystemObject {
    public static final String TYPE = "TABLESPACE";
    @PropertyKey(value=TablespaceType.class, childOf={Tablespace.class})
    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public static final String TABLESPACE_TYPE_KEY = "TablespaceType";

    public Tablespace() {
        this(null);
    }

    public Tablespace(String name) {
        this.setName(name);
        this.setProperty(TABLESPACE_TYPE_KEY, (Object)TablespaceType.PERMANENT);
    }

    public String getType() {
        return TYPE;
    }

    public void setFileType(FileType fileType) {
        this.setProperty("fileType", (Object)fileType);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public FileType getFileType() {
        return (FileType)((Object)this.getProperty("fileType"));
    }

    public void setFileSpecifications(FileSpecification[] newFiles) {
        this.getChildSupport("fileSpecifications").setChildArray(newFiles);
    }

    public FileSpecification[] getFileSpecifications() {
        return this.getChildSupport("fileSpecifications").getChildArray(FileSpecification.class);
    }

    public void addFileSpecification(FileSpecification fileSpec) {
        this.getChildSupport("fileSpecifications").addChild(fileSpec);
    }

    public void addFileSpecification(int index, FileSpecification col) {
        this.getChildSupport("fileSpecifications").addChild(index, col);
    }

    public FileSpecification getFileSpecification(String name) {
        return (FileSpecification)this.getChildSupport("fileSpecifications").findChild(name);
    }

    public void removeFileSpecification(FileSpecification fileSpec) {
        this.getChildSupport("fileSpecifications").removeChild(fileSpec);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        SMALLFILE,
        BIGFILE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TablespaceType {
        PERMANENT,
        TEMPORARY,
        UNDO;

    }
}

