/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExpander
extends UpdateProcessor {
    public static final String TEMPLATE_OBJECTID = "TemplateObject";
    private static final MultiMap<Class, String> s_propsToClear = new MultiMap();
    private static boolean s_propsToClearInit;
    private static final Collection<Initialiser> s_initialisers;

    @Override
    public boolean onlyProcessesPrimaryUpdates() {
        return true;
    }

    @Override
    public void processUpdate(DBObjectTransaction txn, Difference objDiff) {
        SystemObject obj = (SystemObject)objDiff.getUpdatedObject();
        if (obj != null && objDiff.getOriginalObject() == null) {
            this.checkAndRecurse(obj, txn.getProvider());
        }
    }

    private void checkAndRecurse(DBObject object, DBObjectProvider pro) {
        for (DBObject kid : object.getOwnedObjects()) {
            this.checkAndRecurse(kid, pro);
        }
        if (TemplateExpander.isPendingObject(object)) {
            this.completePendingObject(object, pro);
        }
    }

    private static void makeNameValidAndUnique(DBObject obj, DBObjectProvider pro) {
        if (obj != null && pro != null) {
            String type = obj.getType();
            String base = pro.getInternalName(obj.getName(), type);
            obj.setName(pro.getUniqueName(type, obj, base));
        }
    }

    private void completePendingObject(DBObject object, DBObjectProvider pro) {
        DDL ddl;
        DBObject template = TemplateExpander.getTemplate(object);
        object.getProperties().remove(TEMPLATE_OBJECTID);
        if (object instanceof Table) {
            Table tab = (Table)object;
            for (Column column : tab.getColumns()) {
                column.setName(TemplateExpander.replaceNameFragment(column.getName(), template.getName(), tab.getName()));
                TemplateExpander.makeNameValidAndUnique(column, pro);
                SQLFragment frag = column.getVirtualExpression();
                if (frag == null) continue;
                column.setVirtualExpressionSource(frag.getSQLText());
            }
            for (AbstractBuildableObject abstractBuildableObject : tab.getIndexes()) {
                abstractBuildableObject.setName(TemplateExpander.replaceNameFragment(abstractBuildableObject.getName(), template.getName(), tab.getName()));
                TemplateExpander.makeNameValidAndUnique(abstractBuildableObject, pro);
                for (IndexObject io : ((Index)abstractBuildableObject).getColumnExpressions()) {
                    SQLFragment frag = io.getExpression();
                    if (frag == null) continue;
                    io.setExpressionSource(frag.getSQLText());
                }
            }
            for (AbstractBuildableObject abstractBuildableObject : tab.getConstraints()) {
                CheckConstraint cc;
                SQLFragment frag;
                abstractBuildableObject.setName(TemplateExpander.replaceNameFragment(abstractBuildableObject.getName(), template.getName(), tab.getName()));
                TemplateExpander.makeNameValidAndUnique(abstractBuildableObject, pro);
                if (!(abstractBuildableObject instanceof CheckConstraint) || (frag = (cc = (CheckConstraint)abstractBuildableObject).getCheckConditionFragment()) == null) continue;
                cc.setCheckCondition(frag.getSQLText());
            }
        } else if (object instanceof PlSqlSourceObject && ((PlSqlSourceObject)object).getSource() == null && (ddl = pro.getDDLGenerator().getCreateDDL(new DDLOptions(), object)) != null) {
            ((PlSqlSourceObject)object).setSource(ddl.toString());
        }
    }

    public static final <T extends DBObject> T initialiseObject(T template) {
        PropertyHelper propHelp = new PropertyHelper();
        DBObject object = (DBObject)template.copyTo(null);
        object.setName(null);
        object.setProperty(TEMPLATE_OBJECTID, template.getID());
        for (Map.Entry<Class, Collection<String>> entry : TemplateExpander.getPropertiesToClear().entrySet()) {
            boolean recurse;
            Class clearClass = entry.getKey();
            if (!clearClass.isAssignableFrom(object.getClass())) continue;
            boolean bl = recurse = clearClass == DBObject.class;
            Collection<String> propsToClear = entry.getValue();
            if (propsToClear == null) continue;
            for (String prop : propsToClear) {
                TemplateExpander.clearProp(propHelp, object, prop, recurse);
            }
        }
        for (Initialiser ini : s_initialisers) {
            ini.initialiseObject(template, object);
        }
        return (T)object;
    }

    private static void clearProp(PropertyHelper propHelp, DBObject object, String propPath, boolean recurse) {
        propHelp.setPropertyValue(object, propPath, null);
        if (recurse) {
            for (DBObject kid : object.getOwnedObjects()) {
                TemplateExpander.clearProp(propHelp, kid, propPath, true);
            }
        }
    }

    public static final boolean isPendingObject(DBObject object) {
        DBObject template = TemplateExpander.getTemplate(object);
        if (template != null && template.getID() == null && template.getName() == null) {
            template = null;
        }
        return template != null;
    }

    public static void registerInitialiser(Initialiser ini) {
        s_initialisers.add(ini);
    }

    public static void registerPropertyToClear(Class clearFromClass, String clearProperty) {
        s_propsToClear.add((Object)clearFromClass, (Object)clearProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Class, Collection<String>> getPropertiesToClear() {
        MultiMap<Class, String> multiMap = s_propsToClear;
        synchronized (multiMap) {
            if (!s_propsToClearInit) {
                s_propsToClearInit = true;
                TemplateExpander.registerPropertyToClear(MaterializedViewLog.class, "masterTableID");
                TemplateExpander.registerPropertyToClear(MaterializedViewLog.class, "logTable");
                TemplateExpander.registerPropertyToClear(MaterializedViewLog.class, "columnIDs");
                TemplateExpander.registerPropertyToClear(Trigger.class, "code");
                TemplateExpander.registerPropertyToClear(Trigger.class, "tableOwner");
                TemplateExpander.registerPropertyToClear(Trigger.class, "tableID");
                TemplateExpander.registerPropertyToClear(Trigger.class, "columnIDs");
                TemplateExpander.registerPropertyToClear(SchemaObject.class, "schema");
            }
        }
        return s_propsToClear;
    }

    @Deprecated
    public static void registerPropertiesToClear(Class clearFromClass, ArrayList<String> clearPropsList, boolean append) {
    }

    public static String getTemplateObjectName(DBObject object) {
        DBObject template = TemplateExpander.getTemplate(object);
        if (template != null && template.getName() != null) {
            Schema s;
            StringBuffer name = new StringBuffer();
            if (template instanceof SchemaObject && (s = ((SchemaObject)template).getSchema()) != null) {
                name.append(s.getName()).append(".");
            }
            name.append(template.getName());
            return name.toString();
        }
        return null;
    }

    private static String replaceNameFragment(String fullname, String origFrag, String newFrag) {
        String retval = "_" + fullname + "_";
        String _s1_ = "_" + origFrag + "_";
        String _s2_ = "_" + newFrag + "_";
        int i = 0;
        String tempFrag = "_" + i + "_";
        String s = _s1_ + _s2_;
        while (s.contains(tempFrag)) {
            tempFrag = "_" + ++i + "_";
        }
        while (retval.indexOf(_s1_) >= 0) {
            retval = retval.replace(_s1_, tempFrag);
        }
        while (retval.indexOf(tempFrag) >= 0) {
            retval = retval.replace(tempFrag, _s2_);
        }
        return retval.substring(1, retval.length() - 1);
    }

    private static PlSqlFragment findFragment(PlSqlFragment root, PlSqlFragment.Type type, boolean deep) {
        if (root != null) {
            return root.findChild(type, deep);
        }
        return null;
    }

    @Deprecated
    public static void applySourceFromTemplate(PlSqlSourceObject object) {
    }

    @Deprecated
    public static void applySourceFromTemplate(PlSqlSourceObject template, PlSqlSourceObject object) {
    }

    @Override
    public Collection<String> getProcessorProperties(DBObjectProvider provider) {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(super.getProcessorProperties(provider));
        ret.add(TEMPLATE_OBJECTID);
        return ret;
    }

    private static DBObject getTemplate(DBObject object) {
        DBObjectID templateID = (DBObjectID)object.getProperty(TEMPLATE_OBJECTID);
        DBObject template = null;
        if (templateID != null) {
            try {
                template = templateID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return template;
    }

    static {
        s_initialisers = new ArrayList<Initialiser>();
    }

    public static interface Initialiser {
        public void initialiseObject(DBObject var1, DBObject var2);
    }
}

