/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.compilation;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.compilation.CompilationErrorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationResults {
    private String m_name;
    private String m_type;
    private String m_schemaName;
    private boolean m_isBody;
    private List<CompilationErrorInfo> _errorList;
    private boolean _submitFailed;

    public CompilationResults() {
    }

    public CompilationResults(SourceObject plsql, boolean isBody) {
        this(plsql.getName(), plsql.getType());
        if (plsql.getSchema() != null) {
            this.setSchemaName(plsql.getSchema().getName());
        }
        this.setBody(isBody);
    }

    public CompilationResults(String bn, String bt) {
        this.setBlockName(bn);
        this.setBlockType(bt);
    }

    public synchronized void addError(CompilationErrorInfo ei) {
        if (null == this._errorList) {
            this._errorList = new ArrayList<CompilationErrorInfo>(10);
        }
        this._errorList.add(ei);
    }

    public List<CompilationErrorInfo> getErrorList() {
        return this._errorList;
    }

    public int getErrorCount() {
        if (null == this._errorList) {
            return 0;
        }
        return this._errorList.size();
    }

    public void setBlockName(String bn) {
        this.m_name = bn;
    }

    public String getBlockName() {
        return this.m_name;
    }

    public void setBlockType(String bt) {
        this.m_type = bt;
    }

    public String getBlockType() {
        return this.m_type;
    }

    public void setSubmitFailed(boolean failed) {
        this._submitFailed = failed;
    }

    public boolean isSubmitFailed() {
        return this._submitFailed;
    }

    void setSchemaName(String schemaName) {
        this.m_schemaName = schemaName;
    }

    String getSchemaName() {
        return this.m_schemaName;
    }

    void setBody(boolean isBody) {
        this.m_isBody = isBody;
    }

    boolean isBody() {
        return this.m_isBody;
    }
}

