/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.MissingResourceException;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.resource.APIBundle;

public class DataTypeAttribute
extends AbstractChildDBObject {
    public static final String TYPE = "DatatypeAttribute";
    public static final String DATATYPE_NAME = "name";
    public static final String DATATYPE_SIZE = "size";
    public static final String DATATYPE_PRECISION = "precision";
    public static final String DATATYPE_SCALE = "scale";
    public static final String DATATYPE_UNSIGNED = "unsigned";
    public static final String DATATYPE_IS_REF = "ref";
    public static final String DATATYPE_REF_SCOPE = "ref_scope";
    public static final int DATATYPE_CHAR = 0;
    public static final int DATATYPE_LONG = 1;
    public static final int DATATYPE_LONG_OR_KEYWORD = 2;

    public DataTypeAttribute() {
        this.setExtensible(false);
        this.setMandatory(false);
        this.setDeclarable(false);
    }

    private DataTypeAttribute(String name, int valueType) {
        this();
        this.setName(name);
        this.setValueType(valueType);
    }

    public DataTypeAttribute(String name) {
        this(name, 0);
    }

    public DataTypeAttribute(String name, long minValue, long maxValue) {
        this(name, 1);
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
    }

    public DataTypeAttribute(String name, String labelIndex, long minValue, Long maxValue, Long defaultValue, boolean isMandatory) {
        this(name, 1);
        this.setLabel(labelIndex);
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
        this.setDefaultValue(defaultValue);
        this.setMandatory(isMandatory);
        this.setDeclarable(true);
    }

    public DataTypeAttribute(String name, String labelIndex, String defaultValue, boolean isMandatory) {
        this(name, labelIndex, null, defaultValue, false, isMandatory);
    }

    public DataTypeAttribute(String name, String labelIndex, String[] values, String defaultValue, boolean isExtensible, boolean isMandatory) {
        this(name, 0);
        this.setLabel(labelIndex);
        this.setValues(values);
        this.setDefaultValue(defaultValue);
        this.setExtensible(isExtensible);
        this.setMandatory(isMandatory);
        this.setDeclarable(true);
    }

    @Deprecated
    public DataTypeAttribute(String name, int labelIndex, String[] values, String defaultValue, boolean isExtensible, boolean isMandatory) {
        this(name, null, values, defaultValue, isExtensible, isMandatory);
    }

    public final String getType() {
        return TYPE;
    }

    public int getValueType() {
        return (Integer)this.getProperty("valueType", 0);
    }

    public void setValueType(int valueType) {
        this.setProperty("valueType", valueType);
    }

    public String getLabel() {
        String retval = (String)this.getProperty("label");
        if (retval != null) {
            try {
                retval = APIBundle.get(retval);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return retval;
    }

    public void setLabel(String label) {
        this.setProperty("label", label);
    }

    public Long getMinValue() {
        return (Long)this.getProperty("minValue");
    }

    public void setMinValue(Long minValue) {
        this.setProperty("minValue", minValue);
    }

    public Long getMaxValue() {
        return (Long)this.getProperty("maxValue");
    }

    public void setMaxValue(Long maxValue) {
        this.setProperty("maxValue", maxValue);
    }

    public String[] getValues() {
        return (String[])this.getProperty("values");
    }

    public void setValues(String[] values) {
        this.setProperty("values", values);
    }

    public Object getDefaultValue() {
        return this.getProperty("defaultValue");
    }

    public void setDefaultValue(Object defaultValue) {
        this.setProperty("defaultValue", defaultValue);
    }

    public boolean isDeclarable() {
        return (Boolean)this.getProperty("declarable", false);
    }

    public void setDeclarable(boolean isDeclarable) {
        this.setProperty("declarable", isDeclarable);
    }

    public boolean isMandatory() {
        return (Boolean)this.getProperty("mandatory", false);
    }

    public void setMandatory(boolean isMandatory) {
        this.setProperty("mandatory", isMandatory);
    }

    public boolean isExtensible() {
        return (Boolean)this.getProperty("extensible", false);
    }

    public void setExtensible(boolean isExtensible) {
        this.setProperty("extensible", isExtensible);
    }
}

