/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.marshal.AbstractResourceCache;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeCache
extends AbstractResourceCache {
    private final Map<String, DataType> m_dataTypes = new TreeMap<String, DataType>();

    public DataTypeCache(DatabaseDescriptor desc, String resourceDir) {
        super(desc, resourceDir);
    }

    private void checkTypeName(String dataTypeName) {
        if (!ModelUtil.hasLength((String)dataTypeName)) {
            throw new IllegalArgumentException("All types must have a non-empty name.");
        }
        if (this.m_dataTypes.containsKey(dataTypeName)) {
            throw new IllegalArgumentException(dataTypeName + " already registered");
        }
    }

    private void registerDataType(String dataTypeName, DataType dt) {
        this.checkTypeName(dataTypeName);
        this.m_dataTypes.put(dataTypeName, dt);
        dt.setID(new DataTypeID(dataTypeName, this.getDatabaseDescriptor()));
        if (dt instanceof PredefinedDataType) {
            DataTypeRegistry.getInstance().registerAttributes(dt);
        }
    }

    public final void registerDataType(DataType dt) {
        this.registerDataType(dt.getName(), dt);
    }

    public final void registerDataTypeResource(PredefinedDataType dt) {
        String dataTypeName = dt.getName();
        this.registerDataTypeResource(dataTypeName, dt);
    }

    public final void registerDataType(String dataTypeName) {
        PredefinedDataType dt = new PredefinedDataType(dataTypeName);
        this.registerDataTypeResource(dataTypeName, dt);
    }

    private void registerDataTypeResource(String dataTypeName, PredefinedDataType dt) {
        this.markForLazyInit(dt, this.getResourcePath(dataTypeName + ".xml"));
        this.registerDataType(dataTypeName, dt);
    }

    public final void registerDataTypeSynonym(String dataTypeName, String baseTypeName) {
        DataType baseType = this.m_dataTypes.get(baseTypeName);
        if (baseType == null) {
            throw new IllegalArgumentException(baseTypeName + " is not registered.");
        }
        if (baseType instanceof DataTypeSynonym) {
            throw new IllegalArgumentException(baseTypeName + " is already a synonym.");
        }
        DataTypeSynonym dts = new DataTypeSynonym(dataTypeName, baseType);
        this.registerDataType(dataTypeName, dts);
    }

    public Collection<DataType> listSupportedDataTypes() {
        Collection<DataType> dts = this.m_dataTypes.values();
        return new ArrayList<DataType>(dts);
    }

    public DataType getDataType(String dataTypeName) {
        return this.m_dataTypes.get(dataTypeName);
    }

    public int getDataTypeCount() {
        return this.m_dataTypes.size();
    }
}

