/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Map;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.util.ModelUtil;

public class DataTypeSynonym
extends AbstractDBObject
implements DataType {
    private DataType m_delegate;
    private PlSqlSearch m_search;

    public DataTypeSynonym() {
    }

    public DataTypeSynonym(String name, DataType synonymFor) {
        assert (name != null);
        assert (synonymFor != null);
        this.m_delegate = synonymFor;
        this.setName(name);
    }

    public DataType getBaseType() {
        return this.m_delegate;
    }

    public Integer getSQLType() {
        return this.m_delegate.getSQLType();
    }

    public DataTypeAttribute[] getDataTypeAttributes() {
        return this.m_delegate.getDataTypeAttributes();
    }

    public boolean hasDataTypeAttribute(String name) {
        return this.m_delegate.hasDataTypeAttribute(name);
    }

    public DataTypeAttribute getDataTypeAttribute(String name) {
        return this.m_delegate.getDataTypeAttribute(name);
    }

    public String getDDL(DataTypeUsage dataTypeUsage) {
        return this.m_delegate.getDDL(dataTypeUsage).replaceFirst(this.m_delegate.getName(), this.getName());
    }

    public DataTypeUsage createDefaultUsage() {
        DataTypeUsage usage = this.m_delegate.createDefaultUsage();
        usage.setDataTypeID(this.getID());
        return usage;
    }

    public DataTypeUsage createUsage(Map attributes) {
        String nameAttr;
        if (attributes != null && (nameAttr = (String)attributes.get("name")) != null) {
            nameAttr = nameAttr.replaceAll(this.getName(), this.m_delegate.getName());
            attributes.put("name", nameAttr);
        }
        DataTypeUsage usage = this.m_delegate.createUsage(attributes);
        usage.setDataTypeID(this.getID());
        return usage;
    }

    @Deprecated
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
    }

    @Deprecated
    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
    }

    protected void copyToImpl(AbstractDBObject other, DBObject copyParent, IDPolicy idPolicy) {
        DataTypeSynonym target = (DataTypeSynonym)other;
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_delegate = this.m_delegate;
    }

    protected boolean equalsImpl(AbstractDBObject other) {
        DataTypeSynonym target = (DataTypeSynonym)other;
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)target.m_delegate, (Object)this.m_delegate);
    }

    public String getType() {
        return this.m_delegate == null ? null : this.m_delegate.getType();
    }

    public boolean matches(String usageString) {
        return DataTypeHelper.matches(this.getSearch(), usageString);
    }

    public DataTypeUsage createUsage(String usageString) {
        return DataTypeHelper.getUsageFromString(this, this.getSearch(), usageString);
    }

    private PlSqlSearch getSearch() {
        if (this.m_search == null && this.m_delegate instanceof PredefinedDataType) {
            PredefinedDataType pdt = (PredefinedDataType)this.m_delegate;
            String definition = pdt.getDefinitionForSearch().replace(pdt.getName(), this.getName());
            this.m_search = DataTypeHelper.buildSearch(definition, this.getDataTypeAttributes());
        }
        return this.m_search;
    }
}

