/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeUsage
extends AbstractChildDBObject {
    public static final String TYPE = "DataTypeUsage";
    private final Map<String, Object> m_attributeValues = new HashMap<String, Object>(){

        @Override
        public Object put(String key, Object value) {
            Object retval = value == null ? super.remove(key) : super.put(key, value);
            if (key != null && ModelUtil.areDifferent(retval, (Object)value)) {
                DataTypeUsage.this.firePropertyChanged(Property.createPath("attributeValues", key), retval, value);
            }
            return retval;
        }

        @Override
        public Object remove(Object key) {
            return key instanceof String ? this.put((String)key, (Object)null) : null;
        }
    };

    public DataTypeUsage() {
    }

    public DataTypeUsage(DataType dt) {
        if (dt != null) {
            this.setDataTypeID(dt.getID());
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject target) {
        return super.equalsImpl(target) && DBUtil.areEqualIgnoreNullValues(this.m_attributeValues, ((DataTypeUsage)target).m_attributeValues);
    }

    @Override
    protected void copyToImpl(AbstractDBObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        ((DataTypeUsage)target).setAttributeValues(this.m_attributeValues);
    }

    public final void setDataTypeID(DBObjectID dataTypeID) {
        this.setProperty("dataTypeID", dataTypeID);
    }

    public final DBObjectID getDataTypeID() {
        return (DBObjectID)this.getProperty("dataTypeID");
    }

    public final void setAttributeValues(Map<String, Object> attributeValues) {
        if (attributeValues != this.m_attributeValues) {
            if (attributeValues == null) {
                attributeValues = Collections.emptyMap();
            }
            HashSet<String> keys = new HashSet<String>();
            keys.addAll(attributeValues.keySet());
            keys.addAll(this.m_attributeValues.keySet());
            for (String key : keys) {
                this.putAttributeValue(key, attributeValues.get(key));
            }
        }
    }

    public final Map<String, Object> getAttributeValues() {
        return this.m_attributeValues;
    }

    public final Object getAttributeValue(String name) {
        return this.m_attributeValues.get(name);
    }

    public final void putAttributeValue(String name, Object value) {
        this.m_attributeValues.put(name, value);
    }

    public final void deleteAttributeValue(String name) {
        this.putAttributeValue(name, null);
    }

    public final boolean hasAttributeValue(String name) {
        return this.m_attributeValues.containsKey(name);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        for (Object o : this.m_attributeValues.values()) {
            if (!(o instanceof DBObjectID)) continue;
            refs.add((DBObjectID)o);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<? extends DBObjectID, ? extends DBObjectID> idMap) {
        boolean retval = super.replaceReferenceIDs(idMap);
        for (Map.Entry<String, Object> e : this.m_attributeValues.entrySet()) {
            Object val = e.getValue();
            if (!(val instanceof DBObjectID) || !idMap.containsKey((DBObjectID)val)) continue;
            e.setValue(idMap.get((DBObjectID)val));
            retval = true;
        }
        return retval;
    }
}

