/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLStatementWrapper;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DDLDatabase
extends AbstractDatabase {
    protected DDLDatabase(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
        this.reconnected(conn);
    }

    private DDLGenerator getDDLGeneratorOrFail() throws UnsupportedOperationException {
        DDLGenerator gen = this.getDDLGenerator();
        if (gen == null) {
            throw new UnsupportedOperationException("DDL generation not supported.");
        }
        return gen;
    }

    @Override
    public DiffEngine getDiffEngine() {
        return GenericDiffEngine.getDiffEngine(true, false, true);
    }

    protected final boolean executeDDL(DDL ddl, boolean ignoreErrors) throws DBException {
        return this.executeDDL(ddl, ignoreErrors, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeDDL(DDL ddl, boolean ignoreErrors, DDLStatementWrapper.ExceptionHandler handler) throws DBException {
        boolean retval = false;
        if (ddl.size() >= 1) {
            boolean autoCommitSwitch = false;
            try {
                ConnectionWrapper wrapper = new ConnectionWrapper(this, "");
                autoCommitSwitch = wrapper.call(new ConnectionWrapper.SQLCallable<Boolean>(wrapper){

                    @Override
                    public Boolean call() throws SQLException {
                        boolean ddlCausesCommit = this.getConnection().getMetaData().dataDefinitionCausesTransactionCommit();
                        return !ddlCausesCommit && !this.getConnection().getAutoCommit();
                    }
                });
            }
            catch (DBException dbe) {
                DBLog.getLogger(this).log(Level.WARNING, dbe.getMessage());
            }
            DDLStatementWrapper wrap = new DDLStatementWrapper((Database)this, ddl);
            wrap.setIgnoreErrors(ignoreErrors);
            wrap.setExceptionHandler(handler);
            try {
                if (autoCommitSwitch) {
                    this.setAutoCommit(true);
                }
                retval = wrap.execute();
                Object var8_8 = null;
                if (autoCommitSwitch) {
                    this.setAutoCommit(false);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (autoCommitSwitch) {
                    this.setAutoCommit(false);
                }
                throw throwable;
            }
        }
        return retval;
    }

    private void setAutoCommit(final boolean autoCommit) {
        ConnectionWrapper wrapper = new ConnectionWrapper(this, APIBundle.get("SET_AUTOCOMMIT"));
        try {
            ConnectionWrapper connectionWrapper = wrapper;
            connectionWrapper.getClass();
            wrapper.run(new ConnectionWrapper.SQLRunnable(connectionWrapper){

                public void run() throws SQLException {
                    this.getConnection().setAutoCommit(autoCommit);
                }
            });
        }
        catch (DBException dbe) {
            DBLog.getLogger(this).log(Level.WARNING, dbe.getMessage());
        }
    }

    @Override
    public final boolean canCreate(SystemObject object, boolean replace) {
        boolean retval = false;
        DDLGenerator gen = this.getDDLGenerator();
        if (gen != null) {
            boolean exists = this.exists(object);
            if (replace || !exists) {
                PropertyAction.Type actionType;
                String type = object.getType();
                PropertyAction.Type type2 = actionType = exists ? PropertyAction.Type.REPLACE : PropertyAction.Type.CREATE;
                if (gen.supportsAction(type, actionType)) {
                    retval = this.skipPrivCheck(type) ? true : this.hasSystemPrivilege(type, DBUtil.getSchema(object), "CREATE");
                }
            }
        }
        return retval;
    }

    @Override
    public final boolean canDelete(SystemObject obj, boolean cascade) {
        String type;
        boolean retval = false;
        DDLGenerator gen = this.getDDLGenerator();
        if (gen != null && this.exists(obj) && gen.supportsAction(type = obj.getType(), PropertyAction.Type.DELETE)) {
            retval = this.skipPrivCheck(type) ? true : this.hasSystemPrivilege(type, DBUtil.getSchema(obj), "DELETE");
        }
        return retval;
    }

    private boolean skipPrivCheck(String type) {
        return DBObjectRegistry.isExtensionType(type, this.getDatabaseType(), this.getDatabaseVersion());
    }

    @Override
    public final void createSchema(Schema schema, boolean replace) throws DBException {
        Schema oldSchema;
        if (schema == null) {
            throw new IllegalArgumentException("null Schema in createSchema");
        }
        if (this.getSchema(schema.getName()) == null) {
            replace = false;
        } else if (!replace) {
            throw new NameInUseException(schema);
        }
        DDL ddl = null;
        DDLGenerator gen = this.getDDLGeneratorOrFail();
        try {
            ddl = gen.getCreateDDL(new DDLOptions(replace, true), schema);
        }
        catch (UnsupportedDDLException uoe) {
            uoe.throwDBException();
        }
        if (ddl == null || ddl.size() == 0) {
            UnsupportedDDLException.createNotSupported(schema);
        }
        if (replace && (oldSchema = this.getSchema(schema.getName())) != null) {
            if (oldSchema == schema) {
                throw new IllegalArgumentException("Cannot replace schema with itself");
            }
            if (!this.canDelete(oldSchema, true)) {
                throw new DBException((DBObject)schema, "Cannot drop existing schema " + oldSchema.getName());
            }
        }
        this.executeDDL(ddl, false);
        Schema newSchema = this.getSchema(schema.getName());
        if (newSchema == null) {
            throw new DBException((DBObject)schema, "Created schema wasn't found in the database.");
        }
        this.fireObjectsAdded(Collections.singleton(newSchema));
    }

    @Override
    public final void deleteSchema(Schema schema, boolean cascade) throws DBException {
        schema = this.getSchema(schema.getName());
        DDLGenerator gen = this.getDDLGeneratorOrFail();
        DDL ddl = null;
        try {
            ddl = gen.getDeleteDDL(new DDLOptions(false, cascade), schema);
        }
        catch (UnsupportedDDLException uoe) {
            uoe.throwDBException();
        }
        if (ddl == null || ddl.size() == 0) {
            UnsupportedDDLException.deleteNotSupported(schema).throwDBException();
        }
        this.executeDDL(ddl, false);
        this.uncacheObject(schema);
        this.fireObjectsRemoved(Collections.singleton(schema));
    }

    @Override
    public final void updateSchema(Schema oldSchema, Schema newSchema) throws DBException {
        UnsupportedDDLException.updateNotSupported(oldSchema).throwDBException();
    }

    @Override
    public final void createObjects(SystemObject[] objects, boolean replace) throws DBException {
        SystemObject[] existing = new SystemObject[objects.length];
        DiffEngine de = this.getDiffEngine();
        Difference diff = de.difference(existing, objects);
        this.updateObjects(diff, replace, false);
    }

    protected void processCreateException(DBException dbe, SystemObject object) throws DBException {
        if (object == null) {
            for (DBObject dbo = dbe.getObject(); dbo != null; dbo = dbo.getParent()) {
                if (!(dbo instanceof SystemObject)) continue;
                object = (SystemObject)dbo;
                break;
            }
        }
        if (this.isCauseNameInUse(dbe)) {
            throw new NameInUseException(object);
        }
        if (object != null && this.exists(object)) {
            try {
                this.deleteObject(object, true);
            }
            catch (DBException dbe2) {
                this.getLogger().warning(APIBundle.format("CREATE_ROLLBACK_ERR", object.getType(), object.getName(), dbe2));
            }
        }
        throw dbe;
    }

    protected boolean isCauseNameInUse(DBException dbe) {
        return false;
    }

    @Override
    public void deleteObjects(SystemObject[] objects, boolean cascade) throws DBException {
        if ((objects = DBUtil.stripNulls(DBUtil.getProviderDefinitions((SystemObject[])objects, (DBObjectProvider)this))).length > 0) {
            this.updateObjects(this.getDiffEngine().difference(objects, new SystemObject[objects.length]), false, cascade);
        }
    }

    protected void processDeleteException(DBException dbe, SystemObject object) throws DBException {
        throw dbe;
    }

    @Override
    public final void undeleteObject(SchemaObject object) throws DBException {
        this.undeleteObjects(new SchemaObject[]{object});
    }

    @Override
    public final void undeleteObjects(SchemaObject[] objects) throws DBException {
        if ((objects = DBUtil.stripNulls(objects)) != null && objects.length > 0) {
            DDL ddl = null;
            DDLGenerator ddlgen = this.getDDLGeneratorOrFail();
            DDLOptions options = new DDLOptions(false, false);
            try {
                ddl = ddlgen.getUndeleteDDL(options, objects);
            }
            catch (UnsupportedDDLException uoe) {
                uoe.throwDBException();
            }
            if (ddl == null) {
                UnsupportedDDLException.undeleteNotSupported(objects[0]).throwDBException();
            }
            if (this.executeDDL(ddl, false)) {
                this.finishUpdates(this.getDiffEngine().difference(objects, new SystemObject[objects.length]));
            }
        }
    }

    @Override
    protected Collection<DBObjectChange> commitTransaction(DBObjectTransaction txn, Difference listDiff) throws DBException {
        DDLOptions options = new DDLOptions(txn.isReplace(), txn.isCascade());
        boolean plsql = false;
        Holder ddlHolder = new Holder();
        Holder deleteDDLHolder = new Holder();
        Collection<? extends Difference> l = listDiff.getChildren();
        SystemObject[] oldObjects = new SystemObject[l.size()];
        SystemObject[] newObjects = new SystemObject[l.size()];
        SystemObject[] existingObjects = new SystemObject[l.size()];
        int i = 0;
        for (Difference difference : l) {
            if (!difference.isSame()) {
                oldObjects[i] = (SystemObject)difference.getOriginalObject();
                newObjects[i] = (SystemObject)difference.getUpdatedObject();
                existingObjects[i] = this.getExistingObject(oldObjects[i], newObjects[i]);
                if (newObjects[i] instanceof PlSqlSourceObject) {
                    plsql = true;
                }
                this.appendUpdateDDL(oldObjects[i], newObjects[i], existingObjects[i], difference, options, (Holder<DDL>)(newObjects[i] == null ? deleteDDLHolder : ddlHolder));
            }
            ++i;
        }
        if (plsql) {
            this.setCompilerOptions();
        }
        DDL ddl = (DDL)ddlHolder.get();
        DDL deleteDDL = (DDL)deleteDDLHolder.get();
        boolean bl = ddl != null && ddl.size() > 0;
        boolean hasDelete = deleteDDL != null && deleteDDL.size() > 0;
        boolean changed = false;
        if (hasDelete) {
            DDLStatementWrapper.ExceptionHandler handler = new DDLStatementWrapper.ExceptionHandler(){

                public void handleException(DBSQLException dbe) throws DBException {
                    DDLDatabase.this.processDeleteException(dbe, DBUtil.getSystemObject(dbe.getObject()));
                }
            };
            changed = this.executeDDL(deleteDDL, false, handler);
        }
        if (bl) {
            try {
                if (this.executeDDL(ddl, false)) {
                    changed = true;
                }
            }
            catch (DBSQLException dbse) {
                DBObject exceptionObject = dbse.getObject();
                for (int i2 = 0; i2 < newObjects.length; ++i2) {
                    if (exceptionObject != newObjects[i2] && DBUtil.getSystemObject(exceptionObject) != newObjects[i2]) continue;
                    if (existingObjects[i2] == null) {
                        this.processCreateException(dbse, newObjects[i2]);
                        break;
                    }
                    if (newObjects[i2] == null || this.supportsTimestamps(existingObjects[i2].getType())) continue;
                    DBUtil.forceObjectReset(existingObjects[i2], this);
                }
                throw dbse;
            }
        }
        Collection<DBObjectChange> retval = null;
        if (changed) {
            retval = this.finishUpdates(listDiff);
        } else {
            for (SystemObject obj : newObjects) {
                if (obj == null) continue;
                UnsupportedDDLException.updateNotSupported(obj).throwDBException();
            }
        }
        return retval;
    }

    private SystemObject getExistingObject(SystemObject oldObject, SystemObject newObject) throws DBException {
        return DBUtil.getProviderDefinition(oldObject == null ? newObject : oldObject, (DBObjectProvider)this);
    }

    @Override
    public final Schema[] listSchemas() throws DBException {
        return super.listSchemas();
    }

    private void appendUpdateDDL(SystemObject original, SystemObject updated, SystemObject existing, Difference d, DDLOptions options, Holder<DDL> ddlHolder) throws DBException {
        try {
            DDL ddl;
            DDLGenerator gen = this.getDDLGeneratorOrFail();
            if (original == null) {
                if (existing == null) {
                    if (options.isReplace()) {
                        options = (DDLOptions)((Object)options.copyTo(null));
                        options.setReplace(false);
                    }
                } else if (!options.isReplace()) {
                    throw new NameInUseException(existing);
                }
                ddl = gen.getCreateDDL(options, updated);
            } else if (updated != null) {
                ddl = gen.getUpdateDDL(options, d);
            } else {
                ddl = gen.getDeleteDDL(options, original);
                if (ddl == null) {
                    this.getLogger().log(Level.WARNING, "Could not drop " + original.getType() + original.getName());
                }
            }
            DDL appendTo = (DDL)ddlHolder.get();
            if (appendTo == null) {
                ddlHolder.set(ddl);
            } else {
                appendTo.append(ddl);
            }
        }
        catch (UnsupportedDDLException ude) {
            ude.throwDBException();
        }
    }

    public void setCompilerOptions() {
    }
}

