/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DDLStatementWrapper
extends StatementWrapper {
    private final DDL m_ddl;
    private ExceptionHandler m_handler;

    public DDLStatementWrapper(Database db, DDL<? extends DDLType> ddl) {
        super(db, true, (String[])null);
        Collection<String> ddls = ddl.getStatements();
        this.setStatement(ddls.toArray(new String[ddl.size()]));
        this.m_ddl = ddl;
    }

    public void setExceptionHandler(ExceptionHandler handler) {
        this.m_handler = handler;
    }

    @Override
    public boolean execute() throws DBException {
        if (this.m_ddl == null || this.m_ddl.size() == 0) {
            return false;
        }
        return this.doExecute(new StatementWrapper.ExecutionRunnable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean runImpl() throws DBException {
                boolean retval = false;
                Connection connection = DDLStatementWrapper.this.getConnection();
                synchronized (connection) {
                    DDLStatementWrapper.this.setExecuting(true);
                    try {
                        retval = true;
                        Map stmts = DDLStatementWrapper.this.m_ddl.getStatementsForExecution();
                        for (Collection<DDL.StatementWithObject> swos : stmts.values()) {
                            if (swos == null) continue;
                            for (DDL.StatementWithObject swo : swos) {
                                String s = swo.getStatement();
                                if (!ModelUtil.hasLength((String)s)) continue;
                                try {
                                    retval = DDLStatementWrapper.this.executeImpl(s) || retval;
                                }
                                catch (SQLException sqe) {
                                    if (DDLStatementWrapper.this.isIgnoreErrors()) continue;
                                    DBSQLException dbe = DDLStatementWrapper.this.createDBSQLException(swo.getObject(), s, sqe);
                                    if (DDLStatementWrapper.this.m_handler != null) {
                                        DDLStatementWrapper.this.m_handler.handleException(dbe);
                                        continue;
                                    }
                                    throw dbe;
                                }
                            }
                        }
                        Object var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        DDLStatementWrapper.this.close();
                        DDLStatementWrapper.this.setExecuting(false);
                        throw throwable;
                    }
                    DDLStatementWrapper.this.close();
                    DDLStatementWrapper.this.setExecuting(false);
                }
                return retval;
            }
        });
    }

    public static abstract class ExceptionHandler {
        public abstract void handleException(DBSQLException var1) throws DBException;
    }
}

