/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.dictionary;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.dictionary.DictionaryQueries;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DictionaryDatabase
extends DDLDatabase {
    private Map<String, DBObjectLister> m_listers;

    protected DictionaryDatabase(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    protected QueryWrapper newQueryWrapper(SystemObject obj, String query, Object ... params) {
        return this.newQueryWrapper(obj, query, Arrays.asList(params));
    }

    protected QueryWrapper newQueryWrapper(SystemObject obj, String query, List params) {
        QueryWrapper wrap = new QueryWrapper((Database)this, query, params);
        if (obj != null && obj.getID() instanceof BaseObjectID) {
            wrap.setDatabaseName(((BaseObjectID)obj.getID()).getDatabaseName());
        }
        return wrap;
    }

    protected abstract DictionaryQueries getDictionaryQueries();

    protected boolean isSupportedType(String type) {
        return this.getBuilderForType(type) != null;
    }

    @Override
    public boolean supportsTimestamps(String objectType) {
        DBObjectLister lister;
        boolean retval;
        DictionaryQueries dq = this.getDictionaryQueries();
        boolean bl = retval = dq.getTimestampQueryByID(objectType) != null || dq.getTimestampQueryByName(objectType) != null;
        if (!retval && (lister = this.getLister(objectType)) != null) {
            retval = lister.supportsTimestamps(objectType);
        }
        return retval;
    }

    protected QueryWrapper[] getListQueries(DBObjectCriteria<? extends SystemObject> criteria) {
        QueryWrapper[] wrappers;
        String type;
        String query;
        DictionaryQueries dictionary = this.getDictionaryQueries();
        Collection<String> types = criteria.getTypes();
        String ref = criteria.getName();
        boolean hasWildcard = false;
        if (!ModelUtil.hasLength((String)ref)) {
            ref = criteria.getNameLike();
            hasWildcard = DBObjectCriteria.containsWildcard(ref);
        }
        Schema defSchema = null;
        Schema schema = null;
        try {
            schema = this.getCriteriaSchema(criteria);
            if (criteria.getDatabaseName() == null && schema != null) {
                defSchema = this.getDefaultSchema();
            }
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Couldn't get schemas : " + dbe.getMessage());
        }
        String schemaName = schema == null ? null : schema.getName();
        boolean defaultSchema = ModelUtil.areEqual((Object)schemaName, (Object)(defSchema == null ? null : defSchema.getName()));
        ArrayList<QueryWrapper> queries = new ArrayList<QueryWrapper>();
        if (!hasWildcard && types.size() == 1 && (query = dictionary.getSingleObjectQuery(type = types.iterator().next(), defaultSchema, criteria)) != null) {
            List<String> params = this.getParameters(dictionary.getSingleObjectQueryParams(type, defaultSchema, criteria), schema, ref, type);
            QueryWrapper qw = this.newQueryWrapper(null, query, params);
            qw.setDatabaseName(criteria.getDatabaseName());
            qw.setIdentifier(type);
            queries.add(qw);
        }
        if (queries.isEmpty()) {
            ArrayList<String> standardObj = new ArrayList<String>();
            for (String type2 : types) {
                if (!this.isSupportedType(type2)) continue;
                if (dictionary.isCustomListQuery(type2, defaultSchema, criteria)) {
                    String query2 = dictionary.getCustomListQuery(type2, defaultSchema, criteria);
                    List<String> params = this.getParameters(dictionary.getCustomListQueryParams(type2, defaultSchema, criteria), schema, ref, type2);
                    QueryWrapper qw = this.newQueryWrapper(null, query2, params);
                    qw.setDatabaseName(criteria.getDatabaseName());
                    qw.setIdentifier(type2);
                    queries.add(qw);
                    continue;
                }
                standardObj.add(type2);
            }
            if (standardObj.size() > 0) {
                String[] standardTypes = standardObj.toArray(new String[standardObj.size()]);
                String query3 = dictionary.getStandardListQuery(standardTypes);
                List<String> params = this.getParameters(dictionary.getStandardListQueryParams(), schema, ref, standardTypes);
                QueryWrapper qw = this.newQueryWrapper(null, query3, params);
                qw.setDatabaseName(criteria.getDatabaseName());
                queries.add(0, qw);
            }
        }
        if ((wrappers = queries.toArray(new QueryWrapper[queries.size()])).length > 1 && dictionary.canUnionListQueries()) {
            wrappers = new QueryWrapper[]{QueryWrapper.union(wrappers)};
        }
        return wrappers;
    }

    @Override
    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> criteria) throws DBException {
        Collection<DBObjectLister.ObjectInfo> objectInfos = this.listObjectInfos(criteria);
        ArrayList<SystemObject> retval = new ArrayList<SystemObject>();
        for (DBObjectLister.ObjectInfo info : objectInfos) {
            SystemObject object = this.findOrCreateObject(info, criteria);
            if (object == null) continue;
            retval.add(object);
        }
        return retval;
    }

    private Collection<DBObjectLister.ObjectInfo> listObjectInfos(DBObjectCriteria<? extends SystemObject> criteria) throws DBException {
        Collection<DBObjectLister> listers;
        final ArrayList<DBObjectLister.ObjectInfo> objectInfos = new ArrayList<DBObjectLister.ObjectInfo>();
        final Schema schema = this.getCriteriaSchema(criteria);
        QueryWrapper[] queries = this.getListQueries(criteria);
        if (queries != null) {
            Integer maxi = null;
            try {
                maxi = Integer.getInteger("oracle.db.MaxFetchCount");
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            final int maxCount = maxi == null ? Integer.MAX_VALUE : maxi;
            for (int i = 0; i < queries.length; ++i) {
                final QueryWrapper wrap = queries[i];
                wrap.setDatabaseName(criteria.getDatabaseName());
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            int count = 0;
                            while (rs.next() && !Thread.currentThread().isInterrupted()) {
                                String type;
                                int cols = rs.getMetaData().getColumnCount();
                                String name = rs.getString(1);
                                String string = type = cols < 2 ? wrap.getIdentifier() : rs.getString(2).trim();
                                if (!ModelUtil.hasLength((String)type)) {
                                    throw new DBException(null, "Query is listing objects with an unknown type.");
                                }
                                if (!DictionaryDatabase.this.supportsObjectType(type = type.toUpperCase())) {
                                    DictionaryDatabase.this.getLogger().log(Level.WARNING, "Unsupported object type: " + type);
                                } else {
                                    Object idVal;
                                    Object object = idVal = cols < 3 ? null : rs.getObject(3);
                                    if (rs.wasNull() || idVal instanceof String && ((String)idVal).equalsIgnoreCase("null") || idVal instanceof Number && ((Number)idVal).intValue() == 0) {
                                        idVal = null;
                                    }
                                    Timestamp tsVal = cols < 4 ? null : rs.getTimestamp(4);
                                    Long tsLong = tsVal == null ? null : Long.valueOf(tsVal.getTime());
                                    objectInfos.add(new DBObjectLister.ObjectInfo(type, schema, name, idVal, tsLong));
                                    if (++count < maxCount) continue;
                                }
                                break;
                            }
                        }
                        catch (SQLException sqe) {
                            wrap.throwDBException(sqe);
                        }
                    }
                };
                queries[i].executeQuery(500, r);
            }
        }
        if ((listers = this.getListers(criteria.getTypeArray())) != null) {
            for (DBObjectLister lister : listers) {
                Collection<DBObjectLister.ObjectInfo> infos = lister.listObjects(criteria);
                if (infos == null) continue;
                objectInfos.addAll(infos);
            }
        }
        return objectInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DBObjectLister> getListers(String ... objectTypes) {
        HashSet<DBObjectLister> retval = null;
        if (objectTypes != null && DBObjectRegistry.isActive()) {
            DictionaryDatabase dictionaryDatabase = this;
            synchronized (dictionaryDatabase) {
                if (this.m_listers == null) {
                    this.m_listers = DBObjectRegistry.getInstance().getListers(this.getDatabaseType(), this.getDatabaseVersion(), this);
                }
            }
            retval = new HashSet<DBObjectLister>();
            for (String type : objectTypes) {
                DBObjectLister lister = this.m_listers.get(type);
                if (lister == null) continue;
                retval.add(lister);
            }
        }
        return retval;
    }

    private DBObjectLister getLister(String objectType) {
        DBObjectLister retval = null;
        Collection<DBObjectLister> listers = this.getListers(objectType);
        if (listers != null && !listers.isEmpty()) {
            retval = listers.iterator().next();
        }
        return retval;
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] params, Schema schema, String nameref, String ... typeList) {
        return this.getParameters(params, schema == null ? null : schema.getName(), nameref, typeList);
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] params, String schema, String nameref, Collection<String> typeList) {
        return this.getParameters(params, schema, nameref, typeList.toArray(new String[typeList.size()]));
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] params, String schema, String nameref, String ... typeList) {
        return this.getParameters(params, (Object)null, schema, nameref, typeList);
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] params, BaseObjectID id) {
        return this.getParameters(params, id instanceof IdentifierBasedID ? ((IdentifierBasedID)id).getIdentifier() : null, id.getSchemaName(), id.getName(), id.getType());
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] params, Object identifier, String schema, String nameref, String ... typeList) {
        ArrayList<String> retval = new ArrayList<String>();
        block7: for (int i = 0; i < params.length; ++i) {
            switch (params[i]) {
                case IDENTIFIER: {
                    retval.add(String.valueOf(identifier));
                    continue block7;
                }
                case SCHEMA: {
                    retval.add(schema);
                    continue block7;
                }
                case NAMEREF: {
                    retval.add(nameref);
                    continue block7;
                }
                case TYPES: {
                    String typeListString = DictionaryQueries.convertArrayToQuotedList(typeList);
                    retval.add(typeListString);
                    continue block7;
                }
                case ALL_TYPES: {
                    retval.addAll(Arrays.asList(typeList));
                }
            }
        }
        return retval;
    }

    @Override
    protected final Long getExternalTimestampImpl(SystemObject obj) throws DBException {
        Long retval = null;
        String type = obj.getType();
        DictionaryQueries dq = this.getDictionaryQueries();
        if (dq.getTimestampQueryByName(type) != null || dq.getTimestampQueryByID(type) != null) {
            SchemaObject object = (SchemaObject)obj;
            DBObjectID id = object.getID();
            Long l = retval = id != null ? this.getExternalTimestampByID(id) : this.getExternalTimestampByName(object.getType(), object.getSchema(), object.getName());
            if (retval != null) {
                AbstractDBObjectBuilder tableBuilder;
                if ("PACKAGE".equals(type) || "TYPE".equals(type)) {
                    String bodyType = "PACKAGE".equals(type) ? "PACKAGE BODY" : "TYPE BODY";
                    String name = object.getName();
                    Schema schema = object.getSchema();
                    SystemObject body = this.findObject(bodyType, schema, name);
                    Long tsBody = body != null ? this.getExistingTimestamp(body) : this.getExternalTimestampByName(bodyType, schema, name);
                    if (tsBody != null && tsBody.compareTo(retval) > 0) {
                        retval = tsBody;
                    }
                } else if ("TABLE".equals(type) && !(tableBuilder = (AbstractDBObjectBuilder)this.getBuilderForType(type)).needsBuilding((Table)object, "indexes", true)) {
                    String key = "5501663 : Suspend getting timestamps while getting indexes";
                    this.suspendTimestampQueries(key);
                    Index[] indexes = ((Table)object).getIndexes();
                    this.resumeTimestampQueries(key);
                    for (Index index : indexes) {
                        Long idxTs = this.getExternalTimestamp(index);
                        if (idxTs == null && index.getID() != null) {
                            idxTs = this.getExternalTimestampByName(index.getType(), index.getSchema(), index.getName());
                        }
                        if (idxTs == null) {
                            Long existing = (Long)object.getProperty("Timestamp");
                            if (existing == null || !existing.equals(retval)) continue;
                            Long l2 = retval;
                            Long l3 = retval = Long.valueOf(retval + 1L);
                            continue;
                        }
                        if (idxTs.compareTo(retval) <= 0) continue;
                        retval = idxTs;
                    }
                }
            }
        } else {
            DBObjectLister lister = this.getLister(type);
            if (lister != null && lister.supportsTimestamps(type)) {
                retval = lister.getExternalTimestamp(obj);
            }
        }
        return retval;
    }

    protected final Long getExternalTimestampByID(DBObjectID id) throws DBException {
        Long result = null;
        String objectType = id == null ? null : id.getType();
        String dbName = id instanceof BaseObjectID ? ((BaseObjectID)id).getDatabaseName() : null;
        String query = this.getDictionaryQueries().getTimestampQueryByID(objectType);
        if (id instanceof IdentifierBasedID && query != null) {
            final Holder holder = new Holder();
            final QueryWrapper qw = this.newQueryWrapper(null, query, ((IdentifierBasedID)id).getIdentifier());
            qw.setDatabaseName(dbName);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        Timestamp t;
                        if (rs.next() && (t = rs.getTimestamp(1)) != null) {
                            holder.set((Object)new Long(t.getTime()));
                        }
                    }
                    catch (SQLException ex) {
                        qw.throwDBException(ex);
                    }
                }
            };
            qw.executeQuery(r);
            result = (Long)holder.get();
        } else if (id instanceof BaseObjectID) {
            BaseObjectID baseID = (BaseObjectID)id;
            Schema s = this.findSchema(baseID.getSchemaName());
            result = this.getExternalTimestampByName(baseID.getType(), s, baseID.getName());
        }
        return result;
    }

    protected final Long getExternalTimestampByName(String type, Schema schema, String objectName) {
        Long result = null;
        String query = this.getDictionaryQueries().getTimestampQueryByName(type);
        if (query != null) {
            final Holder holder = new Holder();
            final QueryWrapper qw = this.newQueryWrapper(null, query, schema, objectName, type);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        Timestamp t;
                        if (rs.next() && (t = rs.getTimestamp(1)) != null) {
                            holder.set((Object)new Long(t.getTime()));
                        }
                    }
                    catch (SQLException ex) {
                        qw.throwDBException(ex);
                    }
                }
            };
            try {
                qw.executeQuery(r);
            }
            catch (DBException dbe) {
                // empty catch block
            }
            result = (Long)holder.get();
        }
        return result;
    }

    @Override
    public final boolean exists(String type, String schema, String name) {
        DictionaryQueries dictionary = this.getDictionaryQueries();
        String query = dictionary.getExistsQuery(type);
        if (query == null) {
            return super.exists(type, schema, name);
        }
        final Holder exists = new Holder((Object)false);
        List<String> params = this.getParameters(dictionary.getExistsQueryParams(type), schema, name, type);
        final QueryWrapper wrap = this.newQueryWrapper(null, query, params);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    exists.set((Object)rs.next());
                }
                catch (SQLException sqe) {
                    wrap.throwDBException(sqe);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, APIBundle.format("EXISTS_CHECK_ERR", type, name, dbe.getMessage()));
        }
        return (Boolean)exists.get();
    }

    @Override
    public final boolean isObjectValid(String objectType, String schema, String objectName) {
        boolean retval;
        DictionaryQueries dictionary = this.getDictionaryQueries();
        String query = dictionary.getObjectStatusQuery(objectType);
        if (query == null) {
            retval = super.isObjectValid(objectType, schema, objectName);
        } else {
            List<String> params = this.getParameters(dictionary.getObjectStatusQueryParams(objectType), schema, objectName, objectType);
            final QueryWrapper wrap = this.newQueryWrapper(null, query, params);
            final Holder valid = new Holder((Object)false);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            String state = rs.getString(1);
                            valid.set((Object)"VALID".equalsIgnoreCase(state));
                        }
                    }
                    catch (SQLException sqe) {
                        wrap.throwDBException(sqe);
                    }
                }
            };
            try {
                wrap.executeQuery(r);
            }
            catch (DBException dbe) {
                this.getLogger().log(Level.WARNING, APIBundle.format("VALID_CHECK_ERR", dbe.getMessage()));
            }
            retval = (Boolean)valid.get();
        }
        return retval;
    }

    @Override
    protected SystemObject loadObjectImpl(BaseObjectID id) throws DBException {
        DBObjectLister.ObjectInfo info = null;
        final String type = id.getType();
        DBObjectBuilder builder = this.getBuilderForType(type);
        if (builder != null) {
            DBObjectCriteria<SystemObject> crit;
            Collection<DBObjectLister.ObjectInfo> queried;
            if (id instanceof IdentifierBasedID) {
                DictionaryQueries dictionary;
                String query;
                if (builder != null && (query = (dictionary = this.getDictionaryQueries()).getObjectQueryByID(type)) != null) {
                    final Holder holder = new Holder();
                    List<String> params = this.getParameters(dictionary.getObjectQueryByIDParams(type), (IdentifierBasedID)id);
                    final QueryWrapper wrap = this.newQueryWrapper(null, query, params);
                    wrap.setDatabaseName(id.getDatabaseName());
                    QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                        public void processResultSet(ResultSet rs) throws DBException {
                            try {
                                if (rs.next()) {
                                    Timestamp t;
                                    Schema owner = DictionaryDatabase.this.findSchema(rs.getString(1));
                                    String name = rs.getString(2);
                                    Long ts = null;
                                    if (rs.getMetaData().getColumnCount() > 2 && (t = rs.getTimestamp(3)) != null) {
                                        ts = t.getTime();
                                    }
                                    holder.set((Object)new DBObjectLister.ObjectInfo(type, owner, name, null, ts));
                                }
                            }
                            catch (SQLException ex) {
                                wrap.throwDBException(null, ex);
                            }
                        }
                    };
                    wrap.executeQuery(r);
                    info = (DBObjectLister.ObjectInfo)holder.get();
                }
            } else if (id instanceof NameBasedID && (queried = this.listObjectInfos(crit = DBObjectCriteria.createSingleObjectCriteria(type, id.getDatabaseName(), id.getSchemaName(), id.getName()))) != null && queried.size() == 1) {
                info = queried.iterator().next();
            }
        }
        SystemObject retval = null;
        if (info != null) {
            Long ts;
            retval = (SystemObject)builder.createObject(info.getName(), info.getSchema(), id);
            retval.setID(id);
            if (retval instanceof AbstractBuildableObject) {
                this.markForLazyInit((AbstractBuildableObject)((Object)retval));
            }
            if ((ts = info.getTimestamp()) != null) {
                retval.setProperty("Timestamp", ts);
                this.putCachedTimestampKey(id, ts);
            }
            this.cacheObject(retval, true);
        }
        return retval;
    }

    @Override
    protected final String getAliveTestStatement() {
        DictionaryQueries queries = this.getDictionaryQueries();
        return queries == null ? null : queries.getAliveTestStatement();
    }

    @Override
    protected String queryCurrentUserName() throws DBException {
        String retval;
        DictionaryQueries queries = this.getDictionaryQueries();
        String userQuery = queries.getUserNameQuery();
        if (userQuery == null) {
            retval = super.queryCurrentUserName();
        } else {
            QueryWrapper wrap = this.newQueryWrapper(null, userQuery, new Object[0]);
            retval = wrap.executeSingleCellQuery();
        }
        return retval;
    }

    private Schema getCriteriaSchema(DBObjectCriteria criteria) throws DBException {
        Schema schema;
        if (criteria.getDatabaseName() == null) {
            schema = this.findSchema(criteria.getSchemaName());
        } else {
            String schemaName;
            if (criteria.getSchemaName() != null) {
                schemaName = criteria.getSchemaName();
            } else {
                DatabaseLink link = (DatabaseLink)this.getObject("DATABASE LINK", this.findSchema(this.getCurrentSchemaName()), criteria.getDatabaseName());
                if (link == null) {
                    link = (DatabaseLink)this.getObject("DATABASE LINK", this.findSchema("PUBLIC"), criteria.getDatabaseName());
                }
                schemaName = link != null ? (Boolean.FALSE.equals(link.getConnectToUser()) ? link.getUsername() : this.getUserName()) : null;
            }
            schema = schemaName == null ? null : new Schema(schemaName);
        }
        return schema;
    }
}

