/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildableDBObjectDiffer
extends DBObjectDiffer {
    private final PropertyHelper m_helper = new PropertyHelper();

    BuildableDBObjectDiffer() {
        this(null);
    }

    BuildableDBObjectDiffer(DiffEngine internalRefDelegate) {
        super(internalRefDelegate);
    }

    @Override
    protected ResultSet diffProperty(Object a, Object b, ResultSet r, DiffContext c, PropertyInfo prop, Map<String, PropertyInfo> beanProps) {
        ResultSet retval;
        String propertyName = prop.getPropertyName();
        AbstractBuildableObject aObj = (AbstractBuildableObject)a;
        AbstractBuildableObject bObj = (AbstractBuildableObject)b;
        DBObjectID aID = aObj == null ? null : aObj.getID();
        DBObjectID bID = bObj == null ? null : bObj.getID();
        boolean lazy = false;
        if (a == null || b == null || this.isTempCopy(aID, bID) || this.isTempCopy(bID, aID)) {
            boolean bl = lazy = DBUtil.needsBuilding((AbstractBuildableObject)a, propertyName) || DBUtil.needsBuilding((AbstractBuildableObject)b, propertyName);
        }
        if (lazy) {
            String sourceProp;
            retval = new LazyResultSet(r, prop);
            if (prop.isDerived() && (sourceProp = prop.getDerivedSourceProperty()) != null) {
                try {
                    Difference sourceDiff = this.m_helper.getChildDifference(r, sourceProp);
                    if (sourceDiff != null && !sourceDiff.isSame()) {
                        retval.setSame(false);
                    }
                }
                catch (MissingPropertyException mpe) {
                    DBLog.getLogger(this).warning(mpe.getMessage());
                }
            }
        } else {
            retval = super.diffProperty(a, b, r, c, prop, beanProps);
        }
        return retval;
    }

    protected boolean isTempCopy(DBObjectID id1, DBObjectID id2) {
        boolean retval = false;
        if (id1 instanceof TemporaryObjectID) {
            try {
                DBObjectID origID;
                DBObject orig = ((TemporaryObjectID)id1).resolveOriginalID();
                if (orig != null && (origID = orig.getID()) != null) {
                    retval = origID.equals(id2, true) || this.isTempCopy(origID, id2);
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return retval;
    }

    private static String getResultSetType(PropertyInfo prop) {
        Class propClz = prop.getPropertyClass();
        if (propClz != null && propClz.isArray()) {
            return "LIST";
        }
        return "MAP";
    }

    static boolean isLazyDifference(Difference diff) {
        return diff instanceof LazyResultSet;
    }

    private class LazyResultSet
    extends ResultSet {
        private PropertyInfo m_prop;
        private Object m_parentA;
        private Object m_parentB;
        private boolean m_aLoaded;
        private boolean m_bLoaded;

        private LazyResultSet() {
        }

        LazyResultSet(ResultSet parent, PropertyInfo prop) {
            this(parent, parent.a(), parent.b(), prop);
        }

        LazyResultSet(ResultSet parent, Object parentA, Object parentB, PropertyInfo prop) {
            super(parent, null, null, prop.getPropertyName(), BuildableDBObjectDiffer.getResultSetType(prop));
            this.m_prop = prop;
            this.m_parentA = parentA;
            this.m_parentB = parentB;
            this.setSame(true);
        }

        public Object a() {
            this.m_aLoaded = true;
            return this.m_parentA == null ? null : BuildableDBObjectDiffer.this.m_helper.getPropertyValue(this.m_parentA, this.m_prop.getPropertyName());
        }

        public Object b() {
            this.m_bLoaded = true;
            return this.m_parentB == null ? null : BuildableDBObjectDiffer.this.m_helper.getPropertyValue(this.m_parentB, this.m_prop.getPropertyName());
        }

        protected String getOriginalObjectForLog() {
            return this.m_aLoaded ? super.getOriginalObjectForLog() : "<LAZY>";
        }

        protected String getUpdatedObjectForLog() {
            return this.m_bLoaded ? super.getUpdatedObjectForLog() : "<LAZY>";
        }

        public Class getResultSetClass() {
            Object b;
            Object a;
            Class retval = null;
            if (this.m_aLoaded && (a = this.a()) != null) {
                retval = a.getClass();
            }
            if (retval == null && this.m_bLoaded && (b = this.b()) != null) {
                retval = b.getClass();
            }
            if (retval == null && (retval = this.m_prop.getPropertyClass()) == null) {
                retval = super.getResultSetClass();
            }
            return retval;
        }

        public LazyResultSet copyTo(Object target) {
            LazyResultSet copy = target == null ? new LazyResultSet() : (LazyResultSet)target;
            super.copyToImpl(copy);
            copy.m_aLoaded = this.m_aLoaded;
            copy.m_bLoaded = this.m_bLoaded;
            copy.m_parentA = this.m_parentA;
            copy.m_parentB = this.m_parentB;
            copy.m_prop = this.m_prop;
            return copy;
        }
    }
}

