/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Comparator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectComparator
implements Comparator<DBObject> {
    private final Comparator<DBObject> m_delegate;
    private final DiffEngine m_engine;

    public DBObjectComparator() {
        this(null);
    }

    DBObjectComparator(DiffEngine engine) {
        this.m_engine = engine;
        this.m_delegate = DBUtil.getNameComparator();
    }

    @Override
    public int compare(DBObject obj1, DBObject obj2) {
        int retval;
        if (obj1 == obj2) {
            retval = 0;
        } else if (obj1 == null || obj2 == null) {
            retval = obj2 == null ? -10 : 10;
        } else {
            DBObjectID id1 = obj1.getID();
            DBObjectID id2 = obj2.getID();
            if (this.getOriginalIfTempID(id1) == obj2 || this.getOriginalIfTempID(id2) == obj1) {
                retval = 0;
            } else if (this.shouldTestByName(obj1, id1) || this.shouldTestByName(obj2, id2)) {
                retval = this.m_delegate.compare(obj1, obj2);
            } else {
                Comparator idComparator = null;
                if (this.m_engine != null) {
                    idComparator = this.m_engine.getComparator(DBObjectID.class);
                }
                if (idComparator == null) {
                    idComparator = new DBObjectIDComparator(false);
                }
                retval = idComparator.compare(id1, id2);
            }
        }
        return retval;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DBObjectComparator && ModelUtil.areEqual((Object)((DBObjectComparator)obj).m_engine, (Object)this.m_engine);
    }

    private boolean shouldTestByName(DBObject obj, DBObjectID id) {
        boolean retval = id == null ? true : id instanceof TemporaryObjectID && TemporaryObjectID.findOriginalObject((TemporaryObjectID)id) == null && this.isDerived(obj);
        return retval;
    }

    private boolean isDerived(DBObject child) {
        boolean retval = false;
        while (child != null) {
            DBObject parent = child.getParent();
            if (parent != null) {
                String path = DBUtil.getPropertyPath(parent, child);
                PropertyInfo info = PropertyHelper.findPropertyInfo(parent.getClass(), path, (Class<? extends DBObjectProvider>)null);
                if (info == null) break;
                if (info.isDerived()) {
                    retval = true;
                    break;
                }
            }
            child = parent;
        }
        return retval;
    }

    private DBObject getOriginalIfTempID(DBObjectID id) {
        DBObject obj = null;
        if (id instanceof TemporaryObjectID) {
            try {
                obj = ((TemporaryObjectID)id).resolveOriginalID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return obj;
    }
}

