/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.BuildableDBObjectDiffer;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceApplier {
    private List<DBObjectChange> m_events;
    private boolean m_applyToB;
    private DBObjectProvider m_pro;

    public DifferenceApplier(DBObjectProvider pro) {
        this(pro, false);
    }

    public DifferenceApplier(DBObjectProvider pro, boolean applyToB) {
        this.m_pro = pro;
        this.m_applyToB = applyToB;
    }

    private Object getOriginalObject(Difference rs) {
        return this.m_applyToB ? rs.getUpdatedObject() : rs.getOriginalObject();
    }

    private Object getUpdatedObject(Difference rs) {
        return this.m_applyToB ? rs.getOriginalObject() : rs.getUpdatedObject();
    }

    private Integer getIndexOfUpdatedObject(Difference rs) {
        return this.m_applyToB ? rs.getIndexOfOriginalObject() : rs.getIndexOfUpdatedObject();
    }

    public final void apply(SystemObject original, SystemObject updated) {
        this.apply(this.m_pro.getDiffEngine().difference(original, updated));
    }

    public final void apply(Difference rs) {
        this.m_events = new ArrayList<DBObjectChange>();
        if (!rs.isSame()) {
            if (rs.isList()) {
                Collection<? extends Difference> change = rs.getChildren();
                for (Difference difference : change) {
                    if (!difference.isModified() || !difference.isMap() || difference.isSame()) continue;
                    this.applyImpl(difference);
                }
            } else if (rs.isMap()) {
                this.applyImpl(rs);
            }
        }
    }

    private void applyImpl(final Difference objDiff) {
        Object obj = this.getOriginalObject(objDiff);
        if (obj instanceof DBObject) {
            Runnable r = new Runnable(){

                public void run() {
                    DifferenceApplier.this.applyProperties(objDiff, null);
                }
            };
            DBUtil.invokeCompoundChange((DBObject)obj, r, true);
        } else {
            this.applyProperties(objDiff, null);
        }
    }

    private final void applyProperties(Difference rs, Difference parent) {
        Object original = this.getOriginalObject(rs);
        if (original != null) {
            TreeMap<PropertyInfo, Difference> process = new TreeMap<PropertyInfo, Difference>();
            Map<String, PropertyInfo> infos = PropertyIterator.getPropertyInfos(original);
            Collection<? extends Difference> changed = rs.getChildren();
            for (Difference difference : changed) {
                String propertyName = difference.getPropertyName();
                if (difference.isSame() || BuildableDBObjectDiffer.isLazyDifference(difference)) continue;
                Class objClass = rs.getDifferenceClass();
                if (Map.class.isAssignableFrom(objClass)) {
                    Holder newPropValue = this.getAppliedPropertyValue(difference, rs, parent);
                    if (newPropValue == null) continue;
                    ((Map)original).put(propertyName, newPropValue.get());
                    continue;
                }
                PropertyInfo info = infos.get(propertyName);
                if (info == null) {
                    throw new IllegalStateException("don't have a property info for property " + propertyName + " on object " + objClass);
                }
                process.put(info, difference);
            }
            for (PropertyInfo propertyInfo : process.keySet()) {
                Difference change = (Difference)process.get(propertyInfo);
                Object[] value = null;
                boolean setProp = false;
                if (change.isList()) {
                    List list = this.applyList(change, rs);
                    setProp = true;
                    if (list != null && list.size() > 0) {
                        value = Array.newInstance(change.getDifferenceClass().getComponentType(), list.size());
                        value = list.toArray((Object[])value);
                    } else {
                        value = null;
                    }
                } else if ("schema".equals(propertyInfo.getPropertyName()) && SchemaObject.class.isAssignableFrom(rs.getDifferenceClass())) {
                    value = this.getUpdatedObject(change);
                    setProp = true;
                } else {
                    Holder newPropValue = this.getAppliedPropertyValue(change, rs, parent);
                    if (newPropValue != null) {
                        value = newPropValue.get();
                        setProp = true;
                    }
                }
                if (!setProp) continue;
                try {
                    propertyInfo.setPropertyValue(original, value);
                }
                catch (Exception e) {
                    DBLog.getLogger(this).log(Level.SEVERE, "Error applying property value", e);
                }
            }
            if (parent == null) {
                this.m_events.add(new ResultSetChange(rs, this.m_pro));
            }
        }
    }

    private Holder getAppliedPropertyValue(Difference change, Difference rs, Difference parent) {
        boolean setProp = true;
        Object newPropValue = this.getUpdatedObject(change);
        if (change.isSame()) {
            setProp = false;
        } else if (!change.isList() && newPropValue != null) {
            Object originalPropValue = this.getOriginalObject(change);
            if (originalPropValue == null || originalPropValue.getClass() != newPropValue.getClass()) {
                Object parentObj;
                Object object = parentObj = parent == null ? null : this.getOriginalObject(parent);
                if (newPropValue instanceof ChildDBObject && this.m_pro != null && parentObj instanceof DBObject) {
                    ChildDBObject newChildObject = (ChildDBObject)newPropValue;
                    newPropValue = this.m_pro.getObjectFactory().newObject(newChildObject.getClass(), (DBObject)parentObj, false);
                    ((ChildDBObject)newPropValue).setID(null);
                    newChildObject.copyTo((DBObject)((ChildDBObject)newPropValue), new TemporaryObjectID.CopyBackPolicy());
                } else if (newPropValue instanceof Copyable) {
                    newPropValue = ((Copyable)newPropValue).copyTo(null);
                }
            } else if (change.isMap() && (newPropValue instanceof DBObject || "properties".equals(change.getPropertyName()) && this.getUpdatedObject(rs) instanceof DBObject)) {
                setProp = false;
                this.applyProperties(change, rs);
            }
        }
        return setProp ? new Holder(newPropValue) : null;
    }

    private boolean hasChangedChildren(Difference change) {
        Collection<? extends Difference> children = change.getChildren();
        for (Difference difference : children) {
            if (difference.isSame()) continue;
            return true;
        }
        return false;
    }

    private final List applyList(Difference rs, Difference parent) {
        ArrayList<Object> value = null;
        ArrayList<? extends Difference> changes = new ArrayList<Difference>(rs.getChildren());
        if (changes != null) {
            Collections.sort(changes, new Comparator<Difference>(){

                @Override
                public int compare(Difference o1, Difference o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -100;
                    }
                    if (o2 == null) {
                        return 100;
                    }
                    return DifferenceApplier.this.getIndexOfUpdatedObject(o1).compareTo(DifferenceApplier.this.getIndexOfUpdatedObject(o2));
                }
            });
            value = new ArrayList<Object>(changes.size());
            for (Difference difference : changes) {
                Holder newChild = this.getAppliedPropertyValue(difference, rs, parent);
                if (newChild == null) {
                    value.add(this.getOriginalObject(difference));
                    continue;
                }
                Object newChildValue = newChild.get();
                if (newChildValue == null) continue;
                value.add(newChildValue);
            }
        }
        return value;
    }

    public SystemObject getCopyOfOrigWithDiffApplied(Difference diff) {
        SystemObject retval = null;
        SystemObject orig = (SystemObject)diff.getOriginalObject();
        SystemObject upd = (SystemObject)diff.getUpdatedObject();
        if (orig != null) {
            Map<DBObjectID, DBObjectID> origToUpdIDMap = DBUtil.getTemporaryIDMap(upd);
            SameTempIDPolicy policy = new SameTempIDPolicy(origToUpdIDMap);
            SystemObject origCopy = (SystemObject)orig.copyTo(null, policy);
            Difference diffToApply = (Difference)diff.copyTo(null);
            this.switchOriginalWithCopy(diffToApply, policy.m_ourTemps);
            this.apply(diffToApply);
            retval = (SystemObject)diffToApply.getOriginalObject();
            DBUtil.replaceAllIDs(retval, policy.m_ourTemps);
        }
        if (retval == null) {
            retval = upd;
        }
        return retval;
    }

    private void switchOriginalWithCopy(Difference diff, Map<DBObjectID, TemporaryObjectID> idMap) {
        TemporaryObjectID temporaryObjectID;
        DBObjectID origID;
        Object orig = diff.getOriginalObject();
        if (orig instanceof DBObject && (origID = ((DBObject)orig).getID()) != null && (temporaryObjectID = idMap.get(origID)) != null) {
            try {
                DBObject tempCopy = temporaryObjectID.resolveID();
                if (tempCopy != null) {
                    diff.setObject(diff.getOriginalContributor(), tempCopy);
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        for (Difference difference : diff.getChildren()) {
            this.switchOriginalWithCopy(difference, idMap);
        }
    }

    @Deprecated
    public DBObjectChange[] fireEvents() {
        return this.m_events == null ? new DBObjectChange[]{} : this.m_events.toArray(new DBObjectChange[this.m_events.size()]);
    }

    public Iterable<DBObjectChange> getEvents() {
        return this.m_events;
    }

    private DBObjectChange fireLazyChangeEventImpl(SystemObject obj, SystemObject copyOfOriginal) {
        ResultSetChange change = new ResultSetChange(obj, copyOfOriginal, this.m_pro);
        obj.fireObjectUpdated(change);
        return change;
    }

    public static DBObjectChange fireLazyChangeEvent(SystemObject obj, SystemObject copyOfOriginal, DBObjectProvider pro) {
        DifferenceApplier app = new DifferenceApplier(pro);
        return app.fireLazyChangeEventImpl(obj, copyOfOriginal);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SameTempIDPolicy
    extends IDPolicy {
        private final Map<DBObjectID, TemporaryObjectID> m_ourTemps = new DBObjectIDMap<TemporaryObjectID>(true);
        private final Map<DBObjectID, DBObjectID> m_origToUpdIDMap;

        public SameTempIDPolicy(Map<DBObjectID, DBObjectID> origToUpdIDMap) {
            this.m_origToUpdIDMap = origToUpdIDMap;
        }

        @Override
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            TemporaryObjectID tempID = (TemporaryObjectID)TemporaryObjectID.createID(copy, original);
            DBObjectID origID = original.getID();
            if (origID != null) {
                this.m_ourTemps.put(origID, tempID);
                DBObjectID fromUpd = this.m_origToUpdIDMap.get(origID);
                if (fromUpd != null) {
                    this.m_ourTemps.put(fromUpd, tempID);
                }
            }
            return origID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResultSetChange
    extends DBObjectChange {
        private Difference m_rs;
        private DBObject m_lazyDiffObj;
        private Collection<String> m_allChangedProps;
        private List<DBObject> m_objectsAdded;
        private List<DBObject> m_objectsRemoved;
        private Map<DBObject, DBObjectChange> m_objectsChanged;
        private Map<String, PropertyChangeEvent> m_propsChanged;

        private ResultSetChange(Difference rs, DBObjectProvider pro) {
            super((DBObject)DifferenceApplier.this.getOriginalObject(rs), pro);
            this.m_rs = rs;
        }

        private ResultSetChange(DBObject toRebuild, DBObject copyOfOriginal, DBObjectProvider pro) {
            super(toRebuild, pro);
            this.m_lazyDiffObj = copyOfOriginal;
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            if (this.m_objectsAdded == null) {
                this.loadResultSet();
            }
            return Collections.unmodifiableList(this.m_objectsAdded);
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
            if (this.m_objectsChanged == null) {
                this.loadResultSet();
            }
            return Collections.unmodifiableMap(this.m_objectsChanged);
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            if (this.m_objectsRemoved == null) {
                this.loadResultSet();
            }
            return Collections.unmodifiableList(this.m_objectsRemoved);
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            if (this.m_propsChanged == null) {
                this.loadResultSet();
            }
            return Collections.unmodifiableMap(this.m_propsChanged);
        }

        @Override
        public Collection<String> getAllChangedProperties() {
            if (this.m_allChangedProps == null) {
                this.m_allChangedProps = new ArrayList<String>();
                for (Difference difference : this.getDifference().getChildren()) {
                    if (difference.isSame()) continue;
                    this.m_allChangedProps.add(difference.getPropertyName());
                }
            }
            return this.m_allChangedProps;
        }

        private Difference getDifference() {
            if (this.m_rs == null) {
                this.m_rs = GenericDiffEngine.getDiffEngine(true).difference(this.m_lazyDiffObj, this.getDBObject());
            }
            return this.m_rs;
        }

        private void loadResultSet() {
            this.m_objectsChanged = new IdentityHashMap<DBObject, DBObjectChange>();
            this.m_propsChanged = new HashMap<String, PropertyChangeEvent>();
            this.m_objectsAdded = new ArrayList<DBObject>();
            this.m_objectsRemoved = new ArrayList<DBObject>();
            for (Difference difference : this.getDifference().getChildren()) {
                this.loadResultSetImpl(difference);
            }
        }

        private void loadResultSetImpl(Difference rs) {
            if (!rs.isSame()) {
                boolean propChange = true;
                if (rs.isList()) {
                    Class propClass = rs.getDifferenceClass();
                    if (propClass.isArray() && DBObject.class.isAssignableFrom(propClass.getComponentType())) {
                        for (Difference difference : rs.getChildren()) {
                            if (!difference.isSame()) {
                                DBObject updated = (DBObject)DifferenceApplier.this.getUpdatedObject(difference);
                                DBObject original = (DBObject)DifferenceApplier.this.getOriginalObject(difference);
                                if (updated == null && original != null) {
                                    this.m_objectsRemoved.add(original);
                                } else if (updated != null && original == null) {
                                    String prop;
                                    DBObject added = updated;
                                    DBObject originalParent = this.getDBObject();
                                    if (updated.getParent() != originalParent && (prop = DBUtil.getParentProperty(updated)) != null) {
                                        Object val = originalParent.getProperty(prop);
                                        if (val instanceof DBObject) {
                                            added = (DBObject)val;
                                        } else if (val instanceof Object[]) {
                                            for (Object kid : (Object[])val) {
                                                if (!(kid instanceof DBObject) || !DBUtil.areNamesAndTypesEqual(updated, (DBObject)kid)) continue;
                                                added = (DBObject)kid;
                                                break;
                                            }
                                        }
                                    }
                                    this.m_objectsAdded.add(added);
                                } else {
                                    this.m_objectsChanged.put(original, new ResultSetChange(difference, this.getProvider()));
                                }
                            }
                            int indexA = difference.getIndexOfOriginalObject();
                            int indexB = difference.getIndexOfUpdatedObject();
                            if (indexA < 0 || indexB < 0 || indexA == indexB) continue;
                            this.m_objectsChanged.put((DBObject)DifferenceApplier.this.getOriginalObject(difference), new ResultSetChange(difference, this.getProvider()));
                        }
                    }
                } else if (rs.isMap()) {
                    if ("properties".equals(rs.getPropertyName())) {
                        propChange = false;
                        for (Difference difference : rs.getChildren()) {
                            this.loadResultSetImpl(difference);
                        }
                    } else {
                        DBObjectComparator dBObjectComparator;
                        Object updated = DifferenceApplier.this.getUpdatedObject(rs);
                        Object object = DifferenceApplier.this.getOriginalObject(rs);
                        if (updated instanceof DBObject && object instanceof DBObject && (dBObjectComparator = new DBObjectComparator()).compare(updated, object) == 0) {
                            this.m_objectsChanged.put((DBObject)object, new ResultSetChange(rs, this.getProvider()));
                        }
                    }
                }
                if (propChange) {
                    String propName = rs.getPropertyName();
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.getDBObject(), propName, DifferenceApplier.this.getOriginalObject(rs), DifferenceApplier.this.getUpdatedObject(rs));
                    this.m_propsChanged.put(propName, propertyChangeEvent);
                }
            }
        }

        @Override
        public boolean hasNameChanged() {
            if (this.m_rs == null) {
                DBObject obj = this.getDBObject();
                return !DBUtil.areNamesAndTypesEqual(this.m_lazyDiffObj, obj);
            }
            return super.hasNameChanged();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public PropertyChangeEvent getPropertyChange(String propertyName) {
            Difference difference;
            if (!("ID".equals(propertyName) || "schema".equals(propertyName) || "name".equals(propertyName) || "type".equals(propertyName))) {
                if (!"source".equals(propertyName)) return super.getPropertyChange(propertyName);
                if (this.m_lazyDiffObj == null) return super.getPropertyChange(propertyName);
            }
            if (this.m_lazyDiffObj != null) {
                Object object;
                Object oldVal = this.m_lazyDiffObj.getProperty(propertyName);
                if (!ModelUtil.areEqual((Object)oldVal, (Object)(object = this.getDBObject().getProperty(propertyName)))) return new PropertyChangeEvent(this.getDBObject(), propertyName, oldVal, object);
                return null;
            }
            if (this.m_rs == null) throw new IllegalStateException("Must have a ResultSet, or lazy DBObject");
            PropertyChangeEvent retval = null;
            Iterator<? extends Difference> i$ = this.m_rs.getChildren().iterator();
            do {
                if (!i$.hasNext()) return retval;
            } while ((difference = i$.next()) == null || !propertyName.equals(difference.getPropertyName()));
            if (difference.isSame()) return retval;
            return new PropertyChangeEvent(this.getDBObject(), propertyName, difference.getOriginalObject(), difference.getUpdatedObject());
        }
    }
}

