/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.diff.BuildableDBObjectDiffer;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.db.diff.DBObjectIDDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericArrayDiffer;
import oracle.javatools.db.diff.GenericBeanDiffer;
import oracle.javatools.db.diff.GenericComparator;
import oracle.javatools.db.diff.GenericMapDiffer;
import oracle.javatools.db.diff.GenericNameDiffer;
import oracle.javatools.db.diff.GenericToStringDiffer;
import oracle.javatools.db.diff.ListDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.diff.SQLFragmentComparator;
import oracle.javatools.db.diff.SQLFragmentDiffer;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;

public class GenericDiffEngine {
    public static DiffEngine getDiffEngine(boolean strictIDComparison) {
        return GenericDiffEngine.getDiffEngine(strictIDComparison, true);
    }

    public static DiffEngine getDiffEngine(boolean strictIDComparison, boolean sqlTextCompare) {
        return GenericDiffEngine.getDiffEngine(strictIDComparison, strictIDComparison, sqlTextCompare);
    }

    public static DiffEngine getDiffEngine(boolean strictIDComparison, boolean strictInternalRefComparison, boolean sqlTextCompare) {
        DiffEngine engine = new DiffEngine(true);
        engine.registerListDiffer(new ListDiffer(true), Object.class);
        engine.registerListDiffer(new ListDiffer(false), Constraint.class);
        engine.registerListDiffer(new ListDiffer(false), Index.class);
        engine.registerComparator(new GenericComparator(), Object.class);
        engine.registerComparator(new DBObjectComparator(engine), DBObject.class);
        engine.registerComparator(new DBObjectIDComparator(strictIDComparison), DBObjectID.class);
        engine.registerDiffer(new GenericToStringDiffer(), Object.class);
        engine.registerDiffer(new GenericBeanDiffer(), Object.class);
        engine.registerDiffer(new GenericArrayDiffer(), Object.class);
        engine.registerDiffer(new GenericMapDiffer(), Map.class);
        engine.registerDiffer(new GenericNameDiffer(), Schema.class);
        engine.registerDiffer(new DBObjectIDDiffer(strictIDComparison), DBObjectID.class);
        DiffEngine internalRefDelegate = strictIDComparison == strictInternalRefComparison ? null : GenericDiffEngine.getDiffEngine(strictInternalRefComparison, strictInternalRefComparison, sqlTextCompare);
        engine.registerDiffer(new DBObjectDiffer(internalRefDelegate), AbstractDBObject.class);
        engine.registerDiffer(new BuildableDBObjectDiffer(internalRefDelegate), AbstractBuildableObject.class);
        if (sqlTextCompare) {
            engine.registerComparator(new SQLFragmentComparator(), AbstractSQLFragment.class);
            engine.registerDiffer(new SQLFragmentDiffer(), SQLFragment.class);
            if (strictIDComparison && !strictInternalRefComparison) {
                IndexObjectDiffer hack = new IndexObjectDiffer(engine, GenericDiffEngine.getDiffEngine(false, false, false));
                engine.registerDiffer(hack, IndexObject.class);
                engine.registerComparator(hack, IndexObject.class);
            }
        }
        return engine;
    }

    private static class ProperListDiffer
    extends ListDiffer {
        ProperListDiffer() {
            super(true);
        }

        public boolean diff(Object a, Object b, ResultSet rlist, DiffContext dc) {
            boolean retval;
            if (a instanceof List && b instanceof List && ((List)a).size() == 1 && ((List)b).size() == 1) {
                Object ao = ((List)a).get(0);
                Object bo = ((List)b).get(0);
                ResultSet rm = new ResultSet(rlist, ao, bo, 0, 0, null, "MAP");
                dc.getEngine().diff(ao, bo, rm, dc);
                rlist.setSame(rm.isSame());
                retval = true;
            } else {
                retval = super.diff(a, b, rlist, dc);
            }
            return retval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexObjectDiffer
    extends BuildableDBObjectDiffer
    implements Comparator<IndexObject> {
        private final DiffEngine m_owningEngine;
        private final DiffEngine m_delegateEngine;

        IndexObjectDiffer(DiffEngine owningEngine, DiffEngine delegateEngine) {
            this.m_owningEngine = owningEngine;
            this.m_delegateEngine = delegateEngine;
            this.m_delegateEngine.registerListDiffer(new ProperListDiffer(), Object.class);
        }

        @Override
        public int compare(IndexObject o1, IndexObject o2) {
            Difference diff = this.m_owningEngine.difference(o1, o2);
            int retval = diff.isSame() ? 0 : this.m_owningEngine.getComparator(AbstractSQLFragment.class).compare(o1, o2);
            return retval;
        }

        @Override
        protected ResultSet diffProperty(Object a, Object b, ResultSet objectRS, DiffContext c, PropertyInfo prop, Map<String, PropertyInfo> beanProps) {
            ResultSet retval = null;
            String propName = prop.getPropertyName();
            if ("expression".equals(propName)) {
                Difference colExpRS = null;
                for (Difference difference : objectRS.getChildren()) {
                    if (!"expressionSource".equals(difference.getPropertyName())) continue;
                    colExpRS = difference;
                    break;
                }
                if (colExpRS != null && !colExpRS.isSame()) {
                    SQLFragment aExp = ((IndexObject)a).getExpression();
                    SQLFragment sQLFragment = ((IndexObject)b).getExpression();
                    if (aExp != null && sQLFragment != null) {
                        retval = new ResultSet(objectRS, aExp, (Object)sQLFragment, propName, "MAP");
                        DiffContext delegateC = new DiffContext(this.m_delegateEngine, retval);
                        this.m_delegateEngine.diff(aExp, sQLFragment, retval, delegateC);
                        if (retval.isSame()) {
                            colExpRS.setSame(true);
                        }
                    }
                }
            }
            if (retval == null) {
                retval = super.diffProperty(a, b, objectRS, c, prop, beanProps);
            }
            return retval;
        }

        @Override
        protected boolean ignoreProperty(PropertyInfo prop) {
            return super.ignoreProperty(prop) && !"expression".equals(prop.getPropertyName());
        }

        @Override
        public boolean diff(Object a, Object b, ResultSet r, DiffContext c) {
            boolean retval = super.diff(a, b, r, c);
            if (retval && !r.isSame() && r.isMap()) {
                boolean same = true;
                for (Difference difference : r.getChildren()) {
                    if (difference.isSame()) continue;
                    same = false;
                    break;
                }
                if (same) {
                    r.setSame(true);
                }
            }
            return retval;
        }
    }
}

