/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSet
extends Difference {
    public static final String LIST = "LIST";
    public static final String MAP = "MAP";
    public static final String LEAF = "LEAF";
    public static String ORIGINAL = "ORIGINAL";
    public static String UPDATED = "UPDATED";
    private String m_updateContributor;
    private Object m_a;
    private Object m_b;
    private String m_propertyName;
    private int m_indexOfA = -1;
    private int m_indexOfB = -1;
    private boolean m_listReordered;
    private List<ResultSet> m_list;
    private Map<String, ResultSet> m_map;

    protected ResultSet() {
    }

    public ResultSet(ResultSet parent, Object a, Object b, int indexOfA, int indexOfB, String name, String type) {
        this.setUpdateContributor(UPDATED);
        if (indexOfA >= 0 || indexOfB >= 0) assert (parent.getType().equals(LIST));
        this.setParent(parent);
        this.m_a = a;
        this.m_b = b;
        this.m_propertyName = name;
        if (MAP.equals(type) && name != null && name.contains("/")) {
            this.m_propertyName = name.replaceAll("/", "_");
        }
        this.setType(type);
        if (parent != null) {
            if (LIST.equals(parent.getType())) {
                parent.addToList(this);
                this.m_indexOfA = indexOfA;
                this.m_indexOfB = indexOfB;
            }
            if (MAP.equals(parent.getType())) {
                parent.addToMap(name, this);
            }
        }
    }

    public ResultSet(ResultSet parent, Object a, Object b, String name, String type) {
        this(parent, a, b, -1, -1, name, type);
    }

    public ResultSet(ResultSet parent, boolean same, Object a, Object b, String propertyName) {
        this(parent, a, b, propertyName, LEAF);
        this.setSame(same);
    }

    protected void setType(String type) {
        this.m_list = type.equals(LIST) ? new ArrayList() : null;
        this.m_map = type.equals(MAP) ? new HashMap() : null;
    }

    @Override
    public ResultSet getParent() {
        return (ResultSet)super.getParent();
    }

    public String getType() {
        String type = LEAF;
        if (null != this.m_list) {
            type = LIST;
        } else if (null != this.m_map) {
            type = MAP;
        }
        return type;
    }

    public void addToList(ResultSet rs) {
        rs.setParent(this);
        this.m_list.add(rs);
    }

    public void addToMap(String name, ResultSet rs) {
        rs.setParent(this);
        this.m_map.put(name, rs);
    }

    @Override
    public boolean isModified() {
        return !this.isSame() && !this.inBbutNotA() && !this.inAbutNotB();
    }

    public Object a() {
        return this.m_a;
    }

    public void setA(Object a) {
        this.m_a = a;
    }

    public Object b() {
        return this.m_b;
    }

    public void setB(Object b) {
        this.m_b = b;
    }

    public void setName(String name) {
        this.m_propertyName = name;
    }

    @Override
    public String getPropertyName() {
        return this.m_propertyName;
    }

    public String getName() {
        String name = this.m_propertyName;
        if (MAP.equals(this.getType())) {
            if (this.m_b == null && this.m_a instanceof DBObject) {
                name = ((DBObject)this.m_a).getName();
            } else if (this.m_b != null && this.m_b instanceof DBObject) {
                name = ((DBObject)this.m_b).getName();
            }
        }
        return ModelUtil.hasLength((String)name) ? name : this.m_propertyName;
    }

    public boolean isChildListReorder() {
        return this.m_listReordered;
    }

    public void setListReordered(boolean listReordered) {
        this.m_listReordered = listReordered;
    }

    public List<ResultSet> getModifiedObjectList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet rs = (ResultSet)difference;
                if (rs.a() == null || rs.b() == null || rs.isSame()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public List<ResultSet> getNotSameObjectList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                if (difference.isSame()) continue;
                result.add((ResultSet)difference);
            }
        }
        return result;
    }

    public boolean inBbutNotA() {
        return !this.isSame() && this.a() == null && this.b() != null;
    }

    public int getIndexOfA() {
        return this.m_indexOfA;
    }

    public int getIndexOfB() {
        return this.m_indexOfB;
    }

    @Override
    public int getIndexOf(String contributor) {
        if (UPDATED.equals(contributor)) {
            return this.m_indexOfB;
        }
        return this.m_indexOfA;
    }

    public List<ResultSet> getAList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet rs = (ResultSet)difference;
                if (!rs.inA()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public List<ResultSet> getBList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet rs = (ResultSet)difference;
                if (!rs.inB()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public List<ResultSet> getBonlyList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet rs = (ResultSet)difference;
                if (!rs.inBbutNotA()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public boolean inA() {
        return this.a() != null;
    }

    public boolean inB() {
        return this.b() != null;
    }

    public boolean inAbutNotB() {
        return !this.isSame() && this.a() != null && this.b() == null;
    }

    public List<ResultSet> getAonlyList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet rs = (ResultSet)difference;
                if (!rs.inAbutNotB()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public List<ResultSet> getAllObjectsList() {
        return this.m_list == null ? null : new ArrayList<ResultSet>(this.m_list);
    }

    public Map<String, ResultSet> getModifiedObjectMap() {
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String key : this.m_map.keySet()) {
                ResultSet r = this.m_map.get(key);
                if (r.a() == null || r.b() == null || r.isSame()) continue;
                result.put(key, r);
            }
        }
        return result;
    }

    public Map<String, ResultSet> getNotSameObjectMap() {
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String key : this.m_map.keySet()) {
                ResultSet r = this.m_map.get(key);
                if (r.isSame()) continue;
                result.put(key, r);
            }
        }
        return result;
    }

    public Map<String, ResultSet> getBonlyMap() {
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String key : this.m_map.keySet()) {
                ResultSet r = this.m_map.get(key);
                if (r.a() != null || r.b() == null) continue;
                result.put(key, r);
            }
        }
        return result;
    }

    public Map getAonlyMap() {
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String key : this.m_map.keySet()) {
                ResultSet r = this.m_map.get(key);
                if (r.a() == null || r.b() != null) continue;
                result.put(key, r);
            }
        }
        return result;
    }

    public Map<String, ResultSet> getAllObjectsMap() {
        return this.m_map == null ? null : new HashMap<String, ResultSet>(this.m_map);
    }

    public Class getResultSetClass() {
        Object rso = this.getResultSetObject();
        return rso == null ? null : rso.getClass();
    }

    public Object getResultSetObject() {
        Object a = this.a();
        return a == null ? this.b() : a;
    }

    public Collection<ResultSet> getChildren() {
        Collection<ResultSet> result = null != this.m_map ? this.m_map.values() : (null != this.m_list ? this.m_list : Collections.emptyList());
        return result;
    }

    @Deprecated
    public Iterator<ResultSet> getChildIterator() {
        Iterator<ResultSet> result = null != this.m_map ? this.m_map.values().iterator() : (null != this.m_list ? this.m_list.iterator() : Collections.emptyList().iterator());
        return result;
    }

    public ResultSet copyTo(Object target) {
        ResultSet copy = target == null ? new ResultSet() : (ResultSet)target;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(ResultSet copy) {
        super.copyToImpl(copy);
        copy.m_updateContributor = this.m_updateContributor;
        copy.m_a = this.m_a;
        copy.m_b = this.m_b;
        copy.m_propertyName = this.m_propertyName;
        copy.m_indexOfA = this.m_indexOfA;
        copy.m_indexOfB = this.m_indexOfB;
        copy.m_listReordered = this.m_listReordered;
        if (this.m_list != null) {
            copy.m_list = new ArrayList<ResultSet>();
            for (Difference difference : this.m_list) {
                ResultSet rs = (ResultSet)difference;
                ResultSet child = rs.copyTo(null);
                copy.addToList(child);
            }
        }
        if (this.m_map != null) {
            copy.m_map = new HashMap<String, ResultSet>();
            for (String string : this.m_map.keySet()) {
                ResultSet child = this.m_map.get(string).copyTo(null);
                copy.addToMap(string, child);
            }
        }
    }

    @Deprecated
    public ResultSet getFilteredResultSet(DifferenceFilter rsf) {
        return (ResultSet)this.getFilteredDifference(rsf);
    }

    @Override
    public boolean isLeaf() {
        return LEAF.equals(this.getType()) || MAP.equals(this.getType()) && this.m_map.size() == 0;
    }

    @Override
    public boolean isMap() {
        return MAP.equals(this.getType()) && this.m_map.size() > 0;
    }

    @Override
    public boolean isList() {
        return LIST.equals(this.getType());
    }

    @Override
    public Object getObject(String contributor) {
        if (UPDATED.equals(contributor)) {
            return this.b();
        }
        return this.a();
    }

    @Override
    public void setObject(String contributor, Object object) {
        if (UPDATED.equals(contributor)) {
            this.setB(object);
        } else {
            this.setA(object);
        }
    }

    public List<Difference> getList(String contributor) {
        if (UPDATED.equals(contributor)) {
            return new ArrayList<Difference>(this.getBList());
        }
        return new ArrayList<Difference>(this.getAList());
    }

    @Override
    public String getOriginalContributor() {
        return ORIGINAL;
    }

    @Override
    public Class getDifferenceClass() {
        return this.getResultSetClass();
    }

    @Override
    public void setUpdateContributor(String contributor) {
        this.m_updateContributor = contributor;
    }

    @Override
    public String getUpdateContributor() {
        return this.m_updateContributor;
    }
}

