/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.execute;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.util.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryWrapper
extends StatementWrapper {
    private ResultSet m_rs;
    private List<Object> m_params;
    private boolean m_msgFormat;
    private String m_dbName;

    private QueryWrapper() {
        super((String)null, (Connection)null, (String[])null);
    }

    public QueryWrapper(Database db, String query) {
        this(db, query, (List)null);
    }

    public QueryWrapper(Database db, String query, Object ... params) {
        super(db, query);
        this.setParams(params);
    }

    public QueryWrapper(String name, Connection conn, String query, Object ... params) {
        super(name, conn, query);
        this.setParams(params);
    }

    public QueryWrapper(Database db, String query, List params) {
        super(db, query);
        this.setParams(params);
    }

    private void setParams(Object ... params) {
        this.setParams(params == null ? null : Arrays.asList(params));
    }

    private void setParams(List params) {
        this.m_params = params;
        String query = this.getStatementString();
        boolean bl = this.m_msgFormat = query.indexOf("{0}") >= 0;
        if (!(!this.m_msgFormat && query.indexOf("?") < 0 || this.m_params != null && this.m_params.size() >= 1)) {
            throw new IllegalArgumentException("query expects parameters, none given.");
        }
    }

    public final void setDatabaseName(String dbName) {
        this.m_dbName = dbName;
    }

    public final String getDatabaseName() {
        return this.m_dbName;
    }

    @Override
    protected Statement createStatment() throws SQLException {
        return this.getConnection().prepareStatement(this.getQuery());
    }

    @Override
    public String getStatementTextForLog() {
        return this.getQuery();
    }

    protected String getQuery() {
        if (this.m_msgFormat && this.m_params != null) {
            return MessageFormat.format(this.getStatementString(), this.m_params.toArray());
        }
        return this.getStatementString();
    }

    private String getStatementString() {
        return this.getStatementStrings()[0];
    }

    protected List<Object> getParameters() {
        if (!this.m_msgFormat && this.m_params != null) {
            return this.m_params;
        }
        return Collections.emptyList();
    }

    @Override
    public final boolean execute() throws DBException {
        throw new UnsupportedOperationException("Use executeQuery to execute a QueryWrapper.");
    }

    public String executeSingleCellQuery() throws DBException {
        final Holder result = new Holder();
        this.executeQuery(new QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        result.set((Object)rs.getString(1));
                    }
                }
                catch (SQLException sqe) {
                    QueryWrapper.this.throwDBException(sqe);
                }
            }
        });
        return (String)result.get();
    }

    public void executeQuery(int fetchSize, QueryRunnable run) throws DBException {
        this.doExecute(new QueryExecutionRunnable(this, run, fetchSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQueryImpl(int fetchSize) throws SQLException {
        PreparedStatement stmt = (PreparedStatement)this.getStatement();
        List<Object> params = this.getParameters();
        Object[] convertedParams = null;
        if (params != null && params.size() > 0) {
            convertedParams = new Object[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                convertedParams[i] = this.convertParam(params.get(i));
                if (this.m_msgFormat) continue;
                if (convertedParams[i] instanceof String) {
                    stmt.setString(i + 1, (String)convertedParams[i]);
                    continue;
                }
                if (convertedParams[i] instanceof Date) {
                    stmt.setDate(i + 1, (Date)convertedParams[i]);
                    continue;
                }
                if (convertedParams[i] instanceof Integer) {
                    stmt.setInt(i + 1, (Integer)convertedParams[i]);
                    continue;
                }
                stmt.setObject(i + 1, convertedParams[i]);
            }
        }
        if (fetchSize > 0) {
            try {
                stmt.setFetchSize(fetchSize);
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.sqlTrace(this.getConnectionName(), this.getQuery(), convertedParams);
        try {
            if (this.getDatabase() != null && this.getDatabase() instanceof AbstractDatabase) {
                ((AbstractDatabase)this.getDatabase()).setStatement(stmt);
            }
            this.m_rs = stmt.executeQuery();
        }
        finally {
            if (this.getDatabase() != null && this.getDatabase() instanceof AbstractDatabase) {
                ((AbstractDatabase)this.getDatabase()).setStatement(null);
            }
        }
        return this.m_rs;
    }

    public void executeQuery(QueryRunnable run) throws DBException {
        this.executeQuery(0, run);
    }

    private Object convertParam(Object param) {
        if (param instanceof DBObject) {
            return AbstractDBObjectProvider.convertObject((DBObject)param);
        }
        if (param instanceof Object[]) {
            Object[] forIn = (Object[])param;
            StringBuffer buffy = new StringBuffer();
            for (int j = 0; j < forIn.length; ++j) {
                buffy.append(this.convertParam(forIn[j]));
                if (j >= forIn.length - 1) continue;
                buffy.append(", ");
            }
            return buffy.toString();
        }
        return param;
    }

    @Override
    public void close() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.close();
    }

    public static QueryWrapper union(QueryWrapper ... wrappers) {
        return new UnionQueryWrapper(wrappers);
    }

    public static interface QueryRunnable {
        public void processResultSet(ResultSet var1) throws DBException;
    }

    private static class UnionQueryWrapper
    extends QueryWrapper {
        private static final String UNION_ALL = " UNION ALL\n";
        private QueryWrapper[] m_wrappers;
        private String m_bigQuery;
        private List m_allParams;

        private UnionQueryWrapper(QueryWrapper ... wrappers) {
            if (wrappers == null || wrappers.length < 1) {
                throw new IllegalArgumentException("Nothing to UNION");
            }
            this.m_wrappers = wrappers;
            super.setDatabase(this.m_wrappers[0].getDatabase());
        }

        protected String getQuery() {
            if (this.m_bigQuery == null) {
                this.processWrappers();
            }
            return this.m_bigQuery;
        }

        protected List getParameters() {
            if (this.m_allParams == null) {
                this.processWrappers();
            }
            return this.m_allParams;
        }

        private void processWrappers() {
            this.m_allParams = new ArrayList();
            StringBuffer bigQuery = new StringBuffer();
            for (int i = 0; i < this.m_wrappers.length; ++i) {
                this.m_wrappers[i].setDatabaseName(this.getDatabaseName());
                bigQuery.append(this.m_wrappers[i].getQuery());
                this.m_allParams.addAll(this.m_wrappers[i].getParameters());
                if (i + 1 >= this.m_wrappers.length) continue;
                bigQuery.append(UNION_ALL);
            }
            this.m_bigQuery = bigQuery.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueryExecutionRunnable<T extends QueryRunnable>
    extends StatementWrapper.ExecutionRunnable {
        private int m_fetchSize;
        private T m_run;
        final /* synthetic */ QueryWrapper this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        QueryExecutionRunnable(T run, int fetchSize) {
            this.this$0 = (QueryWrapper)n;
            super((StatementWrapper)n);
            this.m_run = run;
            this.m_fetchSize = fetchSize;
        }

        protected T getRunnable() {
            return this.m_run;
        }

        protected void processResultSet(ResultSet rs) throws DBException {
            if (this.m_run != null) {
                this.m_run.processResultSet(rs);
            }
        }

        protected void prepareStatement() throws DBException {
        }

        public final Object runImpl() throws DBException {
            Database db = this.this$0.getDatabase();
            if (db == null) {
                try {
                    this.doRunImpl();
                }
                catch (SQLException sqe) {
                    this.this$0.throwDBException(sqe);
                }
            } else {
                ConnectionWrapper wrap = new ConnectionWrapper(db, this.this$0.getStatementTextForLog());
                wrap.run(new ConnectionWrapper.SQLRunnable(wrap){

                    public void run() throws SQLException, DBException {
                        QueryExecutionRunnable.this.doRunImpl();
                    }
                });
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRunImpl() throws SQLException, DBException {
            try {
                this.this$0.setExecuting(true);
                this.prepareStatement();
                ResultSet rs = this.this$0.executeQueryImpl(this.m_fetchSize);
                this.processResultSet(rs);
            }
            finally {
                this.this$0.close();
                this.this$0.setExecuting(false);
            }
        }
    }
}

