/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.DBLog;

public abstract class ConnectionMatcher {
    public abstract boolean matches(Connection var1);

    public static ConnectionMatcher matchDatabaseProductName(String regex) {
        return new DatabaseProductNameMatcher(regex);
    }

    public static ConnectionMatcher matchDatabaseProductVersion(String regex) {
        return new DatabaseProductVersionMatcher(regex);
    }

    public static ConnectionMatcher matchDriverName(String regex) {
        return new DriverNameMatcher(regex);
    }

    public static ConnectionMatcher matchAll(boolean and, ConnectionMatcher ... matchers) {
        return new AndOrMatcher(and, matchers);
    }

    private static class DatabaseProductNameMatcher
    extends RegexMatcher {
        DatabaseProductNameMatcher(String productNameExp) {
            super(productNameExp);
        }

        protected String getStringToMatch(Connection conn) throws SQLException {
            return conn.getMetaData().getDatabaseProductName();
        }
    }

    private static class DatabaseProductVersionMatcher
    extends RegexMatcher {
        DatabaseProductVersionMatcher(String productVersionExp) {
            super(productVersionExp);
        }

        protected String getStringToMatch(Connection conn) throws SQLException {
            return conn.getMetaData().getDatabaseProductVersion();
        }
    }

    private static class DriverNameMatcher
    extends RegexMatcher {
        DriverNameMatcher(String classNameExp) {
            super(classNameExp);
        }

        protected String getStringToMatch(Connection conn) throws SQLException {
            return conn.getMetaData().getDriverName();
        }
    }

    private static abstract class RegexMatcher
    extends ConnectionMatcher {
        private final String m_regex;

        RegexMatcher(String regex) {
            this.m_regex = regex;
        }

        public boolean matches(Connection conn) {
            boolean retval = false;
            try {
                retval = this.getStringToMatch(conn).matches(this.m_regex);
            }
            catch (Exception sqe) {
                DBLog.getLogger(this).fine(sqe.getMessage());
            }
            return retval;
        }

        protected abstract String getStringToMatch(Connection var1) throws SQLException;
    }

    private static class AndOrMatcher
    extends ConnectionMatcher {
        private final boolean m_and;
        private final ConnectionMatcher[] m_children;

        AndOrMatcher(boolean and, ConnectionMatcher ... children) {
            this.m_and = and;
            this.m_children = children;
            if (children == null) {
                throw new IllegalArgumentException("Must supply children");
            }
        }

        public boolean matches(Connection conn) {
            ConnectionMatcher child;
            boolean retval = false;
            ConnectionMatcher[] arr$ = this.m_children;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (retval = (child = arr$[i$]).matches(conn)) == this.m_and; ++i$) {
            }
            return retval;
        }
    }
}

