/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.Holder;
import oracle.javatools.util.deferred.Thunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBCore {
    private static final String IMPL_CLASS_NAME = "oracle.javatools.db.DBCoreImpl";
    private static DBCore s_instance;
    private static ClassLoader s_implClassLoader;
    private static Holder<Runnable> s_extensionRunnable;
    private final Map<Class, Object> m_map = new HashMap<Class, Object>();
    private final Map<Class, List<? extends Thunk>> m_lists = new HashMap<Class, List<? extends Thunk>>();
    private final Map<Class, Map<String, Thunk>> m_maps = new HashMap<Class, Map<String, Thunk>>();

    private DBCore() {
    }

    public <T> void registerFactoryList(Class clz, List<? extends Thunk> list) {
        if (clz != null && list != null) {
            this.m_lists.put(clz, list);
        }
    }

    public <T> void registerFactoryMap(Class clz, Map<String, Thunk> map) {
        if (clz != null && map != null) {
            this.m_maps.put(clz, map);
        }
    }

    public Map<String, Thunk> getFactoryMap(Class clz) {
        return this.m_maps.get(clz);
    }

    public <T> T getRegisteredFactory(Class<T> clz, String identifier) {
        Thunk thunk;
        Object retval = null;
        Map<String, Thunk> map = this.getFactoryMap(clz);
        if (map != null && (thunk = map.get(identifier)) != null) {
            try {
                retval = thunk.get();
            }
            catch (Exception e) {
                DBLog.getLogger(clz).log(Level.SEVERE, "Cannot initialize registered " + clz.getName(), e);
            }
        }
        return (T)retval;
    }

    public List<? extends Thunk> getFactoryList(Class clz) {
        return this.m_lists.get(clz);
    }

    public <T> void populateFactoryList(Class<T> clz, List<T> list) {
        List<? extends Thunk> thunks = this.getFactoryList(clz);
        this.populateFactoryList(clz, list, thunks);
    }

    public <T> void populateFactoryList(Class<T> clz, List<T> list, Iterable<? extends Thunk> thunks) {
        if (thunks != null) {
            for (Thunk thunk : thunks) {
                try {
                    Object c = thunk.get();
                    if (c == null) continue;
                    list.add(c);
                }
                catch (Exception e) {
                    DBLog.getLogger(clz).log(Level.SEVERE, "Cannot initialize registered " + clz.getName(), e);
                }
            }
        }
    }

    public void put(Object obj) {
        this.m_map.put(obj.getClass(), obj);
    }

    public <T> T get(Class<T> clz) {
        return (T)this.m_map.get(clz);
    }

    public <T> T remove(Class<T> clz) {
        return (T)this.m_map.remove(clz);
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DBCore.class);
    }

    private static void init() {
        try {
            Class<?> clz = DBCore.getImplClassLoader().loadClass(IMPL_CLASS_NAME);
            Object obj = clz.newInstance();
        }
        catch (InstantiationException e) {
            DBCore.getLogger().severe("Cannot instantiate core database API implementation.");
        }
        catch (IllegalAccessException e) {
            DBCore.getLogger().severe("Cannot instantiate core database API implementation.");
        }
        catch (ClassNotFoundException e) {
            DBCore.getLogger().severe("Cannot find core database API implementation. Is dbapi-impl.jar on the classpath?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBCore getInstance() {
        boolean doit = false;
        Class<DBCore> clazz = DBCore.class;
        synchronized (DBCore.class) {
            if (s_instance == null) {
                doit = true;
                s_instance = new DBCore();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (doit) {
                DBCore.init();
            }
            return s_instance;
        }
    }

    public static synchronized void setImplClassLoader(ClassLoader cl) {
        if (s_implClassLoader != null) {
            DBCore.getLogger().severe("core already initialized");
        } else {
            s_implClassLoader = cl;
        }
    }

    public static ClassLoader getImplClassLoader() {
        if (s_implClassLoader == null) {
            return DBCore.class.getClassLoader();
        }
        return s_implClassLoader;
    }

    public static synchronized void setExtensionInitializer(Runnable run) {
        if (s_extensionRunnable != null) {
            DBCore.getLogger().severe("runnable already initialized");
        } else {
            s_extensionRunnable = new Holder((Object)run);
        }
    }

    public static synchronized void checkExtensionInitialization() {
        Runnable run;
        if (s_extensionRunnable != null && (run = (Runnable)s_extensionRunnable.get()) != null) {
            run.run();
            s_extensionRunnable.set(null);
        }
    }
}

