/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.plsql.PlSqlSourceObject;

public abstract class AbstractResourceCache {
    private final DatabaseDescriptor m_desc;
    private final String m_resourceDir;

    public AbstractResourceCache(DatabaseDescriptor desc, String resourceDir) {
        this.m_desc = desc;
        this.m_resourceDir = resourceDir;
    }

    protected final DatabaseDescriptor getDatabaseDescriptor() {
        return this.m_desc;
    }

    protected ClassLoader getResourceClassLoader() {
        return this.getDatabaseDescriptor().getClass().getClassLoader();
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected DBObjectHandler getHandler(DBObject obj) {
        String ident = obj instanceof PlSqlSourceObject ? "plsql" : "xml";
        return DBCore.getInstance().getRegisteredFactory(DBObjectHandler.class, ident);
    }

    protected final String getResourceRoot() {
        return this.m_resourceDir;
    }

    protected void markForLazyInit(AbstractBuildableObject obj, String resourcePath) {
        ClassLoader cl = this.getResourceClassLoader();
        URL url = cl.getResource(resourcePath);
        if (url != null) {
            new LazyObjectBuilder(obj, resourcePath);
        }
    }

    protected final String getResourcePath(String ... relPath) {
        StringBuilder buff = new StringBuilder(this.getResourceRoot());
        for (String name : relPath) {
            buff.append("/").append(name);
        }
        return buff.toString();
    }

    private class LazyObjectBuilder
    extends AbstractDBObjectBuilder {
        private final String m_resource;

        LazyObjectBuilder(AbstractBuildableObject obj, String resource) {
            super(null, obj.getType());
            this.setBuilder(obj);
            this.m_resource = resource;
        }

        protected boolean canBuildComponents() {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void fillInObject(AbstractBuildableObject obj) throws DBException {
            InputStream stream = null;
            try {
                block9: {
                    try {
                        DBObject loaded;
                        stream = AbstractResourceCache.this.getResourceClassLoader().getResourceAsStream(this.m_resource);
                        DBObjectHandler handler = AbstractResourceCache.this.getHandler(obj);
                        List<DBObject> built = handler.read(stream, null, DBUtil.getSchema(obj));
                        if (built == null || built.size() != 1 || !((loaded = built.get(0)) instanceof AbstractBuildableObject)) break block9;
                        DBObjectID oldID = obj.getID();
                        loaded.copyTo((DBObject)obj, new IDPolicy.SameIDPolicy());
                        if (oldID != null) {
                            obj.setID(oldID);
                        }
                    }
                    catch (IOException ioe) {
                        throw new DBException(obj, ioe.getMessage(), ioe);
                    }
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            stream.close();
            return;
        }
    }
}

