/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBObjectHandler {
    protected String getEncoding() {
        return "UTF-8";
    }

    public final void write(DBObject obj, OutputStream out) throws IOException {
        this.write(Collections.singletonList(obj), out);
    }

    public final void write(DBObject obj, Writer out) throws IOException {
        this.write(Collections.singletonList(obj), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(List<? extends DBObject> objs, URL url) throws IOException {
        OutputStream out = URLFileSystem.openOutputStream((URL)url);
        try {
            this.write(objs, out);
            Object var5_4 = null;
            this.close(out);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close(out);
            throw throwable;
        }
    }

    public final void write(List<? extends DBObject> objs, OutputStream out) throws IOException {
        this.write(objs, (Writer)new OutputStreamWriter(out, this.getEncoding()));
    }

    public abstract void write(List<? extends DBObject> var1, Writer var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canRead(URL url, DBObjectProvider pro) throws IOException {
        boolean retval = false;
        InputStream in = URLFileSystem.openInputStream((URL)url);
        try {
            retval = this.canRead(in, pro);
            Object var6_5 = null;
            this.close(in);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.close(in);
            throw throwable;
        }
        return retval;
    }

    public final boolean canRead(InputStream in, DBObjectProvider pro) throws IOException {
        return this.canRead(new InputStreamReader(in, this.getEncoding()), pro);
    }

    public abstract boolean canRead(Reader var1, DBObjectProvider var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DBObject> read(URL url, DBObjectProvider pro, Schema schema) throws IOException {
        List<DBObject> retval = null;
        schema = this.checkSchema(url, schema);
        InputStream in = URLFileSystem.openInputStream((URL)url);
        try {
            retval = this.read(in, pro, schema);
            Object var7_6 = null;
            this.close(in);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.close(in);
            throw throwable;
        }
        return retval;
    }

    private Schema checkSchema(URL url, Schema schema) {
        String schemaName;
        if (schema == null && ModelUtil.hasLength((String)(schemaName = this.getSchemaName(url)))) {
            schema = new Schema(schemaName);
        }
        return schema;
    }

    protected String getSchemaName(URL url) {
        return URLFileSystem.getName((URL)URLFileSystem.getParent((URL)url));
    }

    public final List<DBObject> read(InputStream in, DBObjectProvider pro, Schema schema) throws IOException {
        return this.read(new InputStreamReader(in, this.getEncoding()), pro, schema);
    }

    public final List<DBObject> read(Reader reader, DBObjectProvider pro, Schema schema) throws IOException {
        return this.read(reader, pro, schema, true);
    }

    public final List<DBObject> read(Reader reader, DBObjectProvider pro, Schema schema, boolean overrideSchema) throws IOException {
        List<DBObject> retval = this.readImpl(reader, pro, schema);
        if (retval != null) {
            for (DBObject obj : retval) {
                Schema objSchema;
                Schema schemaToUse = schema;
                if (!overrideSchema && obj instanceof SchemaObject && (objSchema = ((SchemaObject)obj).getSchema()) != null) {
                    schemaToUse = objSchema;
                }
                this.ensureDetails(obj, pro, schemaToUse, false);
            }
        }
        return retval;
    }

    protected void ensureDetails(DBObject obj, DBObjectProvider pro, Schema schema, boolean infoOnly) {
        if (obj instanceof SchemaObject) {
            ((SchemaObject)obj).setSchema(schema);
        }
        if (obj != null && pro != null) {
            pro.getObjectFactory().ensureID(obj, !infoOnly, infoOnly);
        }
    }

    protected abstract List<DBObject> readImpl(Reader var1, DBObjectProvider var2, Schema var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DBObject> readInfo(URL url, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        List<DBObject> retval = null;
        schema = this.checkSchema(url, schema);
        InputStream in = URLFileSystem.openInputStream((URL)url);
        try {
            retval = this.readInfo(in, pro, schema);
            Object var7_6 = null;
            this.close(in);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.close(in);
            throw throwable;
        }
        return retval;
    }

    public final List<DBObject> readInfo(InputStream in, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        return this.readInfo(new InputStreamReader(in, this.getEncoding()), pro, schema);
    }

    public final List<DBObject> readInfo(Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        List<DBObject> retval = this.readInfoImpl(reader, pro, schema);
        if (retval != null) {
            for (DBObject obj : retval) {
                this.ensureDetails(obj, pro, schema, true);
            }
        }
        return retval;
    }

    protected List<DBObject> readInfoImpl(Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        throw new PartialParseUnsupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UnmarshalledIDs readIDs(URL url, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        UnmarshalledIDs retval = null;
        schema = this.checkSchema(url, schema);
        InputStream in = URLFileSystem.openInputStream((URL)url);
        try {
            retval = this.readIDs(in, pro, schema);
            Object var7_6 = null;
            this.close(in);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.close(in);
            throw throwable;
        }
        return retval;
    }

    public final UnmarshalledIDs readIDs(InputStream in, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        return this.readIDs(new InputStreamReader(in, this.getEncoding()), pro, schema);
    }

    public final UnmarshalledIDs readIDs(Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        UnmarshalledIDs retval = new UnmarshalledIDs(pro);
        this.readIDsImpl(retval, reader, pro, schema);
        return retval;
    }

    protected void readIDsImpl(UnmarshalledIDs ids, Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        throw new PartialParseUnsupportedException();
    }

    private void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnmarshalledIDs {
        private final List<DBObjectID> m_ids = new ArrayList<DBObjectID>();
        private final Set<DBObjectID> m_refs = new DBObjectIDSet(true);
        private final DBObjectProvider m_pro;

        private UnmarshalledIDs(DBObjectProvider pro) {
            this.m_pro = pro;
        }

        private void ensureProvider(DBObjectID id) {
            if (this.m_pro != null) {
                this.m_pro.getObjectFactory().ensureProvider(id);
            }
        }

        public void addObjectID(DBObjectID id) {
            if (id != null) {
                this.ensureProvider(id);
                this.m_ids.add(id);
            }
        }

        public void addReferenceID(DBObjectID ref) {
            if (ref != null) {
                this.ensureProvider(ref);
                this.m_refs.add(ref);
            }
        }

        public Collection<DBObjectID> getReferences() {
            return this.m_refs;
        }

        public List<DBObjectID> getObjectIDs() {
            return this.m_ids;
        }
    }
}

