/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

public class LOBDescriptor
extends AbstractChildDBObject {
    public static final String TYPE = "LOB DESCRIPTOR";
    public static final String LOB_PARAMETER_CACHE = "CACHE";
    public static final String LOB_PARAMETER_NOCACHE = "NOCACHE";
    public static final String LOB_PARAMETER_CACHEREADS = "CACHE READS";

    public LOBDescriptor() {
        this.setStorageEnabledInRow(true);
        this.setRetention(false);
    }

    public String getName() {
        Relation rel;
        String name = super.getName();
        if (!ModelUtil.hasLength((String)name) && (rel = this.findParent(Relation.class)) != null) {
            name = "";
            for (DBObjectID colID : this.getColumns()) {
                DBObject col;
                if (colID == null || !((col = rel.findOwnedObject(colID)) instanceof Column)) continue;
                if (name.length() > 0) {
                    name = name + ", ";
                }
                name = name + col.getName();
            }
            this.setName(name);
        }
        return name;
    }

    public String getType() {
        return TYPE;
    }

    public void setLOBSegName(String name) {
        this.setProperty("LOBSegName", name);
    }

    @TextProperty(internalName=true)
    public String getLOBSegName() {
        return (String)this.getProperty("LOBSegName");
    }

    public void setColumns(DBObjectID[] columns) {
        this.getChildSupport("columns").setChildArray(columns);
        this.setName(null);
    }

    public DBObjectID[] getColumns() {
        return this.getChildSupport("columns").getChildArray(DBObjectID.class);
    }

    public void addColumn(DBObjectID column) {
        if (column != null) {
            this.getChildSupport("columns").addChild(column);
            this.setName(null);
        }
    }

    public void removeColumn(DBObjectID column) {
        if (this.getChildSupport("columns").removeChild(column)) {
            this.setName(null);
        }
    }

    public void setChunk(Integer chunk) {
        this.setProperty("chunk", chunk);
    }

    public Integer getChunk() {
        return (Integer)this.getProperty("chunk");
    }

    public void setPctVersion(Integer pctVersion) {
        this.setProperty("pctVersion", pctVersion);
    }

    public Integer getPctVersion() {
        return (Integer)this.getProperty("pctVersion");
    }

    public void setFreepools(Integer freepools) {
        this.setProperty("freepools", freepools);
    }

    public Integer getFreepools() {
        return (Integer)this.getProperty("freepools");
    }

    public void setStorage(OracleStorageProperties storage) {
        this.setProperty("storage", storage);
    }

    public OracleStorageProperties getStorage() {
        return (OracleStorageProperties)this.getProperty("storage");
    }

    public void setRetention(boolean retention) {
        this.setProperty("retention", retention);
    }

    public boolean isRetention() {
        return (Boolean)this.getProperty("retention", false);
    }

    public void setStorageEnabledInRow(boolean storageEnabledInRow) {
        this.setProperty("storageEnabledInRow", storageEnabledInRow);
    }

    public boolean isStorageEnabledInRow() {
        return (Boolean)this.getProperty("storageEnabledInRow", true);
    }

    @Deprecated
    @Transient
    public void setCache(String cache) {
        LOBCache lobCache;
        if (cache == null) {
            lobCache = null;
        } else if (cache.equals(LOB_PARAMETER_CACHE)) {
            lobCache = LOBCache.CACHE;
        } else if (cache.equals(LOB_PARAMETER_NOCACHE)) {
            lobCache = LOBCache.NOCACHE;
        } else if (cache.equals(LOB_PARAMETER_CACHEREADS)) {
            lobCache = LOBCache.CACHE_READS;
        } else {
            Object lobCache2 = null;
            throw new IllegalArgumentException(APIBundle.format("LOB_INVALID_CACHE", cache));
        }
        this.setLOBCache(lobCache);
    }

    @Deprecated
    public String getCache() {
        LOBCache lobCache = this.getLOBCache();
        return lobCache == null ? null : lobCache.toString();
    }

    public void setLOBCache(LOBCache cache) {
        this.setProperty("LOBCache", (Object)cache);
    }

    public LOBCache getLOBCache() {
        return (LOBCache)((Object)this.getProperty("LOBCache"));
    }

    @Deprecated
    public static boolean isLOBColumn(DBObjectID colID) {
        return false;
    }

    public static boolean isLOBColumn(DBObjectID colID, DBObject context) {
        Column col;
        boolean retval = false;
        Relation rel = DBUtil.findParentOfType(context, Relation.class);
        if (rel != null && LOBDescriptor.isLOBColumn(col = (Column)rel.findOwnedObject(colID))) {
            retval = true;
        }
        return retval;
    }

    public static boolean isLOBColumn(Column column) {
        try {
            DataType dt = DataTypeHelper.getDataType(column.getDataTypeUsage());
            return LOBDescriptor.isLOBType(dt);
        }
        catch (DBException dBException) {
            return false;
        }
    }

    public static boolean isLOBType(DataType type) {
        boolean retval = false;
        if (type != null) {
            String name = type.getName();
            retval = "BLOB".equalsIgnoreCase(name) || "CLOB".equalsIgnoreCase(name) || "NCLOB".equalsIgnoreCase(name);
        }
        return retval;
    }

    @Deprecated
    public static boolean isVARRAYColumn(DBObjectID colID) {
        return false;
    }

    public static boolean isVARRAYColumn(DBObjectID colID, DBObject context) {
        Column col;
        boolean retval = false;
        Relation rel = DBUtil.findParentOfType(context, Relation.class);
        if (rel != null && LOBDescriptor.isVARRAYColumn(col = (Column)rel.findOwnedObject(colID))) {
            retval = true;
        }
        return retval;
    }

    public static boolean isVARRAYColumn(Column column) {
        boolean retval = false;
        try {
            DataTypeUsage dtu = column.getDataTypeUsage();
            if (dtu != null) {
                DataType typ = DataTypeHelper.getDataType(dtu);
                retval = LOBDescriptor.isVARRAYType(typ);
            }
        }
        catch (DBException e) {
            DBLog.getLogger(LOBDescriptor.class).fine(e.getMessage());
        }
        return retval;
    }

    public static boolean isVARRAYType(DataType type) {
        PlSqlInterrogator pi;
        boolean retval = false;
        if (type instanceof Type && "VARYING ARRAY".equals((pi = PlSqlInterrogatorFactory.getInterrogator((Type)type)).getCollectionType())) {
            retval = true;
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LOBCache {
        CACHE("CACHE"),
        NOCACHE("NOCACHE"),
        CACHE_READS("CACHE READS");

        private String m_value;

        private LOBCache(String val) {
            this.m_value = val;
        }

        public String toString() {
            return this.m_value;
        }
    }
}

