/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePartition
extends AbstractChildDBObject {
    public static final String TYPE = "PARTITION";
    public static final String COMPRESS = "COMPRESS";
    public static final String NOCOMPRESS = "NOCOMPRESS";
    private static final char COMMA = ',';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private transient String m_display;

    public TablePartition() {
    }

    public TablePartition(String name) {
        this(name, null, null);
    }

    public TablePartition(OracleTablePartitions.PartitionType partitionType, OracleTablePartitions.ObjectType objectType) {
        this(null, partitionType, objectType);
    }

    public TablePartition(String name, OracleTablePartitions.PartitionType partitionType, OracleTablePartitions.ObjectType objectType) {
        super(name);
        this.setPartitionType(partitionType);
        this.setObjectType(objectType);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setPartitionType(OracleTablePartitions.PartitionType partitionType) {
        this.m_display = null;
        this.setProperty("partitionType", (Object)partitionType);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public OracleTablePartitions.PartitionType getPartitionType() {
        return (OracleTablePartitions.PartitionType)((Object)this.getProperty("partitionType"));
    }

    public void setObjectType(OracleTablePartitions.ObjectType objectType) {
        this.setProperty("objectType", (Object)objectType);
    }

    public OracleTablePartitions.ObjectType getObjectType() {
        return (OracleTablePartitions.ObjectType)((Object)this.getProperty("objectType"));
    }

    @Override
    public void setName(String name) {
        this.m_display = null;
        super.setName(name);
    }

    public void setSegmentAttributes(OracleStorageProperties segmentAttributes) {
        this.setProperty("segmentAttributes", segmentAttributes);
    }

    public OracleStorageProperties getSegmentAttributes() {
        return (OracleStorageProperties)this.getProperty("segmentAttributes");
    }

    @Deprecated
    @Transient
    public void setCompression(String compression) {
        OracleTableProperties otp;
        OracleTableProperties oracleTableProperties = otp = compression == null ? (OracleTableProperties)this.getProperty("OracleTableProperties") : OracleTableProperties.findOrCreateOracleTableProperties(this);
        if (otp != null) {
            otp.setTableCompression(OracleTableProperties.OracleTableCompression.migrateFrom(compression));
        }
    }

    @Deprecated
    public String getCompression() {
        OracleTableProperties.OracleTableCompression comp;
        String compression = null;
        OracleTableProperties otp = (OracleTableProperties)this.getProperty("OracleTableProperties");
        if (otp != null && (comp = otp.getTableCompression()) != null) {
            compression = otp.getTableCompression().toString();
        }
        return compression;
    }

    public void setLOBDescriptors(LOBDescriptor[] lobDescriptors) {
        this.getChildSupport("LOBDescriptors").setChildArray(lobDescriptors);
    }

    public void addLOBDescriptor(LOBDescriptor lobDescriptor) {
        this.getChildSupport("LOBDescriptors").addChild(lobDescriptor);
    }

    public void removeLOBDescriptor(LOBDescriptor lobDescriptor) {
        this.getChildSupport("LOBDescriptors").removeChild(lobDescriptor);
    }

    public void removeAllLOBDescriptors() {
        this.getChildSupport("LOBDescriptors").clearChildren();
    }

    public LOBDescriptor[] getLOBDescriptors() {
        return this.getChildSupport("LOBDescriptors").getChildArray(LOBDescriptor.class);
    }

    public void setValues(Object[] values) {
        Object[] nValues;
        if (values == null) {
            nValues = null;
        } else {
            nValues = new Object[values.length];
            for (int i = 0; i < nValues.length; ++i) {
                nValues[i] = this.normaliseValue(values[i]);
            }
        }
        this.getChildSupport("values").setChildArray(nValues);
    }

    private Object normaliseValue(Object value) {
        if (value instanceof String) {
            OracleTablePartitions.PartitionType partitionType = this.getPartitionType();
            String s = (String)value;
            if (partitionType == OracleTablePartitions.PartitionType.LIST && ("NULL".equalsIgnoreCase(s) || "DEFAULT".equalsIgnoreCase(s))) {
                value = ListValue.valueOf(s.toUpperCase());
            } else if (partitionType == OracleTablePartitions.PartitionType.RANGE && "MAXVALUE".equalsIgnoreCase(s)) {
                value = RangeValue.valueOf(s.toUpperCase());
            }
        }
        return value;
    }

    public void setValues(String values) {
        if (ModelUtil.hasLength((String)values)) {
            List<String> list = TablePartition.splitValues(values);
            this.setValues(list.toArray(new String[list.size()]));
        }
    }

    public Object[] getValues() {
        return this.getChildSupport("values").getChildArray(Object.class);
    }

    public void addValue(Object value) {
        this.m_display = null;
        if (value != null) {
            this.getChildSupport("values").addChild(value);
        }
    }

    public void addValue(Object value, int atIndex) {
        this.m_display = null;
        if (value != null) {
            this.getChildSupport("values").addChild(atIndex, value);
        }
    }

    public void removeValue(Object value) {
        this.m_display = null;
        this.getChildSupport("values").removeChild(value);
    }

    public void setPartitionLevelSubpartitions(OracleTablePartitions partitionLevelSubpartitions) {
        this.setProperty("partitionLevelSubpartitions", partitionLevelSubpartitions);
    }

    public OracleTablePartitions getPartitionLevelSubpartitions() {
        return (OracleTablePartitions)this.getProperty("partitionLevelSubpartitions");
    }

    @Override
    public String toString() {
        if (this.m_display == null) {
            OracleTablePartitions.PartitionType partitionType;
            String name = this.getName();
            StringBuffer buff = new StringBuffer();
            if (ModelUtil.hasLength((String)name)) {
                buff.append(name).append(" ");
            }
            if ((partitionType = this.getPartitionType()) == OracleTablePartitions.PartitionType.LIST) {
                buff.append("VALUES (");
            } else if (partitionType == OracleTablePartitions.PartitionType.RANGE) {
                buff.append("VALUES LESS THAN (");
            }
            Iterator<Object> iter = Arrays.asList(this.getValues()).iterator();
            while (iter.hasNext()) {
                buff.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                buff.append(", ");
            }
            if (partitionType == OracleTablePartitions.PartitionType.LIST || partitionType == OracleTablePartitions.PartitionType.RANGE) {
                buff.append(")");
            }
            this.m_display = buff.length() > 0 ? buff.toString() : "<partition>";
        }
        return this.m_display;
    }

    public static List<String> splitValues(String string) {
        ArrayList<String> valueList = new ArrayList<String>();
        if (ModelUtil.hasLength((String)string)) {
            boolean inSingleQuote = false;
            boolean inDoubleQuote = false;
            int bracketCount = 0;
            int startIndex = 0;
            for (int idx = 0; idx < string.length(); ++idx) {
                char ch = string.charAt(idx);
                if (inSingleQuote) {
                    inSingleQuote = ch != '\'';
                    continue;
                }
                if (inDoubleQuote) {
                    inDoubleQuote = ch != '\"';
                    continue;
                }
                if (bracketCount > 0) {
                    bracketCount += ch == '(' ? 1 : (ch == ')' ? -1 : 0);
                    continue;
                }
                if (ch == ',') {
                    String value = string.substring(startIndex, idx).trim();
                    if (ModelUtil.hasLength((String)value)) {
                        valueList.add(value);
                    }
                    startIndex = idx + 1;
                    continue;
                }
                inSingleQuote = ch == '\'';
                inDoubleQuote = ch == '\"';
                bracketCount = ch == '(' ? 1 : 0;
            }
            if (startIndex < string.length()) {
                valueList.add(string.substring(startIndex).trim());
            }
        }
        return valueList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListValue {
        NULL,
        DEFAULT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RangeValue {
        MAXVALUE;

    }
}

