/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ora.XMLSchemaElement;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.References;

public class XMLTypeColumnProperties
extends AbstractChildDBObject {
    public static final String TYPE = "XMLTypeColumnProperties";

    public XMLTypeColumnProperties() {
        this.setStoreAs(StoreAs.CLOB);
        this.setAllowAnySchema(false);
        this.setAllowNonSchema(false);
    }

    public String getType() {
        return TYPE;
    }

    public void setStoreAs(StoreAs storeAs) {
        this.setProperty("storeAs", (Object)storeAs);
    }

    public StoreAs getStoreAs() {
        return (StoreAs)((Object)this.getProperty("storeAs"));
    }

    public void setElementID(DBObjectID elementID) {
        this.setProperty("elementID", elementID);
    }

    @References(value=XMLSchemaElement.class)
    public DBObjectID getElementID() {
        return (DBObjectID)this.getProperty("elementID");
    }

    public void setAllowAnySchema(boolean allowAnySchema) {
        this.setProperty("allowAnySchema", allowAnySchema);
    }

    public boolean isAllowAnySchema() {
        return (Boolean)this.getProperty("allowAnySchema", false);
    }

    public void setAllowNonSchema(boolean allowNonSchema) {
        this.setProperty("allowNonSchema", allowNonSchema);
    }

    public boolean isAllowNonSchema() {
        return (Boolean)this.getProperty("allowNonSchema", false);
    }

    public static boolean isXMLType(DataType type) {
        Type ct;
        Schema schema;
        boolean retval = false;
        if (type instanceof Type && (schema = (ct = (Type)type).getSchema()) != null) {
            retval = ("SYS".equals(schema.getName()) || "PUBLIC".equals(schema.getName())) && "XMLTYPE".equalsIgnoreCase(ct.getName());
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoreAs {
        OBJECT_RELATIONAL("OBJECT RELATIONAL"),
        CLOB("CLOB"),
        BINARY_XML("BINARY XML");

        private String _value;

        private StoreAs(String val) {
            this._value = val;
        }

        public String toString() {
            return this._value;
        }
    }
}

