/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBObjectPlSqlFragment
extends AbstractChildBuildableObject {
    private transient String m_sourceID;

    public DBObjectPlSqlFragment() {
        this((String)null, (DBObject)null);
    }

    public DBObjectPlSqlFragment(String name, DBObject parent) {
        this.setName(name);
        this.setParent(parent);
    }

    public Integer getStartOffset() {
        return (Integer)this.getProperty("startOffset");
    }

    public void setStartOffset(Integer start) {
        this.setProperty("startOffset", start);
    }

    public Integer getEndOffset() {
        return (Integer)this.getProperty("endOffset");
    }

    public void setEndOffset(Integer end) {
        this.setProperty("endOffset", end);
    }

    public DBObjectPlSqlFragment getChildAtOffset(int offset) {
        return this.getChildAtOffsetImpl(offset, 0);
    }

    public DBObjectPlSqlFragment getDeclarationAtOffset(int offset) {
        return this.getChildAtOffsetImpl(offset, 1);
    }

    public DBObjectPlSqlFragment getReferenceAtOffset(int offset) {
        return this.getChildAtOffsetImpl(offset, 2);
    }

    private DBObjectPlSqlFragment getChildAtOffsetImpl(int offset, int type) {
        ArrayList<DBObjectPlSqlFragment> list = new ArrayList<DBObjectPlSqlFragment>();
        this.findChildrenAtOffset(offset, list);
        DBObjectPlSqlFragment retval = null;
        for (DBObjectPlSqlFragment frag : list) {
            if (type == 2 && !(frag instanceof PlSqlReference) || type == 1 && frag instanceof PlSqlReference) continue;
            if (retval == null) {
                retval = frag;
                continue;
            }
            if (frag.getEndOffset() - frag.getStartOffset() < retval.getEndOffset() - retval.getStartOffset()) {
                retval = frag;
                continue;
            }
            if (frag.getEndOffset() - frag.getStartOffset() != retval.getEndOffset() - retval.getStartOffset() || !(frag instanceof PlSqlReference)) continue;
            if (!(retval instanceof PlSqlReference)) {
                retval = frag;
                continue;
            }
            DBObjectID refID = ((PlSqlReference)retval).getReferenceID();
            try {
                DBObject ref = refID.resolveID();
                if (!(ref instanceof DBObjectPlSqlFragment) || !((DBObjectPlSqlFragment)ref).getStartOffset().equals(retval.getStartOffset())) continue;
                retval = frag;
            }
            catch (DBException e) {}
        }
        return retval;
    }

    private void findChildrenAtOffset(int offset, List<DBObjectPlSqlFragment> list) {
        if (this.getStartOffset() != null && this.getStartOffset() != null && this.getStartOffset() <= offset && this.getEndOffset() >= offset) {
            list.add(this);
        }
        for (DBObject child : this.getOwnedObjects()) {
            if (!(child instanceof DBObjectPlSqlFragment)) continue;
            DBObjectPlSqlFragment dboFrag = (DBObjectPlSqlFragment)child;
            Integer start = dboFrag.getStartOffset();
            Integer end = dboFrag.getEndOffset();
            if (!(start != null && start > offset || end != null && end < offset)) {
                dboFrag.findChildrenAtOffset(offset, list);
                continue;
            }
            if (!(dboFrag instanceof PlSqlDatum)) continue;
            dboFrag.findChildrenAtOffset(offset, list);
        }
    }

    @Transient
    public String getSourceID() {
        if (this instanceof PlSqlSourceObject) {
            if (this.m_sourceID == null) {
                this.m_sourceID = DBUtil.createUUID();
            }
            return this.m_sourceID;
        }
        if (this.getParent() instanceof DBObjectPlSqlFragment) {
            return ((DBObjectPlSqlFragment)this.getParent()).getSourceID();
        }
        return null;
    }

    PlSqlSourceObject getSourceObject() {
        if (this instanceof PlSqlSourceObject) {
            return (PlSqlSourceObject)((Object)this);
        }
        if (this.getParent() instanceof DBObjectPlSqlFragment) {
            return ((DBObjectPlSqlFragment)this.getParent()).getSourceObject();
        }
        return null;
    }

    @Override
    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        if (copy instanceof DBObjectPlSqlFragment) {
            DBObjectPlSqlFragment frag = (DBObjectPlSqlFragment)copy;
            frag.m_sourceID = this.m_sourceID;
        }
    }

    @Override
    public String getName() {
        String source;
        String name = super.getName();
        if (name == null && this instanceof PlSqlSourceObject && !TemplateExpander.isPendingObject(this) && ModelUtil.hasLength((String)(source = ((PlSqlSourceObject)((Object)this)).getSource()))) {
            name = PlSqlUtilCore.getNameFromSource(source);
        }
        return name;
    }

    @Transient
    protected void setSourceImpl(String source) {
        if (!(this instanceof PlSqlSourceObject)) {
            throw new UnsupportedOperationException("setSourceImpl only for PlSqlSourceObjects");
        }
        this.setProperty("source", source);
        this.m_sourceID = null;
    }

    public final PlSqlToken getStartToken() {
        PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator(this.getSourceObject());
        if (pi != null) {
            return pi.getTokenAtOffset(this.getStartOffset().intValue());
        }
        return null;
    }

    public final PlSqlToken getEndToken() {
        PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator(this.getSourceObject());
        if (pi != null) {
            return pi.getTokenAtOffset(this.getEndOffset().intValue());
        }
        return null;
    }
}

