/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.sql.SQLCallable;
import oracle.javatools.db.sql.SQLCallableArgument;

public class PlSqlSubProgram
extends PlSqlBlock
implements SQLCallable {
    public static final String TYPE = "PlSqlSubProgram";

    public PlSqlSubProgram() {
        this((String)null, (DBObject)null);
    }

    public PlSqlSubProgram(String name, DBObject parent) {
        super(name, parent);
    }

    public String getType() {
        return TYPE;
    }

    public void setParameters(PlSqlParameter[] parameters) {
        this.getChildSupport("parameters").setChildArray(parameters);
    }

    public PlSqlParameter[] getParameters() {
        return this.getChildSupport("parameters").getChildArray(PlSqlParameter.class);
    }

    public void addParameter(PlSqlParameter parameter) {
        this.getChildSupport("parameters").addChild(parameter);
    }

    public void addParameter(int index, PlSqlParameter parameter) {
        this.getChildSupport("parameters").addChild(index, parameter);
    }

    public void removeParameter(PlSqlParameter parameter) {
        this.getChildSupport("parameters").removeChild(parameter);
    }

    public PlSqlParameter getParameter(String name) {
        return (PlSqlParameter)this.getChildSupport("parameters").findChild(name);
    }

    public PlSqlReference getReturnTypeReference() {
        return (PlSqlReference)this.getProperty("returnTypeReference");
    }

    public void setReturnTypeReference(PlSqlReference returnTypeRef) {
        this.setProperty("returnTypeReference", returnTypeRef);
    }

    public DBObjectID getReturnTypeID() {
        PlSqlReference ref = this.getReturnTypeReference();
        return ref == null ? null : ref.getReferenceID();
    }

    public String getSignature() {
        return this.getSignature(true);
    }

    public String getSignature(boolean names) {
        return this.getSignature(false, names);
    }

    public String getSignature(boolean showParent, boolean names) {
        String name;
        DBObject parent;
        StringBuilder sb = new StringBuilder();
        if (showParent && ((parent = this.getParent()) instanceof PlSqlSchemaObjectSpec || parent instanceof PlSqlSchemaObjectBody)) {
            sb.append(parent.getName()).append(".");
        }
        if ((name = this.getName()).indexOf("(") > 0) {
            name = name.substring(0, name.indexOf("("));
        }
        sb.append(name);
        boolean first = true;
        for (PlSqlParameter p : this.getParameters()) {
            if (first) {
                sb.append("(");
            } else {
                sb.append(",");
            }
            if (names) {
                sb.append(p.getName());
                sb.append("=>");
            }
            sb.append(this.getTypeName(p.getDataTypeReference()));
            first = false;
        }
        if (!first) {
            sb.append(")");
        }
        if (this.getReturnTypeReference() != null) {
            sb.append(":");
            sb.append(this.getTypeName(this.getReturnTypeReference()));
        }
        return sb.toString();
    }

    private String getTypeName(PlSqlReference ref) {
        if (ref != null) {
            return ref.toStringFromSource();
        }
        return null;
    }

    public final String getDeclarartion() {
        int start;
        PlSqlSubProgram sub = this;
        int end = start = sub.getStartOffset().intValue();
        if (sub.getReturnTypeReference() != null) {
            end = sub.getReturnTypeReference().getEndOffset();
        } else {
            for (PlSqlParameter p : sub.getParameters()) {
                int e = p.getDataTypeReference().getEndOffset();
                if (e <= end) continue;
                end = e;
            }
            if (end != start) {
                PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator(this.getSourceObject());
                PlSqlToken tk = pi.getTokenAtOffset(end);
                tk = tk.getNextCodeToken();
                end = tk.getEnd();
            }
        }
        return this.getSourceObject().getSource().substring(start, end + 1);
    }

    public final boolean isFunction() {
        return this.getReturnTypeReference() != null;
    }

    public final Integer getArgumentDefiningReturnType() {
        return null;
    }

    public final SQLCallableArgument[] getArguments() {
        return this.getParameters();
    }

    public final boolean isAggregate() {
        return false;
    }

    public final boolean isWindow() {
        return false;
    }

    public final boolean isParenthesesRequired() {
        return this.getParameters().length > 0;
    }

    public boolean isVariableArgumentList() {
        return false;
    }
}

