/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.refactoring.CascadeAction;

public class Trigger
extends PlSqlSchemaObject {
    public static final String TYPE = "TRIGGER";
    public static final String INSERT_EVENT = "INSERT";
    public static final String DELETE_EVENT = "DELETE";
    public static final String UPDATE_EVENT = "UPDATE";
    public static final String ALTER_EVENT = "ALTER";
    public static final String ANALYZE_EVENT = "ANALYZE";
    public static final String ASSOCIATE_STATISTICS_EVENT = "ASSOCIATE STATISTICS";
    public static final String AUDIT_EVENT = "AUDIT";
    public static final String COMMENT_EVENT = "COMMENT";
    public static final String CREATE_EVENT = "CREATE";
    public static final String DISASSOCIATE_STATISTICS_EVENT = "DISASSOCIATE STATISTICS";
    public static final String DB_ROLE_CHANGE_EVENT = "DB_ROLE_CHANGE";
    public static final String DROP_EVENT = "DROP";
    public static final String GRANT_EVENT = "GRANT";
    public static final String NOAUDIT_EVENT = "NOAUDIT";
    public static final String RENAME_EVENT = "RENAME";
    public static final String REVOKE_EVENT = "REVOKE";
    public static final String TRUNCATE_EVENT = "TRUNCATE";
    public static final String DDL_EVENT = "DDL";
    public static final String SERVERERROR_EVENT = "SERVERERROR";
    public static final String LOGON_EVENT = "LOGON";
    public static final String LOGOFF_EVENT = "LOGOFF";
    public static final String STARTUP_EVENT = "STARTUP";
    public static final String SHUTDOWN_EVENT = "SHUTDOWN";
    public static final String SUSPEND_EVENT = "SUSPEND";
    private static final List TABLE_EVENTS = Collections.unmodifiableList(Arrays.asList("INSERT", "DELETE", "UPDATE"));
    private static final List BEFORE_SCHEMA_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGOFF", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List AFTER_SCHEMA_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGON", "SERVERERROR", "SUSPEND", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List BEFORE_DB_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGOFF", "SHUTDOWN", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List AFTER_DB_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGON", "SERVERERROR", "STARTUP", "SUSPEND", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL", "DB_ROLE_CHANGE"));
    private static final List DATABASE_ONLY_EVENTS = Collections.unmodifiableList(Arrays.asList("SERVERERROR", "LOGON", "LOGOFF", "STARTUP", "SHUTDOWN", "SUSPEND"));

    public Trigger() {
        this.setEnabled(this.isEnabled());
        this.setStatementLevel(this.isStatementLevel());
    }

    public static boolean isDatabaseOnlyEvent(String event) {
        return DATABASE_ONLY_EVENTS.contains(event);
    }

    public static List getEvents(BaseType type, Timing timing) {
        List list;
        if (type == null || timing == null || timing == Timing.INSTEAD_OF && type != BaseType.VIEW) {
            list = Collections.EMPTY_LIST;
        } else {
            switch (type) {
                case TABLE: 
                case VIEW: {
                    list = TABLE_EVENTS;
                    break;
                }
                case SCHEMA: {
                    list = timing == Timing.BEFORE ? BEFORE_SCHEMA_EVENTS : AFTER_SCHEMA_EVENTS;
                    break;
                }
                case DATABASE: {
                    list = timing == Timing.BEFORE ? BEFORE_DB_EVENTS : AFTER_DB_EVENTS;
                    break;
                }
                default: {
                    list = Collections.EMPTY_LIST;
                }
            }
        }
        return list;
    }

    public String getType() {
        return TYPE;
    }

    public boolean isEnabled() {
        return (Boolean)this.getProperty("enabled", true);
    }

    public void setEnabled(boolean enabled) {
        this.setProperty("enabled", enabled);
    }

    @Derived(value="source")
    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public Timing getTiming() {
        return (Timing)((Object)this.getProperty("timing"));
    }

    public void setTiming(Timing timing) {
        this.setProperty("timing", (Object)timing);
    }

    @Derived(value="source")
    public boolean isStatementLevel() {
        return (Boolean)this.getProperty("statementLevel", true);
    }

    public void setStatementLevel(boolean statementLevel) {
        this.setProperty("statementLevel", statementLevel);
    }

    @Derived(value="source")
    public String[] getEvents() {
        return this.getChildSupport("events").getChildArray(String.class);
    }

    public void setEvents(String[] events) {
        this.getChildSupport("events").setChildArray(events);
    }

    @Derived(value="source")
    @References(value=SystemObject.class, cascade=CascadeAction.DELETE, types={"SCHEMA", "TABLE", "VIEW"})
    public DBObjectID getBaseObjectID() {
        return (DBObjectID)this.getProperty("baseObjectID");
    }

    public void setBaseObjectID(DBObjectID baseObjectID) {
        this.setProperty("baseObjectID", baseObjectID);
    }

    @Transient
    @Deprecated
    public String getBaseSchemaName() {
        DBObjectID baseObjectID = this.getBaseObjectID();
        String retval = null;
        if (baseObjectID != null) {
            try {
                DBObject o = baseObjectID.resolveID();
                if (o instanceof Schema) {
                    retval = o.getName();
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger(this).warning(dbe.getMessage());
            }
        }
        return retval;
    }

    @Transient
    @Deprecated
    public void setBaseSchemaName(String baseSchemaName) {
        if (baseSchemaName != null) {
            throw new UnsupportedOperationException();
        }
    }

    @Deprecated
    public DBObjectID getTableID() {
        return this.getBaseObjectID();
    }

    @Deprecated
    public void setTableID(DBObjectID tableID) {
        this.setBaseObjectID(tableID);
    }

    @Derived(value="source")
    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public BaseType getBaseType() {
        return (BaseType)((Object)this.getProperty("baseType"));
    }

    public void setBaseType(BaseType baseType) {
        this.setProperty("baseType", (Object)baseType);
    }

    @Derived(value="source")
    public String getWhenClause() {
        return (String)this.getProperty("whenClause");
    }

    public void setWhenClause(String whenClause) {
        this.setProperty("whenClause", whenClause);
    }

    @Derived(value="source")
    @References(value=Column.class, cascade=CascadeAction.UPDATE)
    public DBObjectID[] getColumnIDs() {
        return this.getChildSupport("columnIDs").getChildArray(DBObjectID.class);
    }

    public void setColumnIDs(DBObjectID[] columnIDs) {
        this.getChildSupport("columnIDs").setChildArray(columnIDs);
    }

    @Derived(value="source")
    @TextProperty(multiLine=true)
    public String getCode() {
        return (String)this.getProperty("code");
    }

    public void setCode(String code) {
        this.setProperty("code", code);
    }

    public void setReferencingNewAs(String refNewAs) {
        this.setProperty("referencingNewAs", refNewAs);
    }

    @Derived(value="source")
    @TextProperty(internalName=true)
    public String getReferencingNewAs() {
        return (String)this.getProperty("referencingNewAs");
    }

    public void setReferencingOldAs(String refOldAs) {
        this.setProperty("referencingOldAs", refOldAs);
    }

    @Derived(value="source")
    @TextProperty(internalName=true)
    public String getReferencingOldAs() {
        return (String)this.getProperty("referencingOldAs");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaseType {
        TABLE,
        VIEW,
        SCHEMA,
        DATABASE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Timing {
        BEFORE,
        AFTER,
        INSTEAD_OF;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

