/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DerivedPropertyBuilder<T extends AbstractBuildableObject>
extends AbstractDBObjectBuilder<T> {
    private DerivedPropertyBuilder<T> m_tempCopySourceBuilder;

    public DerivedPropertyBuilder(AbstractDBObjectProvider pro, String type) {
        super(pro, type);
        if (Metadata.getInstance().getObjectClass(type) == null) {
            throw new IllegalArgumentException(type + "is not a valid DBObject type");
        }
    }

    public Collection<String> clearDerivedProperties(T obj, DBObjectChange change) {
        ArrayList<String> retval = new ArrayList<String>();
        for (String prop : change.getAllChangedProperties()) {
            Collection<String> clearedProps = this.clearDerivedProperties(obj, prop, change);
            if (clearedProps == null) continue;
            retval.addAll(clearedProps);
        }
        return retval;
    }

    public Collection<String> clearDerivedProperties(T obj, String property, DBObjectChange change) {
        ArrayList<String> retval = null;
        Collection<String> derivedProps = this.getDerivedProperties(property);
        if (derivedProps != null) {
            retval = new ArrayList<String>();
            Collection<String> allProps = change.getAllChangedProperties();
            for (String derivedProp : derivedProps) {
                if (allProps.contains(derivedProp)) continue;
                retval.add(derivedProp);
                ((AbstractDBObject)obj).setProperty(derivedProp, null);
            }
        }
        return retval;
    }

    @Override
    protected final boolean canBuildComponents() {
        return true;
    }

    @Override
    public final T createObject(String name, Schema schema, DBObjectID id) {
        return null;
    }

    @Override
    public void cancelCurrentBuild(T object) {
        super.cancelCurrentBuild(object);
        DerivedPropertyBuilder<T> other = this.m_tempCopySourceBuilder;
        if (other != null) {
            AbstractBuildableObject orig = (AbstractBuildableObject)TemporaryObjectID.findOriginalObject(object);
            other.cancelCurrentBuild(orig == null ? object : orig);
        }
    }

    @Override
    protected void registerObject(T object) throws DBException {
        if (((AbstractDBObject)object).getID() instanceof BaseObjectID) {
            this.getProvider().getObjectFactory().ensureID((DBObject)object, true, false);
            SystemObject sysObj = DBUtil.getSystemObject(object);
            if (sysObj != null) {
                this.getProvider().getCascadeManager().registerObject(sysObj, true);
            }
        } else {
            this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)object);
        }
    }

    @Override
    protected boolean fillInObjectComponentImpl(T object, String prop) throws DBException {
        AbstractBuildableObject orig = (AbstractBuildableObject)TemporaryObjectID.findOriginalObject(object);
        if (orig instanceof AbstractBuildableObject) {
            this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder(orig);
            String sourceProp = this.getDerivedPropertySource(prop);
            if (sourceProp != null) {
                Object origSourcePropValue = orig.getProperty(sourceProp);
                Object updSourcePropValue = ((AbstractDBObject)object).getProperty(sourceProp);
                if (!(updSourcePropValue instanceof DBObject) && origSourcePropValue != null && updSourcePropValue != null && ModelUtil.areEqual((Object)origSourcePropValue, (Object)updSourcePropValue)) {
                    this.derivePropertiesForTempCopy(object, orig, sourceProp);
                    return true;
                }
            }
        }
        return super.fillInObjectComponentImpl(object, prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void derivePropertiesForTempCopy(T object, T orig, String sourceProp) throws DBException {
        TemporaryObjectID.TemporaryIDPolicy tidp = new TemporaryObjectID.TemporaryIDPolicy();
        this.checkInterruptOrCancel(object);
        Collection<String> dprops = this.getDerivedProperties(sourceProp);
        if (dprops != null) {
            try {
                this.m_tempCopySourceBuilder = this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)orig);
                DBUtil.ensureObjectBuilt(orig, dprops.toArray(new String[dprops.size()]));
                Object var7_6 = null;
                this.m_tempCopySourceBuilder = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.m_tempCopySourceBuilder = null;
                throw throwable;
            }
        }
        this.checkInterruptOrCancel(object);
        for (String dprop : dprops) {
            Object origVal = ((AbstractDBObject)orig).getProperty(dprop);
            this.checkInterruptOrCancel(object);
            Object newVal = DBUtil.copyPropertyValue(origVal, orig, object, tidp);
            ((AbstractDBObject)object).setProperty(dprop, newVal);
        }
        this.replaceReferenceIDs(object, tidp.getIDMap());
    }
}

