/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.property.MetadataImpl;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.deferred.Thunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Metadata {
    private MetadataImpl m_impl;
    private MultiMap<Class<? extends DBObject>, Class<? extends DBObject>> m_ownerMap;
    private Map<String, Thunk<Class<? extends DBObject>>> m_extendedTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata getInstance() {
        DBCore core = DBCore.getInstance();
        Class<Metadata> clazz = Metadata.class;
        synchronized (Metadata.class) {
            Metadata m = core.get(Metadata.class);
            if (m == null) {
                m = new Metadata();
                core.put(m);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m;
        }
    }

    private Metadata() {
    }

    private synchronized MetadataImpl getMetadata() {
        if (this.m_impl == null) {
            this.m_impl = new MetadataImpl();
        }
        return this.m_impl;
    }

    public Map<String, Class<? extends DBObject>> getDBObjectClasses() {
        return Collections.unmodifiableMap(this.getMetadata().getTypeMap());
    }

    public boolean isSchemaObject(String type) {
        return this.isTypeOf(SchemaObject.class, type);
    }

    public boolean isTypeOf(Class<? extends DBObject> clz, String type) {
        Class<? extends DBObject> typeClz;
        this.checkLoaded(type);
        boolean retval = false;
        if (type != null && (typeClz = this.getMetadata().getTypeMap().get(type)) != null) {
            retval = clz.isAssignableFrom(typeClz);
        }
        return retval;
    }

    public DBObject newDBObject(String type, String name) {
        Class<? extends DBObject> clz = this.getObjectClass(type);
        if (clz != null) {
            try {
                DBObject obj = clz.newInstance();
                obj.setName(name);
                return obj;
            }
            catch (Exception e) {
                DBLog.getLogger(this).log(Level.FINE, "Couldn't create new " + type, e);
            }
        }
        return null;
    }

    public Class<? extends DBObject> getObjectClass(String type) {
        Class<? extends DBObject> retval = null;
        if (type != null) {
            this.checkLoaded(type);
            retval = this.getMetadata().getTypeMap().get(type);
        }
        return retval;
    }

    private synchronized void checkLoaded(String type) {
        Class clz;
        Thunk<Class<? extends DBObject>> thunk;
        if (this.m_extendedTypes != null && type != null && (thunk = this.m_extendedTypes.remove(type)) != null && (clz = (Class)thunk.get()) != null) {
            this.registerObjectClass(type, clz);
        }
    }

    private void checkLoaded(Class<? extends Copyable> clz) {
        if (DBObject.class.isAssignableFrom(clz)) {
            String type = Metadata.getType(clz);
            this.checkLoaded(type);
        }
    }

    public synchronized void registerObjectClass(String type, Thunk<Class<? extends DBObject>> clzThunk) {
        if (this.m_extendedTypes == null) {
            this.m_extendedTypes = new HashMap<String, Thunk<Class<? extends DBObject>>>();
        }
        this.m_extendedTypes.put(type, clzThunk);
    }

    public synchronized void registerObjectClass(String type, Class<? extends DBObject> clz) {
        Class<? extends DBObject> exists = this.getObjectClass(type);
        if (exists == null) {
            this.getMetadata().registerClass(clz);
        } else if (exists != clz) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot register class {0}: type {1} is registered as class {2}", clz.getName(), type, exists.getName()));
        }
    }

    public Collection<String> getAllTypes(Class<? extends DBObject> clz) {
        Collection<Class<? extends DBObject>> impls;
        HashSet<String> types = new HashSet<String>();
        String clzType = Metadata.getType(clz);
        if (clzType != null) {
            types.add(clzType);
            this.checkLoaded(clzType);
        }
        if ((impls = this.getMetadata().getImplementations(clz)) != null) {
            for (Class<? extends DBObject> implclz : impls) {
                String type = Metadata.getType(implclz);
                if (type == null) continue;
                types.add(type);
            }
        }
        return types;
    }

    public DBObject newInstance(String type) {
        Class<? extends DBObject> clz = this.getObjectClass(type);
        if (clz != null) {
            if (Constraint.class.equals(clz)) {
                clz = UniqueConstraint.class;
            }
            try {
                return clz.newInstance();
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.FINE, "Error instantiating new DBObject", e);
            }
        }
        return null;
    }

    public Collection<String> getSupportedProperties(Class<? extends Copyable> objClz, Class<? extends DBObjectProvider> proClz) {
        return this.getSupportedProperties(objClz, proClz, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getSupportedProperties(Class<? extends Copyable> objClz, Class<? extends DBObjectProvider> proClz, boolean incBean, boolean incExtra) {
        Collection<String> beanProps;
        HashSet<String> retval = new HashSet<String>();
        this.checkLoaded(objClz);
        if (incBean && (beanProps = MetadataImpl.getProperties(objClz)) != null) {
            retval.addAll(beanProps);
        }
        if (incExtra && DBObject.class.isAssignableFrom(objClz)) {
            Map<String, Collection<PropertyInfo>> allExtraProps;
            Map<String, Collection<PropertyInfo>> map = allExtraProps = this.getMetadata().getExtraProps();
            synchronized (map) {
                for (Map.Entry<String, Collection<PropertyInfo>> entry : allExtraProps.entrySet()) {
                    for (PropertyInfo propDef : entry.getValue()) {
                        if (!propDef.isSupported(proClz, objClz)) continue;
                        retval.add(entry.getKey());
                    }
                }
            }
        }
        for (Class<? extends DBObject> implClz : this.getDefaultImplClasses(objClz)) {
            retval.addAll(this.getSupportedProperties(implClz, proClz, incBean, incExtra));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, PropertyInfo> getSupportedPropertiesMap(Class<? extends Copyable> objClz, Class<? extends DBObjectProvider> proClz, boolean incBean, boolean incExtra) {
        BeanInfo bi;
        HashMap<String, PropertyInfo> retval = new HashMap<String, PropertyInfo>();
        this.checkLoaded(objClz);
        if (incBean && (bi = MetadataImpl.getBeanInfo(objClz)) != null) {
            for (PropertyDescriptor desc : bi.getPropertyDescriptors()) {
                if (this.weDoNotLike(desc, objClz)) continue;
                retval.put(desc.getName(), PropertyInfo.createPropertyInfo(desc));
            }
        }
        if (incExtra && DBObject.class.isAssignableFrom(objClz)) {
            Map<String, Collection<PropertyInfo>> allExtraProps;
            Map<String, Collection<PropertyInfo>> map = allExtraProps = this.getMetadata().getExtraProps();
            synchronized (map) {
                for (Map.Entry<String, Collection<PropertyInfo>> entry : allExtraProps.entrySet()) {
                    for (PropertyInfo propDef : entry.getValue()) {
                        if (!propDef.isSupported(proClz, objClz)) continue;
                        retval.put(entry.getKey(), propDef);
                    }
                }
            }
        }
        for (Class<? extends DBObject> clazz : this.getDefaultImplClasses(objClz)) {
            retval.putAll(this.getSupportedPropertiesMap(clazz, proClz, incBean, incExtra));
        }
        return retval;
    }

    private boolean weDoNotLike(PropertyDescriptor desc, Class objClz) {
        boolean retval = false;
        if ("parent".equals(desc.getName()) && !DBObjectID.class.isAssignableFrom(objClz)) {
            retval = true;
        } else if (desc.getReadMethod() == null || desc.getWriteMethod() == null) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertyInfo getSupportedProperty(Class<? extends Copyable> objClz, String propName, Class<? extends DBObjectProvider> proClz) {
        PropertyInfo retval;
        block9: {
            Class<? extends DBObject> clazz;
            BeanInfo info;
            retval = null;
            Collection<String> beanProps = MetadataImpl.getProperties(objClz);
            if (beanProps != null && beanProps.contains(propName) && (info = MetadataImpl.getBeanInfo(objClz)) != null) {
                for (PropertyDescriptor desc : info.getPropertyDescriptors()) {
                    if (!desc.getName().equals(propName)) continue;
                    if (this.weDoNotLike(desc, objClz)) break;
                    retval = PropertyInfo.createPropertyInfo(desc);
                    break;
                }
            }
            if (retval == null && DBObject.class.isAssignableFrom(objClz)) {
                Map<String, Collection<PropertyInfo>> allExtraProps;
                Map<String, Collection<PropertyInfo>> map = allExtraProps = this.getMetadata().getExtraProps();
                synchronized (map) {
                    Collection<PropertyInfo> extraProps = allExtraProps.get(propName);
                    if (extraProps != null) {
                        for (PropertyInfo extraProp : extraProps) {
                            if (extraProp == null || !extraProp.isSupported(proClz, objClz)) continue;
                            retval = extraProp;
                            break;
                        }
                    }
                }
            }
            if (retval != null) break block9;
            Iterator<Class<? extends DBObject>> i$ = this.getDefaultImplClasses(objClz).iterator();
            while (i$.hasNext() && (retval = this.getSupportedProperty(clazz = i$.next(), propName, proClz)) == null) {
            }
        }
        return retval;
    }

    private Iterable<Class<? extends DBObject>> getDefaultImplClasses(Class objClz) {
        List<Class<? extends DBObject>> retval;
        if (DBObject.class.isAssignableFrom(objClz)) {
            Collection<Class<? extends DBObject>> impls;
            retval = new ArrayList();
            String type = Metadata.getType(objClz);
            if (Modifier.isAbstract(objClz.getModifiers()) && (impls = this.getMetadata().getImplementations(objClz)) != null) {
                for (Class<? extends DBObject> implClz : impls) {
                    String implType = Metadata.getType(implClz);
                    if (implClz == objClz || implType == null || type != null && !ModelUtil.areEqual((Object)implType, (Object)type)) continue;
                    retval.add(implClz);
                }
            }
        } else {
            retval = Collections.emptyList();
        }
        return retval;
    }

    public void registerProperty(String name, Class returnType, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        PropertyDefinition prop = new PropertyDefinition(name, returnType, providerType, objectTypes);
        this.registerProperty(prop);
    }

    public void registerBooleanProperty(String name, Nullable.NullBehaviour nullBehaviour, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        PropertyDefinition prop = new PropertyDefinition(name, Boolean.class, providerType, objectTypes);
        prop.setNullBehaviour(nullBehaviour);
        this.registerProperty(prop);
    }

    public void registerStringProperty(String name, boolean isMultiLine, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        PropertyDefinition prop = new PropertyDefinition(name, String.class, providerType, objectTypes);
        prop.setTextPropertyInfo(isMultiLine, false, false);
        this.registerProperty(prop);
    }

    public void registerIDProperty(String name, boolean staticReference, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        this.registerIDProperty(name, staticReference, (Class<? extends DBObject>)null, (String[])null, providerType, objectTypes);
    }

    public void registerIDProperty(String name, boolean staticReference, Class<? extends DBObject> referencedClass, String[] referencedTypes, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        if (referencedClass == null) {
            referencedClass = DBObject.class;
        }
        PropertyDefinition prop = new PropertyDefinition(name, DBObjectID.class, providerType, objectTypes);
        prop.setReferencesInfo(staticReference, referencedClass, referencedTypes);
        this.registerProperty(prop);
    }

    public void registerProperty(PropertyInfo info) {
        if (info != null) {
            String name = info.getPropertyName();
            if (!ModelUtil.hasLength((String)name)) {
                throw new IllegalArgumentException("Property must have a valid name");
            }
            this.getMetadata().registerExtraProperty(info);
        }
    }

    public void registerProperties(Iterable<? extends PropertyInfo> infos) {
        if (infos != null) {
            this.getMetadata().registerExtraProperties(infos);
        }
    }

    public boolean isStaticReferenceProperty(String propName) {
        boolean retval = false;
        Map<String, Collection<PropertyInfo>> allExtraProps = this.getMetadata().getExtraProps();
        Collection<PropertyInfo> infos = allExtraProps.get(propName);
        if (infos != null) {
            for (PropertyInfo info : infos) {
                if (!info.isStaticReference()) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    public boolean isBeanProperty(Class<? extends DBObject> clz, String propName) {
        Collection<String> props = MetadataImpl.getProperties(clz);
        return props != null && props.contains(propName);
    }

    public Collection<String> getOwnerTypes(String childType) {
        this.checkLoaded(childType);
        Class<? extends DBObject> childClz = this.getObjectClass(childType);
        Collection<Class<? extends DBObject>> clzs = this.getOwnerClasses(childClz);
        TreeSet<String> retval = new TreeSet<String>();
        for (Class<? extends DBObject> ownerClz : clzs) {
            retval.add(Metadata.getType(ownerClz));
        }
        return retval;
    }

    public Collection<Class<? extends DBObject>> getOwnerClasses(Class<? extends DBObject> childClz) {
        if (this.m_ownerMap == null) {
            this.m_ownerMap = new MultiMap();
        }
        ArrayList<Class<? extends DBObject>> retval = new ArrayList<Class<? extends DBObject>>();
        Collection cached = this.m_ownerMap.get(childClz);
        if (cached == null) {
            if (childClz != null) {
                for (Class<? extends Copyable> beanClz : this.getMetadata().getBeans()) {
                    boolean found;
                    if (!DBObject.class.isAssignableFrom(beanClz) || !Metadata.isRealBean(beanClz) || !(found = this.containsOwnerProperty(childClz, this.getSupportedPropertiesMap(beanClz, null, true, false)) || this.containsOwnerProperty(childClz, this.getSupportedPropertiesMap(beanClz, null, false, true)))) continue;
                    retval.add(beanClz);
                    this.m_ownerMap.add(childClz, beanClz);
                }
            }
        } else {
            retval.addAll(cached);
        }
        return retval;
    }

    private boolean containsOwnerProperty(Class<? extends DBObject> childClz, Map<String, PropertyInfo> props) {
        boolean retval = false;
        for (PropertyInfo info : props.values()) {
            if (!childClz.isAssignableFrom(DBUtil.decodeArrayClass(info.getPropertyClass())) || info.isTransient()) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public static boolean isRealBean(Class<? extends Copyable> clz) {
        int m;
        return clz != null && Modifier.isPublic(m = clz.getModifiers()) && !Modifier.isAbstract(m) && !clz.isInterface();
    }

    public static String getType(Class<? extends DBObject> objClass) {
        String retval = null;
        if (objClass != null) {
            try {
                Field f = objClass.getField("TYPE");
                if (f != null) {
                    retval = (String)f.get(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }
}

