/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MetadataGenerator;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataImpl {
    static final String LIST_FILE_NAME = "beans.bin";
    private final Collection<Class<? extends Copyable>> m_beans = new ArrayList<Class<? extends Copyable>>();
    private boolean m_beansFileLoaded;
    private final MultiMap<String, PropertyInfo> m_extraProps = new MultiMap();
    private Collection<Iterable<? extends PropertyInfo>> m_lazyExtraProps = new ArrayList<Iterable<? extends PropertyInfo>>();
    private boolean m_extraPropsLoaded;
    private Map<String, Class<? extends DBObject>> m_typeMap;
    private MultiMap<Class<? extends DBObject>, Class<? extends DBObject>> m_implementations;

    MetadataImpl() {
    }

    private void loadBeansFromFile() {
        Class[] beans = null;
        long start = System.currentTimeMillis();
        Object obj = this.openFile(LIST_FILE_NAME);
        if (obj instanceof Class[]) {
            beans = (Class[])obj;
        }
        if (beans == null) {
            MetadataImpl.getLogger().severe("Could not open DBObject list file.");
            beans = new Class[]{};
        }
        for (Class clz : beans) {
            this.m_beans.add(clz);
        }
        this.timeStop(start, "Reading DBObject list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object openFile(String fileName) {
        is = DBCore.getImplClassLoader().getResourceAsStream("oracle/javatools/db/property/" + fileName);
        if (is == null) return null;
        try {
            try {
                block11: {
                    ois = null;
                    try {
                        ois = new ObjectInputStream(is);
                        var4_5 = ois.readObject();
                        var6_6 = null;
                        if (ois == null) break block11;
                    }
                    catch (Throwable var5_14) {
                        var6_7 = null;
                        if (ois == null) throw var5_14;
                        ois.close();
                        throw var5_14;
                    }
                    ois.close();
                }
                var8_8 = null;
            }
            catch (Throwable t) {
                MetadataImpl.getLogger().log(Level.SEVERE, "Error opening " + fileName, t);
                var8_9 = null;
                try {
                    is.close();
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        catch (Throwable var7_15) {
            var8_10 = null;
            ** try [egrp 3[TRYBLOCK] [7 : 122->129)] { 
lbl38:
            // 1 sources

            is.close();
            throw var7_15;
lbl40:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            throw var7_15;
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return var4_5;
        }
        is.close();
        return var4_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Class<? extends Copyable>> getBeans() {
        Collection<Class<? extends Copyable>> collection = this.m_beans;
        synchronized (collection) {
            if (!this.m_beansFileLoaded) {
                this.loadBeansFromFile();
                this.m_beansFileLoaded = true;
            }
        }
        return this.m_beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerExtraProperty(PropertyInfo info) {
        if (info instanceof PropertyDefinition) {
            info = ((PropertyDefinition)info).clone();
        }
        MultiMap<String, PropertyInfo> multiMap = this.m_extraProps;
        synchronized (multiMap) {
            this.m_extraProps.add((Object)info.getPropertyName(), (Object)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerExtraProperties(Iterable<? extends PropertyInfo> infos) {
        MultiMap<String, PropertyInfo> multiMap = this.m_extraProps;
        synchronized (multiMap) {
            if (this.m_extraPropsLoaded) {
                for (PropertyInfo propertyInfo : infos) {
                    this.registerExtraProperty(propertyInfo);
                }
            } else {
                this.m_lazyExtraProps.add(infos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Collection<PropertyInfo>> getExtraProps() {
        MultiMap<String, PropertyInfo> multiMap = this.m_extraProps;
        synchronized (multiMap) {
            if (!this.m_extraPropsLoaded) {
                long start = System.currentTimeMillis();
                for (Class<? extends Copyable> clazz : this.getBeans()) {
                    try {
                        MetadataGenerator.findExtendedProperties(clazz, this.m_extraProps);
                    }
                    catch (Exception e) {
                        MetadataImpl.getLogger().log(Level.SEVERE, "Couldn't load properties for {0}: {1}", new Object[]{clazz.getSimpleName(), e.getMessage()});
                    }
                }
                for (Iterable iterable : this.m_lazyExtraProps) {
                    for (PropertyInfo info : iterable) {
                        this.registerExtraProperty(info);
                    }
                }
                this.m_lazyExtraProps.clear();
                this.timeStop(start, "Reading extra properties");
                this.m_extraPropsLoaded = true;
            }
        }
        return this.m_extraProps;
    }

    public Map<String, Class<? extends DBObject>> getTypeMap() {
        this.initProps();
        return this.m_typeMap;
    }

    public Collection<Class<? extends DBObject>> getImplementations(Class<? extends DBObject> clz) {
        this.initProps();
        return this.m_implementations.get(clz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProps() {
        Collection<Class<? extends Copyable>> collection = this.m_beans;
        synchronized (collection) {
            if (this.m_typeMap == null) {
                long start = System.currentTimeMillis();
                this.m_typeMap = new TreeMap<String, Class<? extends DBObject>>();
                this.m_implementations = new MultiMap(HashSet.class);
                for (Class<? extends Copyable> clz : this.getBeans()) {
                    this.registerClassProperties(clz);
                }
                this.timeStop(start, "Registering all properties");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerClass(Class<? extends Copyable> clz) {
        Collection<Class<? extends Copyable>> collection = this.m_beans;
        synchronized (collection) {
            this.m_beans.add(clz);
            if (this.m_typeMap != null) {
                this.registerClassProperties(clz);
            }
        }
    }

    private void registerClassProperties(Class<? extends Copyable> clz) {
        if (DBObject.class.isAssignableFrom(clz)) {
            String type;
            String declaredType = null;
            if (DataType.class.equals(clz)) {
                type = null;
                declaredType = null;
            } else if (PredefinedDataType.class.equals(clz)) {
                type = "DATATYPE";
                declaredType = "DATATYPE";
            } else {
                type = Metadata.getType(clz);
                try {
                    Field f = clz.getDeclaredField("TYPE");
                    if (f != null) {
                        declaredType = (String)f.get(null);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (ModelUtil.hasLength(type)) {
                if (ModelUtil.hasLength((String)declaredType)) {
                    if (this.m_typeMap.containsKey(type)) {
                        DBLog.getLogger(this).log(Level.WARNING, "Type \"{0}\" is already registered to \"{1}\"", new Object[]{type, this.m_typeMap.get(type)});
                    } else {
                        this.m_typeMap.put(type, clz);
                    }
                } else {
                    DBLog.getLogger(this).log(Level.FINE, "Type \"{0}\" is not declared on {1}", new Object[]{type, clz});
                }
            }
            for (Class<? extends Copyable> bean : this.getBeans()) {
                if (!bean.isAssignableFrom(clz) || !DBObject.class.isAssignableFrom(bean)) continue;
                this.m_implementations.add(bean, clz);
            }
        }
        if (!Metadata.isRealBean(clz) && DBObject.class.isAssignableFrom(clz)) {
            for (Class<? extends Copyable> bean : this.getBeans()) {
                if (clz == bean || !clz.isAssignableFrom(bean)) continue;
                this.m_implementations.add(clz, bean);
            }
        }
    }

    private void timeStop(long start, String msg) {
        long stop = System.currentTimeMillis();
        MetadataImpl.getLogger().log(Level.FINE, msg + " took {0}ms", stop - start);
    }

    private static Logger getLogger() {
        return DBLog.getLogger(MetadataImpl.class);
    }

    static BeanInfo getBeanInfo(Class beanClass) {
        if (beanClass != null && !beanClass.isPrimitive() && beanClass != String.class) {
            try {
                return Introspector.getBeanInfo(beanClass);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static Collection<String> getProperties(Class<? extends Copyable> clz) {
        TreeSet<String> retval = new TreeSet<String>();
        BeanInfo bi = MetadataImpl.getBeanInfo(clz);
        if (bi == null) {
            MetadataImpl.getLogger().severe("Error getting bean info for: " + clz.getName());
        } else {
            for (PropertyDescriptor desc : bi.getPropertyDescriptors()) {
                if (!MetadataImpl.isValidForPropertyInfo(desc)) continue;
                String name = desc.getName();
                retval.add(name);
            }
        }
        return retval;
    }

    static boolean isValidForPropertyInfo(PropertyDescriptor desc) {
        Method mr = desc.getReadMethod();
        Method mw = desc.getWriteMethod();
        return mr != null && mw != null;
    }
}

