/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAction {
    private Collection<String> m_props;
    private Collection<ChildAction> m_childActions;
    private final Type m_type;

    public PropertyAction(Type type) {
        this(type, null);
    }

    public PropertyAction(Type type, Collection<ChildAction> childActions) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (!Type.ALTER.equals((Object)type) && childActions != null && !childActions.isEmpty()) {
            throw new IllegalArgumentException("childActions can only be specified for ALTER");
        }
        this.m_type = type;
        this.m_childActions = childActions;
    }

    public Type getType() {
        return this.m_type;
    }

    public Collection<String> getProperties() {
        return this.m_props == null ? Collections.emptyList() : this.m_props;
    }

    void addProperty(String propPath) {
        if (this.m_props == null) {
            this.m_props = new TreeSet<String>();
        }
        this.m_props.add(propPath);
    }

    public boolean supportsChildAction(ChildAction action) {
        return this.m_childActions != null && this.m_childActions.contains((Object)action);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChildAction {
        ADD,
        REMOVE,
        MODIFY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CREATE,
        ALTER,
        REPLACE,
        DELETE,
        UNDELETE;

    }
}

