/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDefinition
extends PropertyInfo {
    private final String m_name;
    private final Class m_returnType;
    private final Class<? extends DBObjectProvider> m_providerType;
    private final Collection<Class<? extends DBObject>> m_objTypes;
    private boolean m_staticReference;
    private Class m_referencedClass;
    private String[] m_referencedTypes;
    private boolean m_multiLine;
    private boolean m_password;
    private boolean m_internalName;
    private boolean m_physicalSize;
    private boolean m_unlimited;
    private Nullable.NullBehaviour m_nullBehaviour;

    public PropertyDefinition(String name, Class returnType, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objTypes) {
        this.m_name = name;
        if (!ModelUtil.hasLength((String)this.m_name)) {
            throw new IllegalArgumentException("Every property must have a name.");
        }
        this.m_returnType = returnType;
        if (this.m_returnType == null) {
            throw new IllegalArgumentException("Every property must have a return type.");
        }
        this.m_providerType = providerType;
        this.m_objTypes = new HashSet<Class<? extends DBObject>>();
        if (objTypes != null) {
            for (Class<? extends DBObject> clz : objTypes) {
                if (clz == null) continue;
                this.m_objTypes.add(clz);
            }
        }
        if (this.m_objTypes.size() == 0) {
            this.m_objTypes.add(DBObject.class);
        }
    }

    @Override
    public String getPropertyName() {
        return this.m_name;
    }

    @Override
    public Class getPropertyClass() {
        return this.m_returnType;
    }

    @Override
    protected Collection<Class<? extends DBObject>> getObjectClasses() {
        return this.m_objTypes;
    }

    @Override
    protected Class<? extends DBObjectProvider> getProviderClass() {
        return this.m_providerType;
    }

    @Override
    protected boolean equalsImpl(PropertyInfo other) {
        return other instanceof PropertyDefinition ? this.equalsImpl((PropertyDefinition)other) : false;
    }

    protected boolean equalsImpl(PropertyDefinition other) {
        return ModelUtil.areEqual((Object)other.m_name, (Object)this.m_name) && ModelUtil.areEqual((Object)other.m_returnType, (Object)this.m_returnType) && ModelUtil.areEqual(other.m_providerType, this.m_providerType) && ModelUtil.areEqual(other.m_objTypes, this.m_objTypes);
    }

    public PropertyDefinition clone() {
        PropertyDefinition retval = new PropertyDefinition(this.m_name, this.m_returnType, this.m_providerType, this.m_objTypes.toArray(new Class[this.m_objTypes.size()]));
        retval.m_staticReference = this.m_staticReference;
        retval.m_referencedClass = this.m_referencedClass;
        retval.m_referencedTypes = this.m_referencedTypes;
        retval.m_multiLine = this.m_multiLine;
        retval.m_password = this.m_password;
        retval.m_internalName = this.m_internalName;
        retval.m_physicalSize = this.m_physicalSize;
        retval.m_unlimited = this.m_unlimited;
        retval.m_nullBehaviour = this.m_nullBehaviour;
        return retval;
    }

    public String toString() {
        return this.m_name + "(" + this.m_returnType.getName() + ")";
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public void setReferencesInfo(boolean isStatic, Class referencedClass, String ... referencedTypes) {
        this.m_staticReference = isStatic;
        this.m_referencedClass = referencedClass;
        this.m_referencedTypes = referencedTypes;
    }

    @Override
    public boolean isStaticReference() {
        return this.m_staticReference;
    }

    @Override
    public Class getReferencedClass() {
        return this.m_referencedClass;
    }

    @Override
    public String[] getReferencedTypes() {
        return this.m_referencedTypes;
    }

    public void setTextPropertyInfo(boolean multiLine, boolean password, boolean internalName) {
        this.m_multiLine = multiLine;
        this.m_password = password;
        this.m_internalName = internalName;
    }

    @Override
    public boolean isTextMultiLine() {
        return this.m_multiLine;
    }

    @Override
    public boolean isTextPassword() {
        return this.m_password;
    }

    @Override
    public boolean isTextInternalName() {
        return this.m_internalName;
    }

    public void setNumberPropertyInfo(boolean unlimited, boolean physicalSize) {
        this.m_unlimited = unlimited;
        this.m_physicalSize = physicalSize;
    }

    @Override
    public boolean isNumberUnlimited() {
        return this.m_unlimited;
    }

    @Override
    public boolean isNumberPhysicalSize() {
        return this.m_physicalSize;
    }

    public void setNullBehaviour(Nullable.NullBehaviour nullBehaviour) {
        this.m_nullBehaviour = nullBehaviour;
    }

    @Override
    public Nullable.NullBehaviour getNullBehaviour() {
        return this.m_nullBehaviour == null ? super.getNullBehaviour() : this.m_nullBehaviour;
    }
}

