/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyIterator {
    private Class m_objClass;
    private Class<? extends DBObjectProvider> m_proClass;
    private Map<String, PropertyInfo> m_beanProps;
    private Map<String, PropertyInfo> m_extraProps;

    public PropertyIterator(Class objClass, Class<? extends DBObjectProvider> proClass) {
        if (objClass == null) {
            throw new IllegalArgumentException("object class cannot be null");
        }
        this.m_objClass = objClass;
        this.m_proClass = proClass;
    }

    public Iterator<PropertyInfo> getPropertyIterator() {
        return this.getPropertyIterator(true, true, true);
    }

    public Iterator<PropertyInfo> getPropertyIterator(boolean excludeTransientGet, boolean excludeTransientSet, boolean beanOnly) {
        Map<String, PropertyInfo> infos = this.getPropertyInfos(excludeTransientGet, excludeTransientSet, beanOnly);
        TreeSet<PropertyInfo> propertyDescs = new TreeSet<PropertyInfo>();
        if (infos != null) {
            propertyDescs.addAll(infos.values());
        }
        return propertyDescs.iterator();
    }

    public Map<String, PropertyInfo> getPropertyInfos() {
        return this.getPropertyInfos(true, true, true);
    }

    public Map<String, PropertyInfo> getPropertyInfos(boolean excludeTransientGet, boolean excludeTransientSet, boolean beanOnly) {
        HashMap<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
        for (Map.Entry<String, PropertyInfo> entry : this.getBeanProps().entrySet()) {
            PropertyInfo info = entry.getValue();
            if (excludeTransientGet && info.isGetTransient() || excludeTransientSet && info.isSetTransient()) continue;
            props.put(entry.getKey(), info);
        }
        if (!beanOnly) {
            props.putAll(this.getExtraProps());
        }
        return props;
    }

    private Map<String, PropertyInfo> getBeanProps() {
        if (this.m_beanProps == null) {
            this.m_beanProps = Metadata.getInstance().getSupportedPropertiesMap(this.m_objClass, this.m_proClass, true, false);
        }
        return this.m_beanProps;
    }

    private Map<String, PropertyInfo> getExtraProps() {
        if (this.m_extraProps == null) {
            this.m_extraProps = DBObject.class.isAssignableFrom(this.m_objClass) ? Metadata.getInstance().getSupportedPropertiesMap(this.m_objClass, this.m_proClass, false, true) : Collections.emptyMap();
        }
        return this.m_extraProps;
    }

    public static Map<String, PropertyInfo> getPropertyInfos(Object bean) {
        return PropertyIterator.getPropertyInfos(bean.getClass());
    }

    public static Map<String, PropertyInfo> getPropertyInfos(Class beanClass) {
        PropertyIterator iter = new PropertyIterator(beanClass, null);
        return iter.getPropertyInfos();
    }

    public static Iterator<PropertyInfo> getPropertyIterator(Object bean) {
        return PropertyIterator.getPropertyIterator(bean.getClass());
    }

    public static Iterator<PropertyInfo> getPropertyIterator(Class beanClz) {
        PropertyIterator iter = new PropertyIterator(beanClz, null);
        return iter.getPropertyIterator();
    }
}

