/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.refactoring;

import oracle.javatools.db.DBException;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;

public abstract class RefactoringProcessor
extends UpdateProcessor {
    public final void processUpdate(DBObjectTransaction txn, Difference objDiff) throws DBException {
        this.processObjectDifference(txn, objDiff);
    }

    protected void processObjectDifference(DBObjectTransaction txn, Difference objDiff) throws DBException {
        SystemObject old = (SystemObject)objDiff.getOriginalObject();
        SystemObject upd = (SystemObject)objDiff.getUpdatedObject();
        if (old == null && upd == null) {
            throw new DBException(null, "operation must be create, update or delete");
        }
        if (old == null) {
            this.processObjectCreate(txn, upd);
        } else if (upd == null) {
            this.processObjectDelete(txn, old);
        } else if (!objDiff.isSame()) {
            this.processObjectUpdate(txn, objDiff);
        }
    }

    protected void processObjectCreate(DBObjectTransaction txn, SystemObject obj) throws DBException {
    }

    protected void processObjectDelete(DBObjectTransaction txn, SystemObject obj) throws DBException {
    }

    protected void processObjectUpdate(DBObjectTransaction txn, Difference objDiff) throws DBException {
    }
}

