/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDBObjectUsage
extends AbstractFromObjectUsage
implements DBObjectUsage {
    private transient DBObjectProvider m_pro;

    protected AbstractDBObjectUsage() {
    }

    protected AbstractDBObjectUsage(DBObjectID id, DBObjectID fromID) {
        super(fromID);
        this.setObjectID(id);
    }

    public void setProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public void setObjectID(DBObjectID objectID) {
        this.setProperty("objectID", objectID);
    }

    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    public String getColumnName() {
        DBObjectID objectID = this.getObjectID();
        String retval = null;
        if (objectID != null) {
            String name;
            if (objectID instanceof BaseObjectID && ModelUtil.hasLength((String)(name = ((BaseObjectID)objectID).getName()))) {
                retval = this.getExternalName(name);
            }
            if (!ModelUtil.hasLength(retval)) {
                try {
                    DBObject obj = objectID.resolveID();
                    if (obj != null) {
                        retval = this.getExternalName(obj.getName());
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger().log(Level.WARNING, "Couldn't resolve ID to get SQL text: " + dbe.getMessage());
                }
            }
        }
        return retval;
    }

    protected String getExternalName(String name) {
        if (this.m_pro != null) {
            return this.m_pro.getExternalName(name);
        }
        return name;
    }

    protected void copyToImpl(AbstractDBObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        ((AbstractDBObjectUsage)target).m_pro = this.m_pro;
    }
}

