/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSchemaObjectUsage
extends AbstractSQLFragment
implements DBObjectUsage {
    private transient DBObjectProvider m_pro;

    public AbstractSchemaObjectUsage() {
    }

    public AbstractSchemaObjectUsage(DBObjectID id) {
        this.setObjectID(id);
    }

    public void setProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public void setObjectID(DBObjectID id) {
        this.setProperty("objectID", id);
    }

    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    public String getSQLText() {
        DBObjectID objectID = this.getObjectID();
        if (objectID != null) {
            DatabaseDescriptor desc;
            String dbName = null;
            String schema = null;
            String name = null;
            if (objectID instanceof BaseObjectID) {
                dbName = ((BaseObjectID)objectID).getDatabaseName();
                schema = ((BaseObjectID)objectID).getSchemaName();
                name = ((BaseObjectID)objectID).getName();
            }
            if (!ModelUtil.hasLength(schema) || !ModelUtil.hasLength(name)) {
                try {
                    SchemaObject obj = (SchemaObject)objectID.resolveID();
                    if (obj != null) {
                        name = obj.getName();
                        Schema s = obj.getSchema();
                        if (s != null) {
                            schema = s.getName();
                            if (s.getID() instanceof BaseObjectID) {
                                dbName = ((BaseObjectID)s.getID()).getDatabaseName();
                            }
                        }
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger(this).log(Level.WARNING, "Couldn't resolve ID for SQL: " + dbe.getMessage());
                }
            }
            StringBuilder buff = new StringBuilder();
            DatabaseDescriptor databaseDescriptor = desc = this.m_pro == null ? null : this.m_pro.getDescriptor();
            if (schema != null && this.isInDifferentSchema(schema) && (desc == null || !desc.areNamesEqual(schema, desc.getPublicSchemaName(), "SCHEMA", false))) {
                buff.append(this.getExternalName(schema)).append(".");
            }
            buff.append(this.getExternalName(name));
            if (ModelUtil.hasLength((String)dbName)) {
                buff.append("@").append(dbName);
            }
            return buff.toString();
        }
        return null;
    }

    private boolean isInDifferentSchema(String schemaName) {
        boolean retval = false;
        Schema ourSchema = DBUtil.getSchema(this);
        if (ourSchema != null) {
            retval = this.m_pro == null ? !ourSchema.getName().equals(schemaName) : !this.m_pro.getDescriptor().areNamesEqual(ourSchema.getName(), schemaName, "SCHEMA", false);
        }
        return retval;
    }

    protected String getExternalName(String name) {
        if (this.m_pro != null) {
            return this.m_pro.getExternalName(name);
        }
        return name;
    }

    protected void copyToImpl(AbstractDBObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        ((AbstractSchemaObjectUsage)target).m_pro = this.m_pro;
    }
}

