/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;

public class ArithmeticOperation
extends Operation {
    public ArithmeticOperation() {
        this(ArithmeticOperator.ADD, null);
    }

    public ArithmeticOperation(ArithmeticOperator operator, SQLFragment[] args) {
        this.setArguments(args);
        this.setOperator(operator);
        this.setFunctionFormat(false);
    }

    public ArithmeticOperator getOperator() {
        return (ArithmeticOperator)((Object)this.getProperty("operator"));
    }

    public void setOperator(ArithmeticOperator operator) {
        this.setProperty("operator", (Object)operator);
        this.setCommutative(operator == null ? false : operator.isCommutative());
    }

    public String getSQLText() {
        String retval = null;
        ArithmeticOperator op = this.getOperator();
        if (ArithmeticOperator.NEGATE == op) {
            retval = this.getOperatorText() + this.getArguments()[0].getSQLText();
        } else if (op != null) {
            StringBuilder buff = new StringBuilder();
            SQLFragment[] args = this.getArguments();
            int precedence = op.m_precedence;
            for (int i = 0; i < args.length; ++i) {
                ArithmeticOperator subOp;
                int subExprPrec;
                boolean addBrackets = false;
                if (args[i] instanceof ArithmeticOperation && ((subExprPrec = (subOp = ((ArithmeticOperation)args[i]).getOperator()) == null ? 1000 : subOp.m_precedence) < precedence || i > 0 && subExprPrec == precedence && op != subOp && (op == ArithmeticOperator.SUBTRACT || op == ArithmeticOperator.DIVIDE))) {
                    addBrackets = true;
                }
                String argText = this.getTextOrNull(args[i]);
                if (addBrackets) {
                    argText = this.surroundWithBrackets(argText, true);
                }
                buff.append(argText);
                if (i >= args.length - 1) continue;
                buff.append(" ");
                buff.append(this.getOperatorText());
                buff.append(" ");
            }
            retval = buff.toString();
        }
        return retval;
    }

    public String getOperatorText() {
        ArithmeticOperator op = this.getOperator();
        return op == null ? null : op.getSQLText();
    }

    protected boolean equalsImpl(AbstractDBObject target) {
        ArithmeticOperator op;
        ArithmeticOperation other = (ArithmeticOperation)target;
        boolean retval = super.equalsImpl(other);
        if (!retval && (op = this.getOperator()) != null && op.isCommutative() && op == other.getOperator() && this.getArgumentCount() == 2 && other.getArgumentCount() == 2) {
            retval = this.getArguments()[0].equals(other.getArguments()[1]) && this.getArguments()[1].equals(other.getArguments()[0]);
        }
        return retval;
    }

    public DBObjectID getDataTypeID() {
        DBObjectID ret = null;
        if (this.getArguments()[0] instanceof SQLFragmentWithDatatype) {
            ret = ((SQLFragmentWithDatatype)this.getArguments()[0]).getDataTypeID();
        }
        if (ret == null && this.getArguments()[1] instanceof SQLFragmentWithDatatype) {
            ret = ((SQLFragmentWithDatatype)this.getArguments()[1]).getDataTypeID();
        }
        return ret;
    }

    public static ArithmeticOperator getArithmeticOperator(String sql, int operandCount) {
        ArithmeticOperator retval = null;
        for (ArithmeticOperator op : ArithmeticOperator.values()) {
            if (!op.getSQLText().equals(sql)) continue;
            retval = op;
            break;
        }
        if (retval == ArithmeticOperator.SUBTRACT && operandCount == 1) {
            retval = ArithmeticOperator.NEGATE;
        } else if (retval == ArithmeticOperator.NEGATE && operandCount == 2) {
            retval = ArithmeticOperator.SUBTRACT;
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArithmeticOperator {
        ADD("+", true, 1, 10),
        SUBTRACT("-", false, 1, 11),
        MULTIPLY("*", true, 2, 12),
        DIVIDE("/", false, 2, 13),
        NEGATE("-", false, 3, 14);

        private final String m_sql;
        private final boolean m_commutative;
        private final int m_oldValue;
        private final int m_precedence;

        private ArithmeticOperator(String sql, boolean commutative, int precedence, int oldValue) {
            this.m_sql = sql;
            this.m_commutative = commutative;
            this.m_precedence = precedence;
            this.m_oldValue = oldValue;
        }

        public String getSQLText() {
            return this.m_sql;
        }

        public boolean isCommutative() {
            return this.m_commutative;
        }

        public static ArithmeticOperator migrate(String old) {
            ArithmeticOperator retval = null;
            if (old != null) {
                for (ArithmeticOperator op : ArithmeticOperator.values()) {
                    if (!old.equals(String.valueOf(op.m_oldValue))) continue;
                    retval = op;
                    break;
                }
            }
            return retval;
        }
    }
}

