/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.property.Transient;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class Comparison
extends Operation {
    public Comparison() {
        this(null, Comparator.EQUAL);
    }

    public Comparison(SQLFragment left, Comparator comparator) {
        this(left, comparator, null);
    }

    public Comparison(Comparator comparator, SQLFragment[] argsL) {
        this.setFunctionFormat(true);
        this.setComparator(comparator);
        this.setArguments(argsL);
    }

    public Comparison(SQLFragment left, Comparator comparator, SQLFragment right) {
        this.setFunctionFormat(false);
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setComparator(comparator);
    }

    public Comparator getComparator() {
        return (Comparator)((Object)this.getProperty("comparator"));
    }

    public String getOperatorText() {
        Comparator comp = this.getComparator();
        return comp == null ? null : comp.getSQLText();
    }

    public void setComparator(Comparator comparator) {
        this.setProperty("comparator", (Object)comparator);
    }

    public SQLFragment getLeftExpression() {
        return (SQLFragment)this.getProperty("leftExpression");
    }

    public void setLeftExpression(SQLFragment leftExpression) {
        this.setProperty("leftExpression", leftExpression);
    }

    public SQLFragment getRightExpression() {
        return (SQLFragment)this.getProperty("rightExpression");
    }

    public void setRightExpression(SQLFragment rightExpression) {
        this.setProperty("rightExpression", rightExpression);
    }

    public void setPriorOnLeft(boolean priorOnLeft) {
        this.setProperty("priorOnLeft", priorOnLeft);
    }

    public boolean getPriorOnLeft() {
        return (Boolean)this.getProperty("priorOnLeft", false);
    }

    public void setPriorOnRight(boolean priorOnRight) {
        this.setProperty("priorOnRight", priorOnRight);
    }

    public boolean getPriorOnRight() {
        return (Boolean)this.getProperty("priorOnRight", false);
    }

    protected void checkNewSize(int proposedSize) {
        if (proposedSize != 2 && proposedSize != 1) {
            throw new IllegalArgumentException(APIBundle.get("SQL_COMPARISON_ARGS"));
        }
    }

    public String getSQLText() {
        Comparator comp = this.getComparator();
        if (comp == Comparator.REGEXP_LIKE) {
            return super.getSQLText();
        }
        if (comp == Comparator.NULL || comp == Comparator.NOT_NULL) {
            return this.getTextOrNull(this.getArguments()[0]) + " " + comp.getSQLText();
        }
        if (comp == Comparator.EXISTS || comp == Comparator.NOT_EXISTS) {
            return comp.getSQLText() + " " + this.getTextOrNull(this.getArguments()[0], true);
        }
        return this.buildComparisson();
    }

    public void addArgument(int index, SQLFragment expression) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    public void addArgument(SQLFragment expression) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    public void addArguments(SQLFragment[] expressions) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    public int getArgumentCount() {
        return this.getRightExpression() == null ? 1 : 2;
    }

    @Transient
    public void setArguments(SQLFragment[] arguments) {
        if (arguments != null && arguments.length > 0) {
            this.setLeftExpression(arguments[0]);
            if (arguments.length > 1) {
                this.setRightExpression(arguments[1]);
            }
        }
    }

    public boolean removeArgument(SQLFragment expression) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    public SQLFragment[] getArguments() {
        return new SQLFragment[]{this.getLeftExpression(), this.getRightExpression()};
    }

    private String buildComparisson() {
        StringBuffer retval = new StringBuffer();
        String lexp = this.getTextOrNull(this.getLeftExpression());
        String rexp = this.getTextOrNull(this.getRightExpression());
        String compop = this.getOperatorText();
        boolean priorOnLeft = this.getPriorOnLeft();
        boolean priorOnRight = this.getPriorOnRight();
        if (priorOnLeft) {
            retval.append("PRIOR").append(" ");
        }
        retval.append(lexp).append(" ");
        retval.append(compop).append(" ");
        if (priorOnRight) {
            retval.append("PRIOR").append(" ");
        }
        retval.append(rexp);
        return retval.toString();
    }

    public static Comparator getComparator(String sql) {
        Comparator retval = null;
        for (Comparator comp : Comparator.values()) {
            if (!comp.getSQLText().equals(sql)) continue;
            retval = comp;
            break;
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Comparator {
        GREATER(">", 1),
        LESS("<", 2),
        GREATER_EQUAL(">=", 3),
        LESS_EQUAL("<=", 4),
        EQUAL("=", 5),
        NOT_EQUAL("!=", 6),
        NULL("IS NULL", 43),
        NOT_NULL("IS NOT NULL", 44),
        LIKE("LIKE", 26),
        NOT_LIKE("NOT LIKE", 27),
        REGEXP_LIKE("REGEXP_LIKE", 524),
        EXISTS("EXISTS", 10004),
        NOT_EXISTS("NOT EXISTS", 10005),
        EQUAL_ANY("=ANY", 729),
        NOT_EQUAL_ANY("!=ANY", 732),
        GREATER_THAN_ANY(">ANY", 733),
        GREATER_THAN_OR_EQUAL_ANY(">=ANY", 734),
        LESS_THAN_ANY("<ANY", 735),
        LESS_THAN_OR_EQUAL_ANY("<=ANY", 736),
        EQUAL_SOME("=SOME", 737),
        NOT_EQUAL_SOME("!=SOME", 738),
        GREATER_THAN_SOME(">SOME", 739),
        GREATER_THAN_OR_EQUAL_SOME(">=SOME", 740),
        LESS_THAN_SOME("<SOME", 741),
        LESS_THAN_OR_EQUAL_SOME("<=SOME", 742),
        EQUAL_ALL("=ALL", 743),
        NOT_EQUAL_ALL("!=ALL", 744),
        GREATER_THAN_ALL(">ALL", 745),
        GREATER_THAN_OR_EQUAL_ALL(">=ALL", 746),
        LESS_THAN_ALL("<ALL", 747),
        LESS_THAN_OR_EQUAL_ALL("<=ALL", 748);

        private final String m_sql;
        private final int m_oldValue;

        private Comparator(String sql, int oldValue) {
            this.m_sql = sql;
            this.m_oldValue = oldValue;
        }

        public String getSQLText() {
            return this.m_sql;
        }

        public static Comparator migrate(String old) {
            Comparator retval = null;
            if (old != null) {
                for (Comparator op : Comparator.values()) {
                    if (!old.equals(String.valueOf(op.m_oldValue))) continue;
                    retval = op;
                    break;
                }
            }
            return retval;
        }
    }
}

