/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class DataMiningFunction
extends Operation {
    public DataMiningFunction() {
        this(null, null, false, null, null);
    }

    @Deprecated
    public DataMiningFunction(String function, SQLFragment model, boolean cost, SQLFragment[] dmSpecificArgs, SQLFragment[] usingArgs) {
        super(usingArgs);
        this.setFunctionFormat(true);
        this.setFunction(function);
        this.setModel(model);
        this.setCostModel(cost);
        this.setDmSpecificArgs(dmSpecificArgs);
    }

    public DataMiningFunction(String function, SQLFragment model, SQLFragment[] dmCostArgs, SQLFragment[] dmSpecificArgs, SQLFragment[] usingArgs) {
        super(usingArgs);
        this.setFunctionFormat(true);
        this.setFunction(function);
        this.setModel(model);
        if (dmCostArgs != null) {
            if (dmCostArgs.length == 1) {
                SQLFragment cost = dmCostArgs[0];
                this.setCostModel(true);
                if ("AUTO".equalsIgnoreCase(cost.getSQLText())) {
                    this.setCostModelAuto(true);
                }
            } else {
                this.setDmCostValues(dmCostArgs);
            }
        }
        this.setDmSpecificArgs(dmSpecificArgs);
    }

    public String getFunction() {
        return (String)this.getProperty("function");
    }

    public void setFunction(String function) {
        this.setProperty("function", function);
    }

    public boolean getCostModel() {
        return (Boolean)this.getProperty("costModel", false);
    }

    public void setCostModel(boolean costModel) {
        this.setProperty("costModel", costModel);
    }

    public boolean getCostModelAuto() {
        return (Boolean)this.getProperty("costModelAuto", false);
    }

    public void setCostModelAuto(boolean costModelAuto) {
        this.setProperty("costModelAuto", costModelAuto);
    }

    public SQLFragment getModel() {
        return (SQLFragment)this.getProperty("model");
    }

    public void setModel(SQLFragment model) {
        this.setProperty("model", model);
    }

    @Deprecated
    @Transient
    public DataMiningArguments getDataMiningArguments() {
        return new DataMiningArguments(this.getDmSpecificArgs());
    }

    @Deprecated
    public void setDataMiningArguments(DataMiningArguments dataMiningArguments) {
        this.setDmSpecificArgs(dataMiningArguments == null ? null : dataMiningArguments.getArguments());
    }

    protected String getOperatorText() {
        return this.getFunction();
    }

    private boolean isSymbolFunction(String function) {
        for (int i = 0; i < function.length(); ++i) {
            if (!Character.isLetterOrDigit(function.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public SQLFragment[] getDmCostValues() {
        return this.getChildSupport("dmCostValues").getChildArray(SQLFragment.class);
    }

    public void setDmCostValues(SQLFragment[] arguments) {
        this.getChildSupport("dmCostValues").setChildArray(arguments);
    }

    public SQLFragment[] getDmSpecificArgs() {
        return this.getChildSupport("dmSpecificArgs").getChildArray(SQLFragment.class);
    }

    public void setDmSpecificArgs(SQLFragment[] arguments) {
        this.getChildSupport("dmSpecificArgs").setChildArray(arguments);
    }

    public String getSQLText() {
        String sep = this.getSeparator();
        StringBuilder sqltext = new StringBuilder(this.getOperatorText() + "( ");
        SQLFragment model = this.getModel();
        sqltext.append(this.getTextOrNull(model));
        String argsText = this.argsToString(this.getChildSupport("dmSpecificArgs").getChildList(false), false, this.getSeparator(), 0);
        if (ModelUtil.hasLength((String)argsText)) {
            sqltext.append(sep + " ").append(argsText);
        }
        if (this.getCostModel()) {
            sqltext.append(" COST MODEL ");
            if (this.getCostModelAuto()) {
                sqltext.append("AUTO ");
            }
        } else {
            SQLFragment[] costValues = this.getDmCostValues();
            if (costValues != null && costValues.length > 0) {
                String costClassValues = costValues[0].getSQLText();
                sqltext.append(" COST ").append(costClassValues);
                sqltext.append(" VALUES ( ");
                for (int i = 1; i < costValues.length; ++i) {
                    if (i > 1) {
                        sqltext.append(", ");
                    }
                    sqltext.append(costValues[i].getSQLText());
                }
                sqltext.append(" ) ");
            }
        }
        sqltext.append(" USING ");
        sqltext.append(this.argsToString(Arrays.asList(this.getArguments()), false, sep, 0));
        sqltext.append(" )");
        return sqltext.toString();
    }

    @Deprecated
    public static class DataMiningArguments
    extends AbstractSQLFragment {
        public DataMiningArguments() {
        }

        public DataMiningArguments(SQLFragment[] args) {
            this.setArguments(args);
        }

        public SQLFragment[] getArguments() {
            return this.getChildSupport("arguments").getChildArray(SQLFragment.class);
        }

        public void setArguments(SQLFragment[] args) {
            this.getChildSupport("arguments").setChildArray(args);
        }

        private DataMiningFunction getDMFunction() {
            return (DataMiningFunction)this.getParent();
        }

        public String getSQLText() {
            DataMiningFunction par = this.getDMFunction();
            if (par != null) {
                return par.argsToString(this.getChildSupport("arguments").getChildList(false), false, par.getSeparator(), 0);
            }
            return null;
        }
    }

    public static class DataMiningCostValues
    extends AbstractSQLFragment {
        public DataMiningCostValues() {
        }

        public DataMiningCostValues(SQLFragment[] args) {
            this.setArguments(args);
        }

        public SQLFragment[] getArguments() {
            return this.getChildSupport("arguments").getChildArray(SQLFragment.class);
        }

        public void setArguments(SQLFragment[] args) {
            this.getChildSupport("arguments").setChildArray(args);
        }

        public String getSQLText() {
            return "( " + this.argsToString(this.getChildSupport("arguments").getChildList(false), false, ",", 0) + " )";
        }
    }
}

