/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.WhereObject;

public class FKUsage
extends AbstractSQLFragment
implements DBObjectUsage {
    private transient DBObjectProvider m_pro;

    public FKUsage() {
    }

    public FKUsage(DBObjectID fkID, DBObjectID leftID, DBObjectID rightID) {
        this.setObjectID(fkID);
        this.setLeftFromObjectID(leftID);
        this.setRightFromObjectID(rightID);
    }

    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    public void setObjectID(DBObjectID fkid) {
        this.setProperty("objectID", fkid);
    }

    @Deprecated
    @Transient
    public FromObject getLeftFromObject() {
        return null;
    }

    @Deprecated
    @Transient
    public void setLeftFromObject(FromObject obj) {
        this.setLeftFromObjectID(obj != null ? obj.getID() : null);
    }

    public DBObjectID getLeftFromObjectID() {
        return (DBObjectID)this.getProperty("leftFromObjectID");
    }

    public void setLeftFromObjectID(DBObjectID leftID) {
        this.setProperty("leftFromObjectID", leftID);
    }

    public DBObjectID getRightFromObjectID() {
        return (DBObjectID)this.getProperty("rightFromObjectID");
    }

    public void setRightFromObjectID(DBObjectID rightID) {
        this.setProperty("rightFromObjectID", rightID);
    }

    @Deprecated
    @Transient
    public FromObject getRightFromObject() {
        return null;
    }

    @Deprecated
    @Transient
    public void setRightFromObject(FromObject obj) {
        this.setRightFromObjectID(obj != null ? obj.getID() : null);
    }

    public FromObject resolveLeftFromObject() {
        return this.resolveFromObject(this.getLeftFromObjectID());
    }

    public FromObject resolveRightFromObject() {
        return this.resolveFromObject(this.getRightFromObjectID());
    }

    private FromObject resolveFromObject(DBObjectID id) {
        FromObject ret = null;
        try {
            if (id != null) {
                ret = (FromObject)id.resolveID();
            }
        }
        catch (DBException e) {
            DBLog.logStackTrace(e);
        }
        return ret;
    }

    public String getSQLText() {
        StringBuilder buff = new StringBuilder();
        DBObjectID fkID = this.getObjectID();
        if (fkID != null) {
            try {
                DBObjectID[] rightCols;
                DBObjectID[] leftCols;
                DBObjectID leftRelationId;
                FKConstraint fk = (FKConstraint)fkID.resolveID();
                FromObject left = this.resolveLeftFromObject();
                FromObject right = this.resolveRightFromObject();
                if (fk == null) {
                    DBLog.log("FKUsage: Cannot resolve id " + fkID, new Object[0]);
                }
                if (left == null) {
                    DBLog.log("FKUsage: Cannot resolve left from id " + this.getLeftFromObjectID(), new Object[0]);
                }
                if (right == null) {
                    DBLog.log("FKUsage: Cannot resolve right from id " + this.getRightFromObjectID(), new Object[0]);
                }
                DBObjectID ref = fk.getReferenceID();
                UniqueConstraint refC = (UniqueConstraint)ref.resolveID();
                if (refC == null) {
                    DBLog.log("FKUsage: Cannot resolve referenced id " + fkID + " on fk " + fk.getName(), new Object[0]);
                }
                DBObjectID refRelationId = refC.getRelation().getID();
                SQLFragment leftExp = left.getExpression();
                DBObjectID dBObjectID = leftRelationId = leftExp instanceof RelationUsage ? ((RelationUsage)leftExp).getObjectID() : null;
                if (leftRelationId != null && refRelationId != null && leftRelationId.equals(refRelationId)) {
                    leftCols = refC.getColumnIDs();
                    rightCols = fk.getColumnIDs();
                } else {
                    leftCols = fk.getColumnIDs();
                    rightCols = refC.getColumnIDs();
                }
                for (int i = 0; i < leftCols.length; ++i) {
                    buff.append(left.getUsableAlias());
                    buff.append(".");
                    String leftName = DBUtil.getDBObjectName(leftCols[i]);
                    if (this.m_pro != null) {
                        leftName = this.m_pro.getExternalName(leftName);
                    }
                    buff.append(leftName);
                    buff.append(" ");
                    buff.append(Comparison.Comparator.EQUAL.getSQLText());
                    buff.append(" ");
                    buff.append(right.getUsableAlias());
                    buff.append(".");
                    String rightName = DBUtil.getDBObjectName(rightCols[i]);
                    if (this.m_pro != null) {
                        rightName = this.m_pro.getExternalName(rightName);
                    }
                    buff.append(rightName);
                    if (i >= leftCols.length - 1) continue;
                    buff.append(" ");
                    buff.append(WhereObject.WhereOperator.AND.getSQLText());
                    buff.append(" ");
                }
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
            }
        } else {
            buff.append(fkID);
        }
        return buff.toString();
    }

    public void setProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    protected void copyToImpl(AbstractDBObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        ((FKUsage)target).m_pro = this.m_pro;
    }
}

