/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class Function
extends Operation {
    public Function() {
        this((String)null, (SQLFragment[])null);
    }

    public Function(String function, SQLFragment[] arguments) {
        this(function, arguments, false);
    }

    public Function(String function, SQLFragment[] arguments, String separator) {
        this(function, arguments, separator, false);
    }

    public Function(String function, SQLFragment[] arguments, boolean grouping) {
        this(function, arguments, ", ", grouping);
    }

    public Function(String function, SQLFragment[] arguments, String separator, boolean grouping) {
        super(arguments);
        this.setFunctionFormat(true);
        this.setSeparator(separator);
        this.setGrouping(grouping);
        this.setDistinct(false);
        this.setFunction(function);
    }

    public String getFunction() {
        return (String)this.getProperty("function");
    }

    public void setFunction(String function) {
        if (this.isSymbolFunction(function)) {
            this.setFunctionFormat(false);
            this.setSeparator(null);
            this.setCommutative(true);
        } else {
            this.setFunctionFormat(true);
        }
        this.setProperty("function", function);
    }

    public boolean isGrouping() {
        return (Boolean)this.getProperty("grouping", false);
    }

    public void setGrouping(boolean grouping) {
        this.setProperty("grouping", grouping);
    }

    public boolean isDistinct() {
        return (Boolean)this.getProperty("distinct", false);
    }

    public void setDistinct(boolean distinct) {
        this.setProperty("distinct", distinct);
    }

    public String getTrimLeader() {
        return (String)this.getProperty("trimLeader");
    }

    public void setTrimLeader(String trimLeader) {
        this.setProperty("trimLeader", trimLeader);
    }

    public String getDistinctSource() {
        return (String)this.getProperty("distinctSource");
    }

    public void setDistinctSource(String distinctSource) {
        this.setProperty("distinctSource", distinctSource);
    }

    protected String getDistinctText() {
        String result = "";
        if (this.isGrouping() && ModelUtil.hasLength((String)this.getDistinctSource())) {
            result = this.getDistinctSource() + " ";
        } else if (ModelUtil.hasLength((String)this.getTrimLeader())) {
            result = this.getTrimLeader() + " ";
        }
        return result;
    }

    protected String getOperatorText() {
        return this.getFunction();
    }

    private boolean isSymbolFunction(String function) {
        if (ModelUtil.hasLength((String)function)) {
            for (int i = 0; i < function.length(); ++i) {
                if (!Character.isLetterOrDigit(function.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public String getSeparator() {
        return super.getSeparator();
    }

    public void setSeparator(String string) {
        super.setSeparator(string);
    }

    public void setDataTypeID(DBObjectID dataTypeID) {
        this.setProperty("dataTypeID", dataTypeID);
    }

    public DBObjectID getDataTypeID() {
        return (DBObjectID)this.getProperty("dataTypeID");
    }
}

