/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLCallable;

public class FunctionUsage
extends Operation
implements DBObjectUsage {
    private DBObjectProvider m_pro;

    public FunctionUsage() {
        this.setFunctionFormat(true);
    }

    protected String getOperatorText() {
        return this.getFunction();
    }

    public String getFunction() {
        String defSchemaName = null;
        for (DBObject obj = this; obj != null; obj = obj.getParent()) {
            if (obj instanceof Schema) {
                defSchemaName = ((Schema)obj).getName();
                break;
            }
            if (!(obj instanceof SchemaObject) || ((SchemaObject)obj).getSchema() == null) continue;
            defSchemaName = ((SchemaObject)obj).getSchema().getName();
            break;
        }
        String schemaName = null;
        StringBuffer sb = new StringBuffer();
        for (DBObjectID id = this.getObjectID(); id != null; id = id.getParent()) {
            String name;
            if (id instanceof BaseObjectID) {
                BaseObjectID bid = (BaseObjectID)id;
                name = bid.getName();
                if (this.m_pro != null) {
                    name = this.m_pro.getExternalName(name);
                }
                sb.insert(0, name);
                sb.insert(0, ".");
                schemaName = bid.getSchemaName();
                continue;
            }
            DBObject dbo = null;
            try {
                dbo = id.resolveID();
                name = dbo.getName();
                if (this.m_pro != null) {
                    name = this.m_pro.getExternalName(name);
                }
                sb.insert(0, name);
                sb.insert(0, ".");
                if (!(dbo instanceof SchemaObject) || ((SchemaObject)dbo).getSchema() == null) continue;
                schemaName = ((SchemaObject)dbo).getSchema().getName();
                continue;
            }
            catch (DBException dbe) {
                DBLog.logStackTrace(dbe);
            }
        }
        int offset = 1;
        if (schemaName != null && !schemaName.equals(defSchemaName)) {
            if (this.m_pro != null) {
                schemaName = this.m_pro.getExternalName(schemaName);
            }
            sb.insert(0, schemaName);
            offset = 0;
        }
        if (offset > sb.length()) {
            offset = sb.length();
        }
        return sb.substring(offset);
    }

    public void setObjectID(DBObjectID objectID) {
        this.setProperty("objectID", objectID);
    }

    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    public void setProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public DBObjectID getDataTypeID() {
        DBObjectID ret = null;
        DBObjectID objId = this.getObjectID();
        if (objId != null) {
            DBObject obj;
            try {
                obj = objId.resolveID();
            }
            catch (DBException e) {
                obj = null;
            }
            if (obj instanceof PlSqlSubProgram) {
                ret = ((PlSqlSubProgram)obj).getReturnTypeID();
            }
        }
        return ret;
    }

    protected String surroundWithBrackets(String text, boolean force) {
        boolean surround = true;
        if (this.getArgumentCount() == 0) {
            DBObjectID fid = this.getObjectID();
            try {
                DBObject func = fid.resolveID();
                if (func instanceof SQLCallable && !((SQLCallable)((Object)func)).isParenthesesRequired()) {
                    surround = false;
                }
            }
            catch (DBException e) {
                DBLog.getLogger(this).warning(e.getMessage());
            }
        }
        if (surround) {
            return super.surroundWithBrackets(text, force);
        }
        return text;
    }

    protected void copyToImpl(AbstractDBObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        ((FunctionUsage)target).m_pro = this.m_pro;
    }
}

