/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBUtil;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;

public class IndexObject
extends AbstractSQLFragment {
    public static final String TYPE = "IndexObject";
    @Deprecated
    public static final String ASC = "ASC";
    @Deprecated
    public static final String DESC = "DESC";

    public IndexObject() {
    }

    public IndexObject(SQLFragment exp) {
        this(exp, (OrderType)null);
    }

    @Deprecated
    public IndexObject(SQLFragment exp, String ordering) {
        this(exp);
        this.setOrder(ordering);
    }

    public IndexObject(SQLFragment exp, OrderType orderType) {
        if (exp != null) {
            this.setExpressionSource(exp.getSQLText());
            this.setExpression(exp);
        }
        this.setOrderType(orderType);
    }

    public String getType() {
        return TYPE;
    }

    @Deprecated
    public String getOrder() {
        OrderType orderType = this.getOrderType();
        return orderType == null ? null : orderType.toString();
    }

    @Deprecated
    @Transient
    public void setOrder(String order) {
        OrderType orderType;
        if (order == null) {
            orderType = null;
        } else if (order.equals(ASC) || order.equals(DESC)) {
            orderType = OrderType.valueOf(order);
        } else {
            Object orderType2 = null;
            throw new IllegalArgumentException(APIBundle.format("SQL_INVALID_ORDERING", order));
        }
        this.setOrderType(orderType);
    }

    public OrderType getOrderType() {
        return (OrderType)((Object)this.getProperty("orderType"));
    }

    public void setOrderType(OrderType orderType) {
        this.setProperty("orderType", (Object)orderType);
    }

    public String getExpressionSource() {
        SQLFragment frag;
        String retval = (String)this.getProperty("expressionSource");
        if (retval == null && (frag = (SQLFragment)DBUtil.getFrozenProperties(this).get("expression")) != null) {
            retval = frag.getSQLText();
        }
        return retval;
    }

    public void setExpressionSource(String exp) {
        this.setProperty("expressionSource", exp);
    }

    @Derived(value="expressionSource")
    public SQLFragment getExpression() {
        return (SQLFragment)this.getProperty("expression");
    }

    @Transient
    public void setExpression(SQLFragment exp) {
        this.setProperty("expression", exp);
    }

    public String getSQLText() {
        String exp = this.getExpressionSource();
        OrderType order = this.getOrderType();
        return exp + (order == null ? "" : " " + order.toString());
    }

    @Transient
    public String getName() {
        String retval = super.getName();
        if (retval == null) {
            retval = this.getExpressionSource();
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrderType {
        ASC,
        DESC;

    }
}

