/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class OrderByObject
extends AbstractSQLFragment {
    public static final String TYPE = "ORDER BY";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final String NULLS_FIRST = "NULLS FIRST";
    public static final String NULLS_LAST = "NULLS LAST";

    public OrderByObject() {
    }

    public OrderByObject(SQLFragment exp) {
        this.setExpression(exp);
    }

    public OrderByObject(SQLFragment exp, String ordering) {
        this.setExpression(exp);
        this.setOrder(ordering);
    }

    public OrderByObject(SQLFragment exp, String ordering, String nullsOrder) {
        this.setExpression(exp);
        this.setOrder(ordering);
        this.setNullOrdering(nullsOrder);
    }

    public String getType() {
        return TYPE;
    }

    public String getOrder() {
        return (String)this.getProperty("order");
    }

    public void setOrder(String order) {
        if (ModelUtil.hasLength((String)order) && !order.equalsIgnoreCase(ASC) && !order.equalsIgnoreCase(DESC)) {
            throw new IllegalArgumentException(APIBundle.format("SQL_INVALID_ORDERING", order));
        }
        this.setProperty("order", order);
    }

    public String getNullOrdering() {
        return (String)this.getProperty("nullOrdering");
    }

    public void setNullOrdering(String nullOrdering) {
        if (ModelUtil.hasLength((String)nullOrdering)) {
            nullOrdering = nullOrdering.replaceAll("\\s+", " ");
        }
        if (ModelUtil.hasLength((String)nullOrdering) && !nullOrdering.equalsIgnoreCase(NULLS_FIRST) && !nullOrdering.equalsIgnoreCase(NULLS_LAST)) {
            throw new IllegalArgumentException(APIBundle.format("SQL_INVALID_NULL_ORDERING", nullOrdering));
        }
        this.setProperty("nullOrdering", nullOrdering);
    }

    public SQLFragment getExpression() {
        return (SQLFragment)this.getProperty("expression");
    }

    public void setExpression(SQLFragment exp) {
        this.setProperty("expression", exp);
    }

    public String getSQLText() {
        SQLFragment exp = this.getExpression();
        String order = this.getOrder();
        String nullOrdering = this.getNullOrdering();
        return this.getTextOrNull(exp) + (order == null ? "" : " " + order) + (nullOrdering == null ? "" : " " + nullOrdering);
    }
}

